/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.basex.data.DataText;
import org.basex.io.serial.DOTData;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryException;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class DOTSerializer
extends OutputSerializer {
    private final boolean compact;
    private final ArrayList<IntList> children = new ArrayList();
    private final TokenBuilder tb = new TokenBuilder();
    private final IntList nodes = new IntList();
    private int count;

    public DOTSerializer(OutputStream os, boolean c) throws IOException {
        super(os, PROPS, new String[0]);
        this.compact = c;
        this.print(DOTData.HEADER);
    }

    @Override
    protected void startOpen(byte[] t) {
        this.tb.reset();
    }

    @Override
    public void attribute(byte[] n, byte[] v) {
        this.tb.addExt("\\n%: %", n, v);
    }

    @Override
    protected void finishOpen() throws IOException {
        byte[] attr = this.tb.finish();
        String color = DOTData.color(this.elem);
        if (color == null) {
            color = attr.length == 0 ? "303030" : "909090";
        }
        this.print(Token.concat(this.elem, attr), color);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.finishOpen();
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        int c = this.nodes.get(this.level);
        IntList il = this.child(this.level);
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            this.indent();
            this.print(Util.info("node% -> node%;", c, il.get(i)));
        }
        il.reset();
    }

    @Override
    public void finishText(byte[] t) throws IOException {
        this.print(Token.norm(t), "6666FF");
    }

    @Override
    public void finishComment(byte[] t) throws IOException {
        this.print(new TokenBuilder(DataText.COMM_O).add(Token.norm(t)).add(DataText.COMM_C).finish(), "3366FF");
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        this.print(new TokenBuilder(DataText.PI_O).add(n).add(Token.SPACE).add(v).add(DataText.PI_C).finish(), "3399FF");
    }

    @Override
    public void atomic(Item it) throws IOException {
        try {
            this.print(Token.norm(it.string(null)), "3366CC");
        }
        catch (QueryException ex) {
            throw new SerializerException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.indent();
        this.print("}");
    }

    private void print(byte[] t, String col) throws IOException {
        String txt = Token.string(Token.chop(t, 60)).replaceAll("\"|\\r|\\n", "'");
        if (this.compact) {
            txt = txt.replaceAll("\\\\n\\w+:", "\\\\n");
        }
        this.indent();
        this.print(Util.info("node% [label=\"%\" color=\"#%\"];", this.count, txt, col));
        this.nodes.set(this.level, this.count);
        if (this.level > 0) {
            this.child(this.level - 1).add(this.count);
        }
        ++this.count;
    }

    private IntList child(int i) {
        while (i >= this.children.size()) {
            this.children.add(new IntList());
        }
        return this.children.get(i);
    }
}

