/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.DataText;
import org.basex.io.serial.OutputSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.util.Err;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class HTMLSerializer
extends OutputSerializer {
    static final TokenList EMPTIES = new TokenList();
    static final TokenSet URIS = new TokenSet();
    private static final TokenList SCRIPTS = new TokenList();
    private static final TokenSet BOOLEAN = new TokenSet();

    HTMLSerializer(OutputStream os, SerializerProp p) throws IOException {
        super(os, p, "4.0", "4.01");
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        byte[] tagatt = Token.concat(Token.lc(this.elem), Token.COLON, Token.lc(n));
        if (BOOLEAN.contains(tagatt) && Token.eq(n, v)) {
            return;
        }
        byte[] val = this.escape && URIS.contains(tagatt) ? Token.escape(v) : v;
        this.print(32);
        this.print(n);
        this.print(DataText.ATT1);
        for (int k = 0; k < val.length; k += Token.cl(val, k)) {
            int ch = Token.cp(val, k);
            if (ch == 60 || ch == 38 && val[Math.min(k + 1, val.length - 1)] == 123) {
                this.print(ch);
                continue;
            }
            if (ch == 34) {
                this.print(DataText.E_QU);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.hex(ch);
                continue;
            }
            this.code(ch);
        }
        this.print(DataText.ATT2);
    }

    @Override
    public void finishComment(byte[] n) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.sep) {
            this.indent();
        }
        if (Token.contains(v, 62)) {
            Err.SERPI.thrwSerial(new Object[0]);
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void code(int ch) throws IOException {
        if (this.script) {
            this.printChar(ch);
        } else if (ch > 127 && ch < 160) {
            Err.SERILL.thrwSerial(Integer.toHexString(ch));
        } else if (ch == 160) {
            this.print(DataText.E_NBSP);
        } else {
            super.code(ch);
        }
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(null);
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.sep = this.indent;
        this.script = SCRIPTS.contains(Token.lc(t));
        if (this.content && Token.eq(Token.lc(this.elem), DataText.HEAD)) {
            ++this.ct;
        }
    }

    @Override
    protected void finishOpen() throws IOException {
        super.finishOpen();
        this.ct(false, true);
    }

    @Override
    protected void finishEmpty() throws IOException {
        if (this.ct(true, true)) {
            return;
        }
        this.print(DataText.ELEM_C);
        if (EMPTIES.contains(Token.lc(this.elem))) {
            return;
        }
        this.sep = false;
        this.finishClose();
    }

    @Override
    protected void finishClose() throws IOException {
        super.finishClose();
        this.script = this.script && !SCRIPTS.contains(Token.lc(this.elem));
    }

    static {
        SCRIPTS.add(Token.token("script"));
        SCRIPTS.add(Token.token("style"));
        BOOLEAN.add(Token.token("area:nohref"));
        BOOLEAN.add(Token.token("button:disabled"));
        BOOLEAN.add(Token.token("dir:compact"));
        BOOLEAN.add(Token.token("dl:compact"));
        BOOLEAN.add(Token.token("frame:noresize"));
        BOOLEAN.add(Token.token("hr:noshade"));
        BOOLEAN.add(Token.token("img:ismap"));
        BOOLEAN.add(Token.token("input:checked"));
        BOOLEAN.add(Token.token("input:disabled"));
        BOOLEAN.add(Token.token("input:readonly"));
        BOOLEAN.add(Token.token("menu:compact"));
        BOOLEAN.add(Token.token("object:declare"));
        BOOLEAN.add(Token.token("ol:compact"));
        BOOLEAN.add(Token.token("optgroup:disabled"));
        BOOLEAN.add(Token.token("option:selected"));
        BOOLEAN.add(Token.token("option:disabled"));
        BOOLEAN.add(Token.token("script:defer"));
        BOOLEAN.add(Token.token("select:multiple"));
        BOOLEAN.add(Token.token("select:disabled"));
        BOOLEAN.add(Token.token("td:nowrap"));
        BOOLEAN.add(Token.token("textarea:disabled"));
        BOOLEAN.add(Token.token("textarea:readonly"));
        BOOLEAN.add(Token.token("th:nowrap"));
        BOOLEAN.add(Token.token("ul:compact"));
        EMPTIES.add(Token.token("area"));
        EMPTIES.add(Token.token("base"));
        EMPTIES.add(Token.token("br"));
        EMPTIES.add(Token.token("col"));
        EMPTIES.add(Token.token("hr"));
        EMPTIES.add(Token.token("img"));
        EMPTIES.add(Token.token("input"));
        EMPTIES.add(Token.token("link"));
        EMPTIES.add(Token.token("meta"));
        EMPTIES.add(Token.token("basefont"));
        EMPTIES.add(Token.token("frame"));
        EMPTIES.add(Token.token("isindex"));
        EMPTIES.add(Token.token("param"));
        URIS.add(Token.token("a:href"));
        URIS.add(Token.token("a:name"));
        URIS.add(Token.token("applet:codebase"));
        URIS.add(Token.token("area:href"));
        URIS.add(Token.token("base:href"));
        URIS.add(Token.token("blockquote:cite"));
        URIS.add(Token.token("body:background"));
        URIS.add(Token.token("button:datasrc"));
        URIS.add(Token.token("del:cite"));
        URIS.add(Token.token("div:datasrc"));
        URIS.add(Token.token("form:action"));
        URIS.add(Token.token("frame:longdesc"));
        URIS.add(Token.token("frame:src"));
        URIS.add(Token.token("head:profile"));
        URIS.add(Token.token("iframe:longdesc"));
        URIS.add(Token.token("iframe:src"));
        URIS.add(Token.token("img:longdesc"));
        URIS.add(Token.token("img:src"));
        URIS.add(Token.token("img:usemap"));
        URIS.add(Token.token("input:datasrc"));
        URIS.add(Token.token("input:src"));
        URIS.add(Token.token("input:usemap"));
        URIS.add(Token.token("ins:cite"));
        URIS.add(Token.token("link:href"));
        URIS.add(Token.token("object:archive"));
        URIS.add(Token.token("object:classid"));
        URIS.add(Token.token("object:codebase"));
        URIS.add(Token.token("object:data"));
        URIS.add(Token.token("object:datasrc"));
        URIS.add(Token.token("object:usemap"));
        URIS.add(Token.token("q:cite"));
        URIS.add(Token.token("script:for"));
        URIS.add(Token.token("script:src"));
        URIS.add(Token.token("select:datasrc"));
        URIS.add(Token.token("span:datasrc"));
        URIS.add(Token.token("table:datasrc"));
        URIS.add(Token.token("textarea:datasrc"));
    }
}

