/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.io.in.TextInput;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.StrStream;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTSpan;
import org.basex.util.hash.TokenSet;

public abstract class OutputSerializer
extends Serializer {
    private String docsys;
    private String docpub;
    int ct;
    boolean sep;
    private boolean item;
    boolean script;
    final boolean escape;
    private final TokenSet cdata = new TokenSet();
    private final TokenSet suppress = new TokenSet();
    final boolean indent;
    final boolean content;
    private final String media;
    private final Charset encoding;
    private final byte[] separator;
    final byte[] nl;
    final PrintOutput out;
    private final boolean utf8;
    final int indents;
    final char tab;
    private final boolean format;
    private final byte[] wPre;
    private final boolean wrap;

    OutputSerializer(OutputStream os, SerializerProp props, String ... versions) throws IOException {
        String supp;
        SerializerProp p;
        SerializerProp serializerProp = p = props == null ? PROPS : props;
        String ver = versions.length == 0 ? "" : (p.get(SerializerProp.S_VERSION).isEmpty() ? versions[0] : p.check(SerializerProp.S_VERSION, versions));
        boolean decl = !p.yes(SerializerProp.S_OMIT_XML_DECLARATION);
        boolean bom = p.yes(SerializerProp.S_BYTE_ORDER_MARK);
        String sa = p.check(SerializerProp.S_STANDALONE, "yes", "no", "omit");
        p.check(SerializerProp.S_NORMALIZATION_FORM, "NFC", "none");
        String maps = p.get(SerializerProp.S_USE_CHARACTER_MAPS);
        String enc = Token.normEncoding(p.get(SerializerProp.S_ENCODING));
        try {
            this.encoding = Charset.forName(enc);
        }
        catch (Exception ex) {
            throw Err.SERENCODING.thrwSerial(enc);
        }
        this.utf8 = enc == "UTF-8";
        this.indents = Math.max(0, Token.toInt(p.get(SerializerProp.S_INDENTS)));
        this.format = p.yes(SerializerProp.S_FORMAT);
        this.tab = (char)(p.yes(SerializerProp.S_TABULATOR) ? 9 : 32);
        this.wPre = Token.token(p.get(SerializerProp.S_WRAP_PREFIX));
        this.wrap = this.wPre.length != 0;
        String eol = p.check(SerializerProp.S_NEWLINE, "\\n", "\\r", "\\r\\n");
        this.nl = Token.utf8(Token.token(eol.equals("\\n") ? "\n" : (eol.equals("\\r") ? "\r" : "\r\n")), enc);
        String s = p.get(SerializerProp.S_SEPARATOR);
        this.separator = Token.token(s.indexOf(92) != -1 ? s.replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t") : s);
        this.docsys = p.get(SerializerProp.S_DOCTYPE_SYSTEM);
        this.docpub = p.get(SerializerProp.S_DOCTYPE_PUBLIC);
        this.media = p.get(SerializerProp.S_MEDIA_TYPE);
        this.escape = p.yes(SerializerProp.S_ESCAPE_URI_ATTRIBUTES);
        this.content = p.yes(SerializerProp.S_INCLUDE_CONTENT_TYPE);
        this.undecl = p.yes(SerializerProp.S_UNDECLARE_PREFIXES);
        boolean bl = this.indent = p.yes(SerializerProp.S_INDENT) && this.format;
        if (!maps.isEmpty()) {
            Err.SERMAP.thrwSerial(maps);
        }
        if (this.docsys.isEmpty()) {
            this.docsys = null;
            this.docpub = null;
        } else if (this.docpub.isEmpty()) {
            this.docpub = null;
        }
        this.out = PrintOutput.get(os);
        if (bom) {
            if (enc == "UTF-8") {
                this.out.write(239);
                this.out.write(187);
                this.out.write(191);
            } else if (enc == "UTF-16LE") {
                this.out.write(255);
                this.out.write(254);
            } else if (enc == "UTF-16BE") {
                this.out.write(254);
                this.out.write(255);
            }
        }
        if (!(supp = p.get(SerializerProp.S_SUPPRESS_INDENTATION)).isEmpty()) {
            for (String c : supp.split("\\s+")) {
                if (c.isEmpty()) continue;
                this.suppress.add(Token.token(c));
            }
        }
        if (this instanceof XMLSerializer || this instanceof XHTMLSerializer) {
            String cdse = p.get(SerializerProp.S_CDATA_SECTION_ELEMENTS);
            if (!cdse.isEmpty()) {
                for (String c : cdse.split("\\s+")) {
                    if (c.isEmpty()) continue;
                    this.cdata.add(Token.token(c));
                }
            }
            if (this.undecl && ver.equals("1.0")) {
                Err.SERUNDECL.thrwSerial(new Object[0]);
            }
            if (decl) {
                this.print(DataText.PI_O);
                this.print("xml version=\"");
                this.print(ver);
                this.print("\" encoding=\"");
                this.print(p.get(SerializerProp.S_ENCODING));
                if (!sa.equals("omit")) {
                    this.print("\" standalone=\"");
                    this.print(sa);
                }
                this.print(DataText.ATT2);
                this.print(DataText.PI_C);
                this.sep = true;
            } else if (!sa.equals("omit") || !ver.equals("1.0") && this.docsys != null) {
                Err.SERSTAND.thrwSerial(new Object[0]);
            }
        }
        if (this.wrap) {
            this.startElement(Token.concat(this.wPre, Token.COLON, DataText.T_RESULTS), new byte[0][]);
            this.namespace(this.wPre, Token.token(p.get(SerializerProp.S_WRAP_URI)));
        }
    }

    @Override
    public final void reset() {
        this.sep = false;
        this.item = false;
    }

    @Override
    public void close() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
        this.out.flush();
    }

    @Override
    public void openResult() throws IOException {
        if (this.wrap) {
            this.startElement(this.wPre.length != 0 ? Token.concat(this.wPre, Token.COLON, DataText.T_RESULT) : DataText.T_RESULT, new byte[0][]);
        }
    }

    @Override
    public void closeResult() throws IOException {
        if (this.wrap) {
            this.closeElement();
        }
    }

    @Override
    public void attribute(byte[] n, byte[] v) throws IOException {
        this.print(32);
        this.print(n);
        this.print(DataText.ATT1);
        for (int k = 0; k < v.length; k += Token.cl(v, k)) {
            int ch = Token.cp(v, k);
            if (!this.format) {
                this.printChar(ch);
                continue;
            }
            if (ch == 34) {
                this.print(DataText.E_QU);
                continue;
            }
            if (ch == 9 || ch == 10) {
                this.hex(ch);
                continue;
            }
            this.code(ch);
        }
        this.print(DataText.ATT2);
    }

    @Override
    public void finishText(byte[] b) throws IOException {
        if (this.cdata.isEmpty() || this.tags.isEmpty() || !this.cdata.contains(this.tags.peek())) {
            for (int k = 0; k < b.length; k += Token.cl(b, k)) {
                this.code(Token.cp(b, k));
            }
        } else {
            this.print(DataText.CDATA_O);
            int c = 0;
            for (int k = 0; k < b.length; k += Token.cl(b, k)) {
                int ch = Token.cp(b, k);
                if (ch == 93) {
                    ++c;
                } else {
                    if (c > 1 && ch == 62) {
                        this.print(DataText.CDATA_C);
                        this.print(DataText.CDATA_O);
                    }
                    c = 0;
                }
                this.printChar(ch);
            }
            this.print(DataText.CDATA_C);
        }
        this.sep = false;
    }

    @Override
    public void finishText(byte[] b, FTPos ftp) throws IOException {
        FTLexer lex = new FTLexer().sc().init(b);
        while (lex.hasNext()) {
            FTSpan span = lex.next();
            if (!span.special && ftp.contains(span.pos)) {
                this.print(4);
            }
            byte[] t = span.text;
            for (int k = 0; k < t.length; k += Token.cl(t, k)) {
                this.code(Token.cp(t, k));
            }
        }
        this.sep = false;
    }

    @Override
    public void finishComment(byte[] n) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.COMM_O);
        this.print(n);
        this.print(DataText.COMM_C);
        this.sep = true;
    }

    @Override
    public void finishPi(byte[] n, byte[] v) throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.PI_O);
        this.print(n);
        this.print(32);
        this.print(v);
        this.print(DataText.PI_C);
        this.sep = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atomic(Item it) throws IOException {
        block12: {
            if (this.sep && this.item) {
                byte[] sp = this.separator;
                int sl = sp.length;
                if (sl == 1) {
                    this.printChar(sp[0]);
                } else {
                    for (int s = 0; s < sl; s += Token.cl(sp, s)) {
                        this.printChar(Token.cp(sp, s));
                    }
                }
            }
            try {
                if (it instanceof StrStream) {
                    TextInput ni = ((StrStream)it).input(null);
                    try {
                        int i;
                        while ((i = ((InputStream)ni).read()) != -1) {
                            this.code(i);
                        }
                        break block12;
                    }
                    finally {
                        ((InputStream)ni).close();
                    }
                }
                byte[] atom = it.string(null);
                for (int a = 0; a < atom.length; a += Token.cl(atom, a)) {
                    this.code(Token.cp(atom, a));
                }
            }
            catch (QueryException ex) {
                throw new SerializerException(ex);
            }
        }
        this.sep = true;
        this.item = true;
    }

    @Override
    public void openDoc(byte[] n) throws IOException {
        this.sep = false;
    }

    @Override
    public final boolean finished() {
        return this.out.finished();
    }

    @Override
    protected void startOpen(byte[] t) throws IOException {
        this.doctype(t);
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_O);
        this.print(t);
        this.sep = true;
    }

    @Override
    protected void finishOpen() throws IOException {
        this.print(DataText.ELEM_C);
    }

    @Override
    protected void finishEmpty() throws IOException {
        this.print(DataText.ELEM_SC);
    }

    @Override
    protected void finishClose() throws IOException {
        if (this.sep) {
            this.indent();
        }
        this.print(DataText.ELEM_OS);
        this.print(this.elem);
        this.print(DataText.ELEM_C);
        this.sep = true;
    }

    protected void code(int ch) throws IOException {
        if (!this.format) {
            this.printChar(ch);
        } else if (ch < 32 && ch != 10 && ch != 9 || ch > 127 && ch < 160) {
            this.hex(ch);
        } else if (ch == 38) {
            this.print(DataText.E_AMP);
        } else if (ch == 62) {
            this.print(DataText.E_GT);
        } else if (ch == 60) {
            this.print(DataText.E_LT);
        } else {
            this.printChar(ch);
        }
    }

    protected void doctype(byte[] dt) throws IOException {
        if (this.level != 0 || this.docsys == null) {
            return;
        }
        if (this.sep) {
            this.indent();
        }
        this.print("<!DOCTYPE ");
        if (dt == null) {
            this.print("html");
        } else {
            this.print(dt);
        }
        if (this.docpub != null) {
            this.print(" PUBLIC \"" + this.docpub + '\"');
        } else {
            this.print(" SYSTEM");
        }
        this.print(" \"" + this.docsys + '\"');
        this.print(DataText.ELEM_C);
        this.docsys = null;
        this.sep = true;
    }

    protected final void indent() throws IOException {
        if (this.item) {
            this.item = false;
        } else if (this.indent) {
            if (!this.suppress.isEmpty() && !this.tags.isEmpty()) {
                for (byte[] t : this.tags) {
                    if (!this.suppress.contains(t)) continue;
                    return;
                }
            }
            this.print(this.nl);
            int ls = this.level * this.indents;
            for (int l = 0; l < ls; ++l) {
                this.print(this.tab);
            }
        }
    }

    protected final void hex(int ch) throws IOException {
        this.print("&#x");
        this.print(Token.HEX[ch >> 4]);
        this.print(Token.HEX[ch & 0xF]);
        this.print(59);
    }

    protected final void printChar(int ch) throws IOException {
        if (ch == 10) {
            this.out.write(this.nl);
        } else {
            this.print(ch);
        }
    }

    protected void print(int ch) throws IOException {
        if (this.utf8) {
            this.out.utf8(ch);
        } else {
            this.out.write(new TokenBuilder(4).add(ch).toString().getBytes(this.encoding));
        }
    }

    protected final void print(byte[] token) throws IOException {
        if (this.utf8) {
            for (byte b : token) {
                this.out.write(b);
            }
        } else {
            this.out.write(Token.string(token).getBytes(this.encoding));
        }
    }

    protected final void print(String s) throws IOException {
        if (this.utf8) {
            for (byte b : Token.token(s)) {
                this.out.write(b);
            }
        } else {
            this.out.write(s.getBytes(this.encoding));
        }
    }

    protected boolean ct(boolean empty, boolean html) throws IOException {
        if (this.ct != 1) {
            return false;
        }
        ++this.ct;
        if (empty) {
            this.finishOpen();
        }
        ++this.level;
        this.startOpen(DataText.META);
        this.attribute(DataText.HTTPEQUIV, Token.token("Content-Type"));
        this.attribute(DataText.CONTENT, new TokenBuilder(this.media.isEmpty() ? "text/html" : this.media).add(DataText.CHARSET).addExt(this.encoding, new Object[0]).finish());
        if (html) {
            this.print(DataText.ELEM_C);
        } else {
            this.print(32);
            this.print(DataText.ELEM_SC);
        }
        --this.level;
        if (empty) {
            this.finishClose();
        }
        return true;
    }
}

