/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.serial;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.data.FTPos;
import org.basex.data.FTPosData;
import org.basex.io.serial.HTML5Serializer;
import org.basex.io.serial.HTMLSerializer;
import org.basex.io.serial.JSONSerializer;
import org.basex.io.serial.JsonMLSerializer;
import org.basex.io.serial.RawSerializer;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.TextSerializer;
import org.basex.io.serial.XHTMLSerializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryText;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FTPosNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public abstract class Serializer {
    public static final SerializerProp PROPS = new SerializerProp();
    protected final TokenList tags = new TokenList();
    protected int level;
    protected byte[] elem;
    protected boolean undecl;
    private final Atts ns = new Atts(Token.XML, QueryText.XMLURI).add(Token.EMPTY, Token.EMPTY);
    private final IntList nsl = new IntList();
    private boolean opening;

    public static XMLSerializer get(OutputStream os) throws IOException {
        return new XMLSerializer(os, PROPS);
    }

    public static Serializer get(OutputStream os, SerializerProp props) throws IOException {
        if (props == null) {
            return Serializer.get(os);
        }
        String m = props.check(SerializerProp.S_METHOD, DataText.METHODS);
        if ("xhtml".equals(m)) {
            return new XHTMLSerializer(os, props);
        }
        if ("html5".equals(m)) {
            return new HTML5Serializer(os, props);
        }
        if ("html".equals(m)) {
            return new HTMLSerializer(os, props);
        }
        if ("text".equals(m)) {
            return new TextSerializer(os, props);
        }
        if ("json".equals(m)) {
            return new JSONSerializer(os, props);
        }
        if ("jsonml".equals(m)) {
            return new JsonMLSerializer(os, props);
        }
        if ("raw".equals(m)) {
            return new RawSerializer(os, props);
        }
        return new XMLSerializer(os, props);
    }

    public final void serialize(Item item) throws IOException {
        this.openResult();
        if (item.type.isNode()) {
            this.serialize((ANode)item);
        } else {
            this.finishElement();
            this.atomic(item);
        }
        this.closeResult();
    }

    public void serialize(ANode node) throws IOException {
        if (node instanceof DBNode) {
            this.node((DBNode)node);
        } else if (node.type == NodeType.COM) {
            this.comment(node.string());
        } else if (node.type == NodeType.ATT) {
            this.attribute(node.name(), node.string());
        } else if (node.type == NodeType.TXT) {
            this.text(node.string());
        } else if (node.type == NodeType.PI) {
            this.pi(node.name(), node.string());
        } else if (node.type == NodeType.NSP) {
            this.namespace(node.name(), node.string());
        } else if (node.type == NodeType.DOC) {
            this.openDoc(node.baseURI());
            for (ANode n : node.children()) {
                this.serialize(n);
            }
            this.closeDoc();
        } else {
            ANode n;
            this.startElement(node.name(), new byte[0][]);
            Atts nsp = node.namespaces();
            for (int p = nsp.size() - 1; p >= 0; --p) {
                this.namespace(nsp.name(p), nsp.string(p));
            }
            AxisMoreIter ai = node.attributes();
            while ((n = ai.next()) != null) {
                this.attribute(n.name(), n.string());
            }
            ai = node.children();
            while ((n = ai.next()) != null) {
                this.serialize(n);
            }
            this.closeElement();
        }
    }

    public void close() throws IOException {
    }

    public boolean finished() {
        return false;
    }

    public void reset() {
    }

    protected final void startElement(byte[] name, byte[] ... atts) throws IOException {
        this.finishElement();
        this.nsl.push(this.ns.size());
        this.opening = true;
        this.elem = name;
        this.startOpen(name);
        for (int i = 0; i < atts.length; i += 2) {
            this.attribute(atts[i], atts[i + 1]);
        }
    }

    protected final void closeElement() throws IOException {
        this.ns.size(this.nsl.pop());
        if (this.opening) {
            this.finishEmpty();
            this.opening = false;
        } else {
            this.elem = this.tags.pop();
            --this.level;
            this.finishClose();
        }
    }

    protected void finishText(byte[] v, FTPos ftp) throws IOException {
        this.text(v);
    }

    protected void namespace(byte[] pref, byte[] uri) throws IOException {
        if (!this.undecl && pref.length != 0 && uri.length == 0) {
            return;
        }
        byte[] u = this.ns(pref);
        if (u == null || !Token.eq(u, uri)) {
            this.attribute(pref.length == 0 ? Token.XMLNS : Token.concat(Token.XMLNSC, pref), uri);
            this.ns.add(pref, uri);
        }
    }

    protected void openResult() throws IOException {
    }

    protected void closeResult() throws IOException {
    }

    protected void openDoc(byte[] n) throws IOException {
    }

    protected void closeDoc() throws IOException {
    }

    protected abstract void attribute(byte[] var1, byte[] var2) throws IOException;

    protected abstract void startOpen(byte[] var1) throws IOException;

    protected abstract void finishOpen() throws IOException;

    protected abstract void finishEmpty() throws IOException;

    protected abstract void finishClose() throws IOException;

    protected abstract void finishText(byte[] var1) throws IOException;

    protected abstract void finishComment(byte[] var1) throws IOException;

    protected abstract void finishPi(byte[] var1, byte[] var2) throws IOException;

    protected abstract void atomic(Item var1) throws IOException;

    private void node(DBNode node) throws IOException {
        FTPosData ft = node instanceof FTPosNode ? ((FTPosNode)node).ft : null;
        Data data = node.data;
        boolean doc = false;
        TokenList nsp = data.nspaces.size() != 0 ? new TokenList() : null;
        IntList pars = new IntList();
        int l = 0;
        int p = node.pre;
        int s = p + data.size(p, data.kind(p));
        while (p < s && !this.finished()) {
            int k = data.kind(p);
            int r = data.parent(p, k);
            while (l > 0 && pars.get(l - 1) >= r) {
                this.closeElement();
                --l;
            }
            if (k == 0) {
                if (doc) {
                    this.closeDoc();
                }
                this.openDoc(data.text(p++, true));
                doc = true;
                continue;
            }
            if (k == 2) {
                FTPos ftd;
                FTPos fTPos = ftd = ft != null ? ft.get(data, p) : null;
                if (ftd != null) {
                    this.text(data.text(p++, true), ftd);
                    continue;
                }
                this.text(data.text(p++, true));
                continue;
            }
            if (k == 4) {
                this.comment(data.text(p++, true));
                continue;
            }
            if (k == 3) {
                this.attribute(data.name(p, k), data.text(p++, false));
                continue;
            }
            if (k == 5) {
                this.pi(data.name(p, k), data.atom(p++));
                continue;
            }
            byte[] name = data.name(p, k);
            this.startElement(name, new byte[0][]);
            if (nsp != null) {
                byte[] old;
                nsp.reset();
                int pp = p;
                byte[] key = Token.prefix(name);
                byte[] val = data.nspaces.uri(data.uri(p, k));
                if (val == null) {
                    val = Token.EMPTY;
                }
                if ((old = this.ns(key)) == null || !Token.eq(old, val)) {
                    this.namespace(key, val);
                }
                do {
                    Atts atn = data.ns(pp);
                    for (int n = 0; n < atn.size(); ++n) {
                        key = atn.name(n);
                        val = atn.string(n);
                        if (nsp.contains(key)) continue;
                        nsp.add(key);
                        this.namespace(key, val);
                    }
                } while (this.level == 0 && l == 0 && (pp = data.parent(pp, data.kind(pp))) >= 0 && data.kind(pp) == 1);
            }
            int as = p + data.attSize(p, k);
            while (++p != as) {
                this.attribute(data.name(p, 3), data.text(p, false));
            }
            pars.set(l++, r);
        }
        while (--l >= 0) {
            this.closeElement();
        }
        if (doc) {
            this.closeDoc();
        }
    }

    private byte[] ns(byte[] pref) {
        for (int i = this.ns.size() - 1; i >= 0; --i) {
            if (!Token.eq(this.ns.name(i), pref)) continue;
            return this.ns.string(i);
        }
        return null;
    }

    private void text(byte[] v, FTPos ftp) throws IOException {
        this.finishElement();
        this.finishText(v, ftp);
    }

    private void comment(byte[] value) throws IOException {
        this.finishElement();
        this.finishComment(value);
    }

    private void text(byte[] value) throws IOException {
        this.finishElement();
        this.finishText(value);
    }

    private void pi(byte[] name, byte[] value) throws IOException {
        this.finishElement();
        this.finishPi(name, value);
    }

    private void finishElement() throws IOException {
        if (!this.opening) {
            return;
        }
        this.opening = false;
        this.finishOpen();
        this.tags.push(this.elem);
        ++this.level;
    }
}

