/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.Context;
import org.basex.core.Progress;
import org.basex.core.Text;
import org.basex.data.Nodes;
import org.basex.data.Result;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.node.FDoc;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class QueryProcessor
extends Progress {
    public final QueryContext ctx;
    private final String query;
    private boolean parsed;
    private boolean compiled;

    public QueryProcessor(String qu, Context cx) {
        this.query = qu;
        this.ctx = new QueryContext(cx);
        this.progress(this.ctx);
    }

    public void parse() throws QueryException {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        this.ctx.parse(this.query);
        this.updating = this.ctx.updating;
    }

    public void compile() throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.parse();
        this.ctx.compile();
    }

    public Iter iter() throws QueryException {
        this.compile();
        return this.ctx.iter();
    }

    public Value value() throws QueryException {
        this.compile();
        return this.ctx.value();
    }

    public Result execute() throws QueryException {
        this.compile();
        return this.ctx.execute();
    }

    public QueryProcessor bind(String name, Object value, String type) throws QueryException {
        this.ctx.bind(name, value, type);
        return this;
    }

    public QueryProcessor bind(String name, Object value) throws QueryException {
        return this.bind(name, value, null);
    }

    public QueryProcessor context(Object value) throws QueryException {
        return this.context(value, null);
    }

    public QueryProcessor context(Object value, String type) throws QueryException {
        this.ctx.context(value, type);
        return this;
    }

    public QueryProcessor context(Nodes nodes) {
        this.ctx.nodes = nodes;
        return this;
    }

    public QueryProcessor namespace(String prefix, String uri) throws QueryException {
        this.ctx.sc.namespace(prefix, uri);
        return this;
    }

    public Serializer getSerializer(OutputStream os) throws IOException, QueryException {
        this.compile();
        try {
            return Serializer.get(os, this.ctx.serParams(true));
        }
        catch (SerializerException ex) {
            throw ex.getCause();
        }
    }

    public Nodes queryNodes() throws QueryException {
        Result res = this.execute();
        if (!(res instanceof Nodes)) {
            if (res.size() == 0L) {
                return new Nodes(this.ctx.nodes.data);
            }
            Err.BXDB_DBRETURN.thrw(null, new Object[0]);
        }
        return (Nodes)res;
    }

    public void module(String uri, String file) {
        this.ctx.modDeclared.add(Token.token(uri), Token.token(file));
    }

    public String query() {
        return this.query;
    }

    public void close() {
        this.ctx.close();
    }

    @Override
    public boolean databases(StringList db) {
        return this.ctx.root != null && this.ctx.root.databases(db);
    }

    public int updates() {
        return this.updating ? this.ctx.updates.size() : 0;
    }

    public String info() {
        return this.ctx.info();
    }

    public static String removeComments(String qu, int max) {
        StringBuilder sb = new StringBuilder();
        int m = 0;
        boolean s = false;
        int cl = qu.length();
        for (int c = 0; c < cl && sb.length() < max; ++c) {
            char ch = qu.charAt(c);
            if (ch == '\r') continue;
            if (ch == '(' && c + 1 < cl && qu.charAt(c + 1) == ':') {
                if (m == 0 && !s) {
                    sb.append(' ');
                    s = true;
                }
                ++m;
                ++c;
                continue;
            }
            if (m != 0 && ch == ':' && c + 1 < cl && qu.charAt(c + 1) == ')') {
                --m;
                ++c;
                continue;
            }
            if (m != 0) continue;
            if (ch > ' ') {
                sb.append(ch);
            } else if (!s) {
                sb.append(' ');
            }
            s = ch <= ' ';
        }
        if (sb.length() >= max) {
            sb.append("...");
        }
        return sb.toString().trim();
    }

    public FDoc plan() {
        FDoc doc = new FDoc(Token.EMPTY);
        this.ctx.plan(doc);
        return doc;
    }

    @Override
    public String tit() {
        return Text.PLEASE_WAIT_D;
    }

    @Override
    public String det() {
        return Text.PLEASE_WAIT_D;
    }
}

