/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.basex.core.Perm;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.io.IO;
import org.basex.io.QueryInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class QueryResources {
    public HashMap<String, String> resources = new HashMap();
    private final QueryContext ctx;
    private Data[] data = new Data[1];
    private int datas;
    private Value[] coll = new Value[1];
    private String[] collName = new String[1];
    private int colls;

    QueryResources(QueryContext qc) {
        this.ctx = qc;
    }

    void compile(Nodes nodes) throws QueryException {
        Data d = nodes.data;
        if (!this.ctx.context.perm(Perm.READ, d.meta)) {
            Err.BASX_PERM.thrw(null, new Object[]{Perm.READ});
        }
        this.ctx.value = DBNodeSeq.get(new IntList(nodes.pres), d, nodes.root, nodes.root);
        this.addCollection(nodes.root ? this.ctx.value : DBNodeSeq.get(d.resources.docs(), d, true, true), d.meta.name);
        this.addData(d);
    }

    void close() {
        int d;
        int n = d = this.ctx.nodes != null ? 1 : 0;
        while (d < this.datas) {
            Close.close(this.data[d], this.ctx.context);
            ++d;
        }
        this.datas = 0;
    }

    public Data data(String name, InputInfo info) throws QueryException {
        for (int d = 0; d < this.datas; ++d) {
            if (!this.data[d].meta.name.equalsIgnoreCase(name)) continue;
            return this.data[d];
        }
        try {
            Data d = Open.open(name, this.ctx.context);
            this.addData(d);
            return d;
        }
        catch (IOException ex) {
            throw Err.BXDB_OPEN.thrw(info, ex);
        }
    }

    public DBNode doc(QueryInput qi, InputInfo info) throws QueryException {
        for (int d = 0; d < this.datas; ++d) {
            Data dt = this.data[d];
            if (dt.resources.docs().size() == 1 && IO.get(dt.meta.original).eq(qi.io)) {
                return new DBNode(dt, 0, 0);
            }
            if (!dt.meta.name.equalsIgnoreCase(qi.db)) continue;
            return this.doc(dt, qi, info);
        }
        Data dt = this.open(qi);
        if (dt == null) {
            dt = this.create(qi, true, info);
        }
        return this.doc(dt, qi, info);
    }

    public Value collection(InputInfo info) throws QueryException {
        if (this.colls == 0) {
            Err.NODEFCOLL.thrw(info, new Object[0]);
        }
        return this.coll[0];
    }

    public Value collection(String input, InputInfo info) throws QueryException {
        IO base = this.ctx.sc.baseIO();
        String in = base != null ? base.merge(input).path() : null;
        for (int c = 0; c < this.colls; ++c) {
            if ((in == null || !this.collName[c].equalsIgnoreCase(in)) && !this.collName[c].equalsIgnoreCase(input)) continue;
            return this.coll[c];
        }
        QueryInput qi = new QueryInput(input);
        Data dt = null;
        for (int d = 0; d < this.datas; ++d) {
            if ((qi.db == null || !this.data[d].meta.name.equalsIgnoreCase(qi.db)) && !IO.get(this.data[d].meta.original).eq(qi.io)) continue;
            dt = this.data[d];
            break;
        }
        if (dt == null) {
            dt = this.open(qi);
        }
        if (dt == null) {
            dt = this.create(qi, false, info);
        }
        return DBNodeSeq.get(dt.resources.docs(qi.path), dt, true, qi.path.isEmpty());
    }

    public void addDoc(String name, String path) throws QueryException {
        QueryInput qi = new QueryInput(path);
        Data d = this.create(qi, true, null);
        if (name != null) {
            d.meta.original = name;
        }
    }

    public void addResource(String uri, String path) {
        this.resources.put(uri, path);
    }

    public void addCollection(String name, String[] paths) throws QueryException {
        int ns = paths.length;
        Item[] nodes = new DBNode[ns];
        for (int n = 0; n < ns; ++n) {
            QueryInput qi = new QueryInput(paths[n]);
            nodes[n] = new DBNode(this.create(qi, true, null), 0, 0);
        }
        this.addCollection(Seq.get(nodes, ns, NodeType.DOC), name);
    }

    private Data open(QueryInput input) {
        if (input.db != null) {
            try {
                Data d = Open.open(input.db, this.ctx.context);
                this.addData(d);
                return d;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private Data create(QueryInput input, boolean single, InputInfo info) throws QueryException {
        Data d;
        block6: {
            d = null;
            try {
                d = CreateDB.create(input.io, single, this.ctx.context);
            }
            catch (IOException ex) {
                IO base = this.ctx.sc.baseIO();
                if (base != null) {
                    try {
                        String in = base.merge(input.original).path();
                        if (!in.equals(input.original)) {
                            d = CreateDB.create(IO.get(in), single, this.ctx.context);
                        }
                    }
                    catch (IOException exc) {
                        // empty catch block
                    }
                }
                if (d != null) break block6;
                Util.debug(ex);
                Err.IOERR.thrw(info, ex);
            }
        }
        input.path = "";
        this.addData(d);
        return d;
    }

    private DBNode doc(Data dt, QueryInput qi, InputInfo info) throws QueryException {
        IntList docs = dt.resources.docs(qi.path);
        if (docs.isEmpty()) {
            Err.WHICHRES.thrw(info, qi.original);
        }
        if (docs.size() != 1) {
            Err.BXDB_SINGLE.thrw(info, qi.original);
        }
        return new DBNode(dt, docs.get(0), 0);
    }

    private void addData(Data d) {
        if (this.datas == this.data.length) {
            Data[] tmp = new Data[Array.newSize(this.datas)];
            System.arraycopy(this.data, 0, tmp, 0, this.datas);
            this.data = tmp;
        }
        this.data[this.datas++] = d;
    }

    private void addCollection(Value nodes, String name) {
        if (this.colls == this.coll.length) {
            this.coll = Arrays.copyOf(this.coll, this.colls << 1);
            this.collName = Array.copyOf(this.collName, this.colls << 1);
        }
        this.coll[this.colls] = nodes;
        this.collName[this.colls++] = name;
    }
}

