/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CFrag;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.StringList;

public abstract class CName
extends CFrag {
    private final String desc;
    Expr name;

    CName(String d, InputInfo ii, Expr n, Expr ... v) {
        super(ii, v);
        this.name = n;
        this.desc = d;
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.name);
        super.checkUp();
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.name = this.name.compile(ctx);
        return super.compile(ctx);
    }

    final byte[] value(QueryContext ctx, InputInfo ii) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Expr e : this.expr) {
            Item it;
            Iter ir = ctx.iter(e);
            boolean m = false;
            while ((it = ir.next()) != null) {
                if (m) {
                    tb.add(32);
                }
                tb.add(it.string(ii));
                m = true;
            }
        }
        return tb.finish();
    }

    final QNm qname(QueryContext ctx, InputInfo ii) throws QueryException {
        QNm nm;
        Item it = this.checkItem(this.name, ctx);
        Type ip = it.type;
        if (ip == AtomType.QNM) {
            return (QNm)it;
        }
        byte[] str = it.string(ii);
        if (!XMLToken.isQName(str)) {
            (ip.isString() || ip.isUntyped() ? Err.INVNAME : Err.INVQNAME).thrw(this.info, new Object[]{str});
        }
        if (!(nm = new QNm(str, ctx)).hasURI() && nm.hasPrefix()) {
            Err.INVPREF.thrw(this.info, nm);
        }
        return nm;
    }

    @Override
    public boolean removable(Var v) {
        return this.name.removable(v) && super.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        this.name = this.name.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        return this.name.databases(db) && super.databases(db);
    }

    @Override
    public final boolean uses(Expr.Use u) {
        return this.name.uses(u) || super.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.name.count(v) + super.count(v);
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.name, this.expr});
    }

    @Override
    public final String description() {
        return CName.info(this.desc);
    }

    @Override
    public final String toString() {
        return this.toString(this.desc + " { " + this.name + " }");
    }
}

