/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Catch
extends Single {
    private static final QNm[] QNM = new QNm[]{Catch.create(QueryText.ECODE), Catch.create(QueryText.EDESC), Catch.create(QueryText.EVALUE), Catch.create(QueryText.EMODULE), Catch.create(QueryText.ELINENUM), Catch.create(QueryText.ECOLNUM), Catch.create(QueryText.EADD)};
    private static final SeqType[] TYPES = new SeqType[]{SeqType.QNM, SeqType.STR_ZO, SeqType.ITEM_ZM, SeqType.STR_ZO, SeqType.ITR_ZO, SeqType.ITR_ZO, SeqType.ITEM_ZM};
    private final Var[] vars = new Var[QNM.length];
    private final QNm[] codes;

    public Catch(InputInfo ii, QNm[] c, QueryContext ctx) {
        super(ii, null);
        this.codes = c;
        for (int i = 0; i < QNM.length; ++i) {
            this.vars[i] = Var.create(ctx, null, QNM[i], TYPES[i], null);
        }
    }

    @Override
    public Catch compile(QueryContext ctx) throws QueryException {
        int s = this.prepare(ctx);
        super.compile(ctx);
        ctx.vars.size(s);
        this.type = this.expr.type();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value value(QueryContext ctx, QueryException ex) throws QueryException {
        if (!this.find(ex.err(), ex.qname())) {
            return null;
        }
        int s = this.prepare(ctx);
        try {
            int i = 0;
            byte[] io = ex.file() == null ? Token.EMPTY : Token.token(ex.file());
            Value val = ex.value();
            for (Value v : new Value[]{ex.qname(), Str.get(ex.getLocalizedMessage()), val == null ? Empty.SEQ : val, Str.get(io), Int.get(ex.line()), Int.get(ex.col()), Empty.SEQ}) {
                this.vars[i++].bind(v, ctx);
            }
            Value value = ctx.value(this.expr);
            return value;
        }
        finally {
            ctx.vars.size(s);
        }
    }

    public int prepare(QueryContext ctx) {
        int s = ctx.vars.size();
        for (Var v : this.vars) {
            ctx.vars.add(v);
        }
        return s;
    }

    private boolean find(Err err, QNm code) {
        for (QNm c : this.codes) {
            if (c != null) {
                byte[] nm;
                byte[] eu;
                byte[] cu = c.uri();
                byte[] byArray = err != null ? err.qname().uri() : (eu = code.hasURI() ? code.uri() : Token.EMPTY);
                if (cu.length != 0 && !Token.eq(eu, cu) || (nm = c.local()).length != 0 && !Token.eq(code.local(), nm)) continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || super.uses(u);
    }

    @Override
    public String toString() {
        return "catch * { " + this.expr + " }";
    }

    private static QNm create(byte[] n) {
        return new QNm(Token.concat(QueryText.ERR, Token.COLON, n), QueryText.ERRORURI);
    }
}

