/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class CmpN
extends Cmp {
    private final OpN op;

    public CmpN(Expr e1, Expr e2, OpN o, InputInfo ii) {
        super(ii, e1, e2);
        this.op = o;
        this.type = SeqType.BLN_ZO;
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        return this.optPre(this.oneIsEmpty() ? null : (this.allAreValues() ? this.item(ctx, this.info) : this), ctx);
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        return Bln.get(this.op.eval(this.checkNode(a), this.checkNode(b)));
    }

    @Override
    public CmpN invert() {
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.OP, this.op.name), this.expr);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpN {
        EQ("is"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.is(b);
            }
        }
        ,
        ET("<<"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.diff(b) < 0;
            }
        }
        ,
        GT(">>"){

            @Override
            public boolean eval(ANode a, ANode b) {
                return a.diff(b) > 0;
            }
        };

        public final String name;

        private OpN(String n2) {
            this.name = n2;
        }

        public abstract boolean eval(ANode var1, ANode var2);

        public String toString() {
            return this.name;
        }
    }
}

