/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.query.NumericRange;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.RangeAccess;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.path.Axis;
import org.basex.query.path.AxisPath;
import org.basex.query.path.AxisStep;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class CmpR
extends Single {
    private final double min;
    private final boolean mni;
    private final double max;
    private final boolean mxi;
    private NumericRange rt;
    private final boolean atomic;

    private CmpR(Expr e, double mn, boolean in, double mx, boolean ix, InputInfo ii) {
        super(ii, e);
        this.min = mn;
        this.mni = in;
        this.max = mx;
        this.mxi = ix;
        this.type = SeqType.BLN;
        this.atomic = e.type().zeroOrOne();
    }

    static Expr get(CmpG ex) throws QueryException {
        if (!ex.expr[1].isItem()) {
            return ex;
        }
        Item it = (Item)ex.expr[1];
        if (!it.type.isNumber()) {
            return ex;
        }
        Expr e = ex.expr[0];
        double d = it.dbl(ex.info);
        switch (ex.op.op) {
            case GE: {
                return new CmpR(e, d, true, Double.POSITIVE_INFINITY, true, ex.info);
            }
            case GT: {
                return new CmpR(e, d, false, Double.POSITIVE_INFINITY, true, ex.info);
            }
            case LE: {
                return new CmpR(e, Double.NEGATIVE_INFINITY, true, d, true, ex.info);
            }
            case LT: {
                return new CmpR(e, Double.NEGATIVE_INFINITY, true, d, false, ex.info);
            }
        }
        return ex;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.atomic) {
            Item it2 = this.expr.item(ctx, this.info);
            if (it2 == null) {
                return Bln.FALSE;
            }
            double d = it2.dbl(this.info);
            return Bln.get((this.mni ? d >= this.min : d > this.min) && (this.mxi ? d <= this.max : d < this.max));
        }
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            double d = it.dbl(this.info);
            if (!(this.mni ? d >= this.min : d > this.min) || !(this.mxi ? d <= this.max : d < this.max)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    Expr intersect(CmpR c) {
        double mx;
        if (!c.expr.sameAs(this.expr)) {
            return null;
        }
        double mn = Math.max(this.min, c.min);
        if (mn > (mx = Math.min(this.max, c.max))) {
            return Bln.FALSE;
        }
        if (mn == mx) {
            return this.mni && this.mxi ? new CmpG(this.expr, (Expr)Dbl.get(mn), CmpG.OpG.EQ, this.info) : Bln.FALSE;
        }
        return new CmpR(c.expr, mn, this.mni && c.mni, mx, this.mxi && c.mxi, this.info);
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        boolean attr;
        AxisStep s = CmpG.indexStep(this.expr);
        if (s == null || ic.data.inMemory()) {
            return false;
        }
        boolean text = s.test.type == NodeType.TXT && ic.data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && ic.data.meta.attrindex;
        if (!text && !attr || !this.mni || !this.mxi) {
            return false;
        }
        Stats key = this.key(ic, text);
        if (key == null) {
            return false;
        }
        this.rt = new NumericRange(text ? IndexType.TEXT : IndexType.ATTRIBUTE, Math.max(this.min, key.min), Math.min(this.max, key.max));
        ic.costs(this.rt.min > this.rt.max || this.rt.max < key.min || this.rt.min > key.max ? 0 : Math.max(1, ic.data.meta.size / 5));
        return ic.costs() == 0 || this.min != Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) {
        boolean text = this.rt.type() == IndexType.TEXT;
        ic.ctx.compInfo("applying range index", new Object[0]);
        return ic.invert(this.expr, new RangeAccess(this.info, this.rt, ic), text);
    }

    private Stats key(IndexContext ic, boolean text) {
        AxisStep step;
        if (!ic.data.meta.uptodate || ic.data.nspaces.size() != 0) {
            return null;
        }
        AxisPath path = (AxisPath)this.expr;
        int st = path.steps.length;
        if (text) {
            AxisStep axisStep = step = st == 1 ? ic.step : path.step(st - 2);
            if (step.test.mode != Test.Mode.NAME) {
                return null;
            }
        } else {
            step = path.step(st - 1);
            if (!step.simple(Axis.ATTR, true)) {
                return null;
            }
        }
        Names names = text ? ic.data.tagindex : ic.data.atnindex;
        Stats key = names.stat(names.id(((NameTest)step.test).ln));
        return key == null || key.type == StatsType.INTEGER || key.type == StatsType.DOUBLE ? key : null;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.MIN, this.min, QueryText.MAX, this.max), this.expr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.min != Double.NEGATIVE_INFINITY) {
            sb.append(this.min).append(this.mni ? " <= " : " < ");
        }
        sb.append(this.expr);
        if (this.max != Double.POSITIVE_INFINITY) {
            sb.append(this.mxi ? " <= " : " < ").append(this.max);
        }
        return sb.toString();
    }
}

