/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.StringRangeAccess;
import org.basex.query.iter.Iter;
import org.basex.query.path.AxisStep;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class CmpSR
extends Single {
    private final byte[] min;
    private final boolean mni;
    private final byte[] max;
    private final boolean mxi;
    private StringRange rt;
    private final boolean atomic;

    private CmpSR(Expr e, byte[] mn, boolean in, byte[] mx, boolean ix, InputInfo ii) {
        super(ii, e);
        this.min = mn;
        this.mni = in;
        this.max = mx;
        this.mxi = ix;
        this.type = SeqType.BLN;
        this.atomic = e.type().zeroOrOne();
    }

    static Expr get(CmpG ex) throws QueryException {
        if (!ex.expr[1].isItem()) {
            return ex;
        }
        Item it = (Item)ex.expr[1];
        if (!it.type.isString()) {
            return ex;
        }
        Expr e = ex.expr[0];
        byte[] d = it.string(ex.info);
        switch (ex.op.op) {
            case GE: {
                return new CmpSR(e, d, true, null, true, ex.info);
            }
            case GT: {
                return new CmpSR(e, d, false, null, true, ex.info);
            }
            case LE: {
                return new CmpSR(e, null, true, d, true, ex.info);
            }
            case LT: {
                return new CmpSR(e, null, true, d, false, ex.info);
            }
        }
        return ex;
    }

    @Override
    public Bln item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.atomic) {
            int mx;
            Item it2 = this.expr.item(ctx, this.info);
            if (it2 == null) {
                return Bln.FALSE;
            }
            byte[] s = it2.string(this.info);
            int mn = this.min == null ? 1 : Token.diff(s, this.min);
            int n = mx = this.max == null ? -1 : Token.diff(s, this.max);
            return Bln.get((this.mni ? mn >= 0 : mn > 0) && (this.mxi ? mx <= 0 : mx < 0));
        }
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            int mx;
            byte[] s = it.string(this.info);
            int mn = this.min == null ? 1 : Token.diff(s, this.min);
            int n = mx = this.max == null ? -1 : Token.diff(s, this.max);
            if (!(this.mni ? mn >= 0 : mn > 0) || !(this.mxi ? mx <= 0 : mx < 0)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    Expr intersect(CmpSR c) {
        byte[] mx;
        byte[] mn;
        if (!c.expr.sameAs(this.expr)) {
            return null;
        }
        byte[] byArray = this.min == null ? c.min : (mn = c.min == null ? this.min : Token.max(this.min, c.min));
        byte[] byArray2 = this.max == null ? c.max : (mx = c.max == null ? this.max : Token.min(this.max, c.max));
        if (mn != null && mx != null) {
            int d = Token.diff(mn, mx);
            if (d > 0) {
                return Bln.FALSE;
            }
            if (d == 0) {
                return this.mni && this.mxi ? new CmpG(this.expr, (Expr)Str.get(mn), CmpG.OpG.EQ, this.info) : Bln.FALSE;
            }
        }
        return new CmpSR(c.expr, mn, this.mni && c.mni, mx, this.mxi && c.mxi, this.info);
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        boolean attr;
        AxisStep s = CmpG.indexStep(this.expr);
        if (s == null || ic.data.inMemory()) {
            return false;
        }
        boolean text = s.test.type == NodeType.TXT && ic.data.meta.textindex;
        boolean bl = attr = s.test.type == NodeType.ATT && ic.data.meta.attrindex;
        if (!text && !attr || this.min == null || this.max == null) {
            return false;
        }
        this.rt = new StringRange(text ? IndexType.TEXT : IndexType.ATTRIBUTE, this.min, this.mni, this.max, this.mxi);
        ic.costs(Math.max(1, ic.data.meta.size / 10));
        return true;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) {
        boolean text = this.rt.type() == IndexType.TEXT;
        ic.ctx.compInfo("applying string range index", new Object[0]);
        return ic.invert(this.expr, new StringRangeAccess(this.info, this.rt, ic), text);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.MIN, this.min != null ? (Object)this.min : "", QueryText.MAX, this.max != null ? (Object)this.max : ""), this.expr);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.min != null) {
            tb.add(34).add(this.min).add(34).add(this.mni ? " <= " : " < ");
        }
        tb.addExt(this.expr, new Object[0]);
        if (this.max != null) {
            tb.add(this.mxi ? " <= " : " < ").add(34).add(this.max).add(34);
        }
        return tb.toString();
    }
}

