/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Constr {
    public final ANodeList children = new ANodeList();
    public final ANodeList atts = new ANodeList();
    public final Atts nspaces = new Atts();
    public boolean errAtt;
    public boolean errNS;
    public byte[] duplAtt;
    public byte[] duplNS;
    private final QueryContext ctx;
    private final InputInfo info;
    private final TokenBuilder text = new TokenBuilder();
    private boolean more;

    public Constr(InputInfo ii, QueryContext qc) {
        this.info = ii;
        this.ctx = qc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constr add(Expr ... expr) throws QueryException {
        int s = this.ctx.sc.ns.size();
        try {
            for (Expr e : expr) {
                Item ch;
                this.more = false;
                Iter iter = this.ctx.iter(e);
                while ((ch = iter.next()) != null && this.add(ch)) {
                }
            }
            if (!this.text.isEmpty()) {
                this.children.add(new FTxt(this.text.finish()));
            }
            Constr constr = this;
            return constr;
        }
        finally {
            this.ctx.sc.ns.size(s);
        }
    }

    private boolean add(Item it) throws QueryException {
        Type ip = it.type;
        if (ip.isFunction()) {
            Err.CONSFUNC.thrw(this.info, it);
        }
        if (!ip.isNode()) {
            if (this.more) {
                this.text.add(32);
            }
            this.text.add(it.string(this.info));
            this.more = true;
        } else {
            ANode node = (ANode)it;
            if (ip == NodeType.TXT) {
                this.text.add(node.string());
            } else if (ip == NodeType.ATT) {
                if (!this.text.isEmpty() || this.children.size() != 0) {
                    this.errAtt = true;
                    return false;
                }
                QNm name = node.qname();
                for (int a = 0; a < this.atts.size(); ++a) {
                    if (!name.eq(this.atts.get(a).qname())) continue;
                    this.duplAtt = name.string();
                    return false;
                }
                this.atts.add(new FAttr(name, node.string()));
                if (name.hasURI()) {
                    this.ctx.sc.ns.add(name.prefix(), name.uri());
                }
            } else if (ip == NodeType.NSP) {
                if (!this.text.isEmpty() || this.children.size() != 0) {
                    this.errNS = true;
                    return false;
                }
                byte[] name = node.name();
                byte[] uri = node.string();
                byte[] u = this.nspaces.string(name);
                if (u == null) {
                    this.nspaces.add(name, uri);
                } else if (!Token.eq(uri, u)) {
                    this.duplNS = name;
                    return false;
                }
            } else if (ip == NodeType.DOC) {
                ANode ch;
                AxisMoreIter ai = node.children();
                while ((ch = ai.next()) != null && this.add(ch)) {
                }
            } else {
                if (!this.text.isEmpty()) {
                    this.children.add(new FTxt(this.text.finish()));
                    this.text.reset();
                }
                node = node.deepCopy();
                this.children.add(node);
            }
            this.more = false;
        }
        return true;
    }
}

