/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.IterPosFilter;
import org.basex.query.expr.Preds;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.AxisPath;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public class Filter
extends Preds {
    Expr root;

    public Filter(InputInfo ii, Expr r, Expr ... p) {
        super(ii, p);
        this.root = r;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        super.checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Expr compile(QueryContext ctx) throws QueryException {
        Value cv = ctx.value;
        try {
            this.root = this.root.compile(ctx);
            if (this.root.isEmpty()) {
                Expr expr = this.optPre(null, ctx);
                return expr;
            }
            if (this.root instanceof AxisPath && !super.uses(Expr.Use.POS)) {
                Expr expr = ((AxisPath)this.root).copy().addPreds(this.preds).compile(ctx);
                return expr;
            }
            ctx.value = null;
            Expr e = super.compile(ctx);
            if (e != this) {
                Expr expr = e;
                return expr;
            }
            Expr expr = this.preds.length == 0 ? this.root : this.comp2(ctx);
            return expr;
        }
        finally {
            ctx.value = cv;
        }
    }

    public final Expr comp2(QueryContext ctx) {
        SeqType t = this.root.type();
        long s = this.root.size();
        if (s != -1L) {
            if (this.pos != null) {
                this.size = Math.max(0L, s + 1L - this.pos.min) - Math.max(0L, s - this.pos.max);
            } else if (this.last) {
                long l = this.size = s > 0L ? 1L : 0L;
            }
            if (this.size == 0L) {
                return this.optPre(null, ctx);
            }
            this.type = SeqType.get(t.type, this.size);
        } else {
            this.type = SeqType.get(t.type, t.zeroOrOne() ? SeqType.Occ.ZERO_ONE : SeqType.Occ.ZERO_MORE);
        }
        if (!super.uses(Expr.Use.POS)) {
            return new IterFilter(this);
        }
        if (this.preds.length == 1 && (this.last || this.pos != null) && this.root.isValue() && t.one() && (this.last || this.pos.min == 1L && this.pos.max == 1L)) {
            return this.optPre(this.root, ctx);
        }
        boolean off = false;
        if (this.preds.length == 1) {
            Expr p = this.preds[0];
            SeqType st = p.type();
            boolean bl = off = st.type.isNumber() && st.zeroOrOne() && !p.uses(Expr.Use.CTX) && !p.uses(Expr.Use.NDT);
            if (off) {
                this.type = SeqType.get(this.type.type, SeqType.Occ.ZERO_ONE);
            }
        }
        return off || this.useIterator() ? new IterPosFilter(this, off) : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Iter iter = ctx.iter(this.root);
        Value cv = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        try {
            Item i;
            ValueBuilder vb = new ValueBuilder();
            while ((i = iter.next()) != null) {
                vb.add(i);
            }
            for (Expr p : this.preds) {
                long is;
                ctx.size = is = vb.size();
                ctx.pos = 1L;
                int c = 0;
                int s = 0;
                while ((long)s < is) {
                    ctx.value = vb.get(s);
                    if (p.test(ctx, this.info) != null) {
                        vb.set(vb.get(s), c++);
                    }
                    ++ctx.pos;
                    ++s;
                }
                vb.size(c);
            }
            ValueBuilder valueBuilder = vb;
            return valueBuilder;
        }
        finally {
            ctx.value = cv;
            ctx.size = cs;
            ctx.pos = cp;
        }
    }

    public final Filter addPred(Expr p) {
        this.preds = Array.add(this.preds, p);
        return this;
    }

    @Override
    public final boolean uses(Expr.Use u) {
        return this.root.uses(u) || u != Expr.Use.CTX && super.uses(u);
    }

    @Override
    public final int count(Var v) {
        return this.root.count(v) + super.count(v);
    }

    @Override
    public final boolean removable(Var v) {
        return this.root.removable(v) && super.removable(v);
    }

    @Override
    public final Expr remove(Var v) {
        this.root = this.root.remove(v);
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        return this.root.databases(db) && super.databases(db);
    }

    @Override
    public final void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        this.addPlan(plan, el, this.root);
        super.plan(el);
    }

    @Override
    public final String toString() {
        return "(" + this.root + ')' + super.toString();
    }
}

