/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Logical;
import org.basex.query.expr.Union;
import org.basex.query.util.IndexContext;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;

public final class Or
extends Logical {
    public Or(InputInfo ii, Expr ... e) {
        super(ii, e);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        Expr c = super.compile(ctx);
        if (c != this) {
            return c;
        }
        CmpG cmpg = null;
        Expr[] ex = new Expr[]{};
        for (Expr e : this.expr) {
            CmpG tmp = null;
            if (e instanceof CmpG) {
                CmpG g = (CmpG)e;
                if (cmpg == null) {
                    cmpg = g;
                } else if (cmpg.union(g, ctx)) {
                    tmp = g;
                }
            }
            if (tmp != null) continue;
            ex = Array.add(ex, e);
        }
        if (ex.length != this.expr.length) {
            ctx.compInfo("rewriting %", this);
        }
        this.expr = ex;
        this.compFlatten(ctx);
        return this.expr.length == 1 ? this.compBln(this.expr[0]) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        double d = 0.0;
        boolean f = false;
        for (Expr e : this.expr) {
            Item it = e.ebv(ctx, this.info);
            if (!it.bool(this.info)) continue;
            double s = it.score();
            if (s == 0.0) {
                return Bln.TRUE;
            }
            d = Scoring.or(d, s);
            f = true;
        }
        return d == 0.0 ? Bln.get(f) : Bln.get(d);
    }

    @Override
    public boolean indexAccessible(IndexContext ic) throws QueryException {
        int is = 0;
        Expr[] exprs = new Expr[]{};
        boolean ia = true;
        for (Expr e : this.expr) {
            if (e.indexAccessible(ic) && !ic.seq) {
                if (ic.costs() == 0) continue;
                is += ic.costs();
            } else {
                ia = false;
            }
            exprs = Array.add(exprs, e);
        }
        ic.costs(is);
        this.expr = exprs;
        return ia;
    }

    @Override
    public Expr indexEquivalent(IndexContext ic) throws QueryException {
        super.indexEquivalent(ic);
        return new Union(this.info, this.expr);
    }

    @Override
    public String toString() {
        return this.toString(" or ");
    }
}

