/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.core.Perm;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ParseExpr
extends Expr {
    public final InputInfo info;
    public long size = -1L;
    public SeqType type;

    protected ParseExpr(InputInfo ii) {
        this.info = ii;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Item it = this.item(ctx, this.info);
        return it != null ? it.iter() : Empty.ITER;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter ir = this.iter(ctx);
        Item it = ir.next();
        if (it == null || ir.size() == 1L) {
            return it;
        }
        Item n = ir.next();
        if (n != null) {
            ValueBuilder vb = new ValueBuilder();
            vb.add(it);
            vb.add(n);
            n = ir.next();
            if (n != null) {
                vb.add(Str.get("..."));
            }
            Err.XPSEQ.thrw(ii, vb.value());
        }
        return it;
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        if (this.type().zeroOrOne()) {
            Item v = this.item(ctx, this.info);
            return v == null ? Empty.SEQ : v;
        }
        return ctx.iter(this).value();
    }

    @Override
    public final Item ebv(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it;
        if (this.type().zeroOrOne()) {
            it = this.item(ctx, this.info);
        } else {
            Iter ir = this.iter(ctx);
            it = ir.next();
            if (it != null && !it.type.isNode() && ir.next() != null) {
                Err.CONDTYPE.thrw(this.info, this);
            }
        }
        return it == null ? Bln.FALSE : it;
    }

    @Override
    public final Item test(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.ebv(ctx, this.info);
        return (it.type.isNumber() ? it.dbl(this.info) == (double)ctx.pos : it.bool(this.info)) ? it : null;
    }

    @Override
    public SeqType type() {
        return this.type != null ? this.type : SeqType.ITEM_ZM;
    }

    @Override
    public final long size() {
        return this.size == -1L ? this.type().occ() : this.size;
    }

    public final Expr preEval(QueryContext ctx) throws QueryException {
        return this.optPre(this.item(ctx, this.info), ctx);
    }

    protected final Expr optPre(Expr opt, QueryContext ctx) {
        if (opt != this) {
            ctx.compInfo("pre-evaluating %", this);
        }
        return opt == null ? Empty.SEQ : opt;
    }

    protected final Expr compBln(Expr e) {
        return e.type().eq(SeqType.BLN) ? e : Function.BOOLEAN.get(this.info, e);
    }

    public void checkNoUp(Expr e) throws QueryException {
        if (e != null && e.uses(Expr.Use.UPD)) {
            Err.UPNOT.thrw(this.info, this.description());
        }
    }

    public final void checkNoneUp(Expr ... expr) throws QueryException {
        if (expr != null) {
            for (Expr e : expr) {
                this.checkNoUp(e);
            }
        }
    }

    public void checkAllUp(Expr ... expr) throws QueryException {
        int s = 0;
        for (Expr e : expr) {
            e.checkUp();
            if (e.isVacuous()) continue;
            boolean u = e.uses(Expr.Use.UPD);
            if (u && s == 2 || !u && s == 1) {
                Err.UPNOT.thrw(this.info, this.description());
            }
            s = u ? 1 : 2;
        }
    }

    public final boolean checkBln(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info), AtomType.BLN);
        Type ip = it.type;
        if (!ip.isUntyped() && ip != AtomType.BLN) {
            Err.type(this, AtomType.BLN, it);
        }
        return it.bool(this.info);
    }

    public final double checkDbl(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(e.item(ctx, this.info), AtomType.DBL);
        Type ip = it.type;
        if (!ip.isUntyped() && !ip.isNumber()) {
            Err.number(this, it);
        }
        return it.dbl(this.info);
    }

    public final long checkItr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkItr(this.checkNoEmpty(e.item(ctx, this.info), AtomType.ITR));
    }

    public final long checkItr(Item it) throws QueryException {
        Type ip = it.type;
        if (!ip.isUntyped() && !ip.instanceOf(AtomType.ITR)) {
            Err.type(this, AtomType.ITR, it);
        }
        return it.itr(this.info);
    }

    public final ANode checkNode(Item it) throws QueryException {
        if (!it.type.isNode()) {
            Err.type(this, NodeType.NOD, it);
        }
        return (ANode)it;
    }

    public final DBNode checkDBNode(Item it) throws QueryException {
        if (!(it instanceof DBNode)) {
            Err.BXDB_NODB.thrw(this.info, this);
        }
        return (DBNode)it;
    }

    public final void checkColl(Expr e, QueryContext ctx) throws QueryException {
        byte[] u = this.checkStr(e, ctx);
        if (Token.eq(QueryText.URLCOLL, u)) {
            return;
        }
        Uri uri = Uri.uri(u);
        if (uri.isAbsolute() || !Token.eq(ctx.sc.baseURI().resolve(uri).string(), QueryText.URLCOLL)) {
            Err.IMPLCOL.thrw(this.info, e);
        }
    }

    public final byte[] checkStr(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkItem(e, ctx);
        Type ip = it.type;
        if (!ip.isString() && !ip.isUntyped()) {
            Err.type(this, AtomType.STR, it);
        }
        return it.string(this.info);
    }

    public final byte[] checkEStr(Item it) throws QueryException {
        if (it == null) {
            return Token.EMPTY;
        }
        Type ip = it.type;
        if (!ip.isString() && !ip.isUntyped()) {
            Err.type(this, AtomType.STR, it);
        }
        return it.string(this.info);
    }

    public final Value checkCtx(QueryContext ctx) throws QueryException {
        Value v = ctx.value;
        if (v == null) {
            Err.XPNOCTX.thrw(this.info, this);
        }
        return v;
    }

    public final Item checkItem(Expr e, QueryContext ctx) throws QueryException {
        return this.checkNoEmpty(e.item(ctx, this.info));
    }

    public final Bin checkBinary(Expr e, QueryContext ctx) throws QueryException {
        Item it = this.checkItem(e, ctx);
        if (!(it instanceof Bin)) {
            Err.BINARYTYPE.thrw(this.info, it.type);
        }
        return (Bin)it;
    }

    public final Item checkType(Item it, Type t) throws QueryException {
        if (!this.checkNoEmpty((Item)it).type.instanceOf(t)) {
            Err.type(this, t, it);
        }
        return it;
    }

    public final Item checkNoEmpty(Item it) throws QueryException {
        if (it == null) {
            Err.XPEMPTY.thrw(this.info, this.description());
        }
        return it;
    }

    private Item checkNoEmpty(Item it, Type t) throws QueryException {
        if (it == null) {
            Err.XPEMPTYPE.thrw(this.info, this.description(), t);
        }
        return it;
    }

    public final byte[] checkEStr(Expr e, QueryContext ctx) throws QueryException {
        return this.checkEStr(e.item(ctx, this.info));
    }

    public final void checkCreate(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, Perm.CREATE);
    }

    public final void checkWrite(QueryContext ctx) throws QueryException {
        this.checkPerm(ctx, Perm.WRITE);
    }

    private void checkPerm(QueryContext ctx, Perm p) throws QueryException {
        if (!ctx.context.user.has(p)) {
            throw Err.BASX_PERM.thrw(this.info, new Object[]{p});
        }
    }

    public Map checkMap(Item it) throws QueryException {
        if (it instanceof Map) {
            return (Map)it;
        }
        throw Err.type(this, SeqType.ANY_MAP, it);
    }
}

