/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Pos;
import org.basex.query.func.Function;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public abstract class Preds
extends ParseExpr {
    public Expr[] preds;
    public boolean last;
    public Pos pos;

    protected Preds(InputInfo ii, Expr[] p) {
        super(ii);
        this.preds = p;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.preds);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        for (int p = 0; p < this.preds.length; ++p) {
            Expr pr = this.preds[p].compile(ctx).compEbv(ctx);
            if ((pr = Pos.get(CmpV.OpV.EQ, pr, pr, this.info)) instanceof CmpG || pr instanceof CmpV) {
                Cmp cmp = (Cmp)pr;
                if (cmp.expr[0].isFunction(Function.POSITION) && cmp.expr[1].isFunction(Function.LAST) && (cmp instanceof CmpG && ((CmpG)cmp).op == CmpG.OpG.EQ || cmp instanceof CmpV && ((CmpV)cmp).op == CmpV.OpV.EQ)) {
                    ctx.compInfo("rewriting %", pr);
                    pr = cmp.expr[1];
                }
            }
            if (pr.isValue()) {
                if (!pr.ebv(ctx, this.info).bool(this.info)) {
                    ctx.compInfo("%: removing %", this.description(), pr);
                    return Empty.SEQ;
                }
                ctx.compInfo("%: removing %", this.description(), pr);
                this.preds = Array.delete(this.preds, p--);
                continue;
            }
            if (pr instanceof And && !pr.uses(Expr.Use.POS)) {
                ctx.compInfo("rewriting % to predicate(s)", pr.description());
                Expr[] and = ((And)pr).expr;
                int m = and.length - 1;
                ArrayList<Expr> tmp = new ArrayList<Expr>(this.preds.length + m);
                tmp.addAll(Arrays.asList(this.preds).subList(0, p));
                for (Expr a : and) {
                    tmp.add(Function.BOOLEAN.get(this.info, a).compEbv(ctx));
                }
                tmp.addAll(Arrays.asList(this.preds).subList(p + 1, this.preds.length));
                this.preds = tmp.toArray(new Expr[tmp.size()]);
                continue;
            }
            this.preds[p] = pr;
        }
        return this;
    }

    protected boolean useIterator() {
        this.pos = this.preds[0] instanceof Pos ? (Pos)this.preds[0] : null;
        this.last = this.preds[0].isFunction(Function.LAST);
        boolean np1 = true;
        boolean np2 = true;
        for (int p = 0; p < this.preds.length; ++p) {
            boolean np = !this.preds[p].type().mayBeNumber() && !this.preds[p].uses(Expr.Use.POS);
            np1 &= np;
            if (p <= 0) continue;
            np2 &= np;
        }
        return np1 || this.pos != null && np2 || this.last && this.preds.length == 1;
    }

    public boolean preds(Item it, QueryContext ctx) throws QueryException {
        if (this.preds.length == 0) {
            return true;
        }
        Item i = null;
        for (Expr p : this.preds) {
            ctx.value = it;
            i = p.test(ctx, this.info);
            if (i != null) continue;
            return false;
        }
        it.score(i.score());
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        for (Expr p : this.preds) {
            if ((u != Expr.Use.POS || !p.type().mayBeNumber()) && !p.uses(u)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (Expr p : this.preds) {
            c += p.count(v);
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        for (Expr p : this.preds) {
            if (p.count(v) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        for (int p = 0; p < this.preds.length; ++p) {
            this.preds[p] = this.preds[p].remove(v);
        }
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (Expr p : this.preds) {
            if (p.databases(db)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        for (Expr p : this.preds) {
            p.plan(plan);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Expr e : this.preds) {
            sb.append("[" + e + ']');
        }
        return sb.toString();
    }
}

