/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class Range
extends Arr {
    public Range(InputInfo ii, Expr e1, Expr e2) {
        super(ii, e1, e2);
        this.type = SeqType.ITR_OM;
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        Expr e = this;
        if (this.oneIsEmpty()) {
            e = Empty.SEQ;
        } else if (this.allAreValues()) {
            e = this.value(ctx);
        }
        return this.optPre(e, ctx);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        long[] v = this.rng(ctx);
        return v == null || v[0] > v[1] ? Empty.SEQ : (v[0] == v[1] ? Int.get(v[0]) : new RangeSeq(v[0], v[1] - v[0] + 1L));
    }

    private long[] rng(QueryContext ctx) throws QueryException {
        Item a = this.expr[0].item(ctx, this.info);
        if (a == null) {
            return null;
        }
        Item b = this.expr[1].item(ctx, this.info);
        if (b == null) {
            return null;
        }
        return new long[]{this.checkItr(a), this.checkItr(b)};
    }

    @Override
    public String toString() {
        return "(" + this.toString(" to ") + ")";
    }
}

