/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class Treat
extends Single {
    public Treat(InputInfo ii, Expr e, SeqType s) {
        super(ii, e);
        this.type = s;
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        return this.expr.isValue() ? this.optPre(this.value(ctx), ctx) : this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        final Iter iter = ctx.iter(this.expr);
        final Item it = iter.next();
        if (it == null) {
            if (this.type.mayBeZero()) {
                return Empty.ITER;
            }
            throw Err.XPEMPTY.thrw(this.info, this.description());
        }
        if (this.type.occ == SeqType.Occ.ZERO) {
            Err.NOTREAT.thrw(this.info, this.description(), it.type, this.type);
        }
        if (this.type.zeroOrOne()) {
            if (iter.next() != null) {
                Err.NOTREATS.thrw(this.info, this.description(), this.type);
            }
            if (!it.type.instanceOf(this.type.type)) {
                Err.NOTREAT.thrw(this.info, this.description(), it.type, this.type);
            }
            return it.iter();
        }
        return new Iter(){
            Item i;
            {
                this.i = it;
            }

            @Override
            public Item next() throws QueryException {
                if (this.i == null) {
                    return null;
                }
                if (!this.i.type.instanceOf(Treat.this.type.type)) {
                    Err.NOTREAT.thrw(Treat.this.info, Treat.this.description(), this.i.type, Treat.this.type);
                }
                Item ii = this.i;
                this.i = iter.next();
                return ii;
            }
        };
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        Value val = ctx.value(this.expr);
        long len = val.size();
        if (len == 0L) {
            if (this.type.mayBeZero()) {
                return val;
            }
            throw Err.XPEMPTY.thrw(this.info, this.description());
        }
        if (this.type.occ == SeqType.Occ.ZERO) {
            Err.NOTREAT.thrw(this.info, this.description(), val.type, this.type);
        }
        if (this.type.zeroOrOne()) {
            if (len > 1L) {
                Err.NOTREATS.thrw(this.info, this.description(), this.type);
            }
            Item it = val.itemAt(0L);
            if (!it.type.instanceOf(this.type.type)) {
                Err.NOTREAT.thrw(this.info, this.description(), it.type, this.type);
            }
            return it;
        }
        for (long i = 0L; i < len; ++i) {
            Item it = val.itemAt(i);
            if (it.type.instanceOf(this.type.type)) continue;
            Err.NOTREAT.thrw(this.info, this.description(), it.type, this.type);
        }
        return val;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.TYP, this.type), this.expr);
    }

    @Override
    public String toString() {
        return this.expr + " " + "treat" + ' ' + "as" + ' ' + this.type;
    }
}

