/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public final class TypeCase
extends Single {
    final Var var;

    public TypeCase(InputInfo ii, Var v, Expr r) {
        super(ii, r);
        this.var = v;
    }

    @Override
    public TypeCase compile(QueryContext ctx) throws QueryException {
        return this.compile(ctx, null);
    }

    TypeCase compile(QueryContext ctx, Value v) throws QueryException {
        if (this.var.name == null) {
            super.compile(ctx);
        } else {
            int s = ctx.vars.size();
            ctx.vars.add(v == null ? this.var : this.var.bind(v, ctx).copy());
            super.compile(ctx);
            ctx.vars.size(s);
        }
        this.type = this.expr.type();
        return this;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.VAR || super.uses(u);
    }

    Iter iter(QueryContext ctx, Value seq) throws QueryException {
        if (this.var.type != null && !this.var.type.instance(seq)) {
            return null;
        }
        if (this.var.name == null) {
            return ctx.iter(this.expr);
        }
        int s = ctx.vars.size();
        ctx.vars.add(this.var.bind(seq, ctx).copy());
        ValueIter ic = ctx.value(this.expr).iter();
        ctx.vars.size(s);
        return ic;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.VAR, this.var.name != null ? (Object)this.var.name.string() : ""), this.expr);
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.var.type == null ? "default" : "case");
        if (this.var.name != null) {
            tb.add(32);
        }
        return tb.add(this.var + " " + "return" + ' ' + this.expr).toString();
    }

    @Override
    public TypeCase markTailCalls() {
        this.expr = this.expr.markTailCalls();
        return this;
    }
}

