/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCase;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class TypeSwitch
extends ParseExpr {
    private final TypeCase[] cases;
    private Expr ts;

    public TypeSwitch(InputInfo ii, Expr t, TypeCase[] c) {
        super(ii);
        this.ts = t;
        this.cases = c;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoUp(this.ts);
        Expr[] tmp = new Expr[this.cases.length];
        for (int i = 0; i < this.cases.length; ++i) {
            tmp[i] = this.cases[i].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.ts = this.ts.compile(ctx);
        if (this.ts.isValue()) {
            for (TypeCase tc : this.cases) {
                if (tc.var.type != null && !tc.var.type.instance(this.ts.value(ctx))) continue;
                return this.optPre(tc.compile((QueryContext)ctx, (Value)((Value)this.ts)).expr, ctx);
            }
        }
        for (TypeCase tc : this.cases) {
            tc.compile(ctx);
        }
        boolean eq = true;
        for (int i = 1; i < this.cases.length; ++i) {
            eq &= this.cases[i - 1].expr.sameAs(this.cases[i].expr);
        }
        if (eq) {
            return this.optPre(null, ctx);
        }
        this.type = this.cases[0].type();
        for (int c = 1; c < this.cases.length; ++c) {
            this.type = this.type.intersect(this.cases[c].type());
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value seq = ctx.value(this.ts);
        for (TypeCase tc : this.cases) {
            Iter iter = tc.iter(ctx, seq);
            if (iter == null) continue;
            return iter;
        }
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public boolean isVacuous() {
        for (TypeCase tc : this.cases) {
            if (tc.expr.isVacuous()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        if (u == Expr.Use.VAR) {
            return true;
        }
        for (TypeCase tc : this.cases) {
            if (!tc.uses(u)) continue;
            return true;
        }
        return this.ts.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = this.ts.count(v);
        for (TypeCase tc : this.cases) {
            c += tc.count(v);
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        for (TypeCase tc : this.cases) {
            if (tc.removable(v)) continue;
            return false;
        }
        return this.ts.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        for (TypeCase tc : this.cases) {
            tc.remove(v);
        }
        this.ts = this.ts.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (TypeCase tc : this.cases) {
            if (tc.databases(db)) continue;
            return false;
        }
        return this.ts.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.cases, this.ts});
    }

    @Override
    public String toString() {
        return new TokenBuilder("typeswitch(" + this.ts + ")" + ' ').addSep(this.cases, ", ").toString();
    }

    @Override
    public Expr markTailCalls() {
        for (TypeCase t : this.cases) {
            t.markTailCalls();
        }
        return this;
    }
}

