/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringToken;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.expr.Union;
import org.basex.query.func.Function;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class ValueAccess
extends IndexAccess {
    private Expr expr;
    final IndexType itype;

    public ValueAccess(InputInfo ii, Expr e, IndexType t, IndexContext ic) {
        super(ic, ii);
        this.expr = e;
        this.itype = t;
    }

    @Override
    public NodeIter iter(QueryContext ctx) throws QueryException {
        Item it;
        Iter[] iter = new NodeIter[]{};
        Iter ir = ctx.iter(this.expr);
        while ((it = ir.next()) != null) {
            int s = iter.length;
            NodeIter[] tmp = new NodeIter[s + 1];
            System.arraycopy(iter, 0, tmp, 0, s);
            iter = tmp;
            iter[s] = this.index(it.string(this.info));
        }
        return iter.length == 0 ? AxisMoreIter.EMPTY : (iter.length == 1 ? iter[0] : new Union(this.info, this.expr).eval(iter));
    }

    private AxisIter index(byte[] term) {
        final Data data = this.ictx.data;
        final IndexIterator ii = term.length <= data.meta.maxlen && (this.itype == IndexType.TEXT ? data.meta.textindex : data.meta.attrindex) ? data.iter(new StringToken(this.itype, term)) : this.scan(term);
        return new AxisIter(){
            final byte kind;
            {
                this.kind = (byte)(ValueAccess.this.itype == IndexType.TEXT ? 2 : 3);
            }

            @Override
            public ANode next() {
                if (ii.more()) {
                    return new DBNode(data, ii.next(), this.kind);
                }
                return null;
            }
        };
    }

    private IndexIterator scan(final byte[] val) {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final Data data;
            int pre;
            {
                this.text = ValueAccess.this.itype == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.data = ValueAccess.this.ictx.data;
                this.pre = -1;
            }

            @Override
            public int next() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.data.meta.size) {
                    if (this.data.kind(this.pre) != this.kind || !Token.eq(this.data.text(this.pre, this.text), val)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.expr.uses(u);
    }

    @Override
    public int count(Var v) {
        return this.expr.count(v);
    }

    @Override
    public boolean removable(Var v) {
        return this.expr.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        this.expr = this.expr.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        return this.expr.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[]{QueryText.DATA, this.ictx.data.meta.name, QueryText.TYP, this.itype}), this.expr);
    }

    @Override
    public String toString() {
        return (this.itype == IndexType.TEXT ? Function._DB_TEXT : Function._DB_ATTRIBUTE).get(this.info, Str.get(this.ictx.data.meta.name), this.expr).toString();
    }
}

