/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.flwor.GroupPartition;
import org.basex.query.flwor.GroupSpec;
import org.basex.query.flwor.Order;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Group
extends ParseExpr {
    private final GroupSpec[] groupby;
    private final Var[][] nongroup;
    GroupPartition gp;

    public Group(InputInfo ii, GroupSpec[] gb, Var[][] ng) {
        super(ii);
        this.groupby = gb;
        this.nongroup = ng;
    }

    void init(Order ob) {
        this.gp = new GroupPartition(this.groupby, this.nongroup, ob, this.info);
    }

    @Override
    public void checkUp() throws QueryException {
        for (GroupSpec g : this.groupby) {
            g.checkUp();
        }
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        for (GroupSpec groupSpec : this.groupby) {
            groupSpec.compile(ctx);
            if (groupSpec.var.ret != null) {
                groupSpec.var.ret = SeqType.get(groupSpec.var.ret.type, 1L);
            }
            ctx.vars.add(groupSpec.var);
        }
        for (ParseExpr parseExpr : this.nongroup[1]) {
            ctx.vars.add((Var)parseExpr);
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) {
        throw Util.notexpected(this);
    }

    @Override
    public boolean uses(Expr.Use use) {
        for (GroupSpec v : this.groupby) {
            if (!v.uses(use)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (GroupSpec groupSpec : this.groupby) {
            c += groupSpec.count(v);
        }
        for (ParseExpr parseExpr : this.nongroup[0]) {
            c += ((Var)parseExpr).count(v);
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        for (GroupSpec groupSpec : this.groupby) {
            if (groupSpec.count(v) == 0) continue;
            return false;
        }
        for (ParseExpr parseExpr : this.nongroup[0]) {
            if (((Var)parseExpr).count(v) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (GroupSpec groupSpec : this.groupby) {
            if (groupSpec.databases(db)) continue;
            return false;
        }
        for (ParseExpr parseExpr : this.nongroup[0]) {
            if (((Var)parseExpr).databases(db)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), this.groupby);
    }

    @Override
    public String toString() {
        return new TokenBuilder(" group by ").addSep(this.groupby, ", ").toString();
    }
}

