/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.flwor.ForLet;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.ft.Scoring;

public final class Let
extends ForLet {
    final boolean score;

    public Let(InputInfo ii, Expr e, Var v) {
        this(ii, e, v, false);
    }

    public Let(InputInfo ii, Expr e, Var v, boolean s) {
        super(ii, e, v);
        this.score = s;
    }

    @Override
    public Let compile(QueryContext ctx) throws QueryException {
        this.expr = this.expr.compile(ctx);
        this.type = SeqType.ITEM;
        this.size = 1L;
        this.var.size = this.expr.size();
        this.var.ret = this.score ? SeqType.DBL : this.expr.type();
        ctx.vars.add(this.var);
        return this;
    }

    @Override
    public Iter iter(final QueryContext ctx) {
        final Var vr = this.var.copy();
        return new Iter(){
            private int vs;
            private boolean more;

            @Override
            public Item next() throws QueryException {
                if (!this.more) {
                    Value v;
                    this.vs = ctx.vars.size();
                    if (Let.this.score) {
                        Item it;
                        double s = 0.0;
                        int c = 0;
                        Iter ir = ctx.iter(Let.this.expr);
                        while ((it = ir.next()) != null) {
                            s += it.score();
                            ++c;
                        }
                        v = Dbl.get(Scoring.let(s, c));
                    } else {
                        v = ctx.value(Let.this.expr);
                    }
                    ctx.vars.add(vr.bind(v, ctx));
                    this.more = true;
                    return Bln.TRUE;
                }
                this.reset();
                return null;
            }

            @Override
            public long size() {
                return 1L;
            }

            @Override
            public Item get(long i) throws QueryException {
                this.reset();
                return this.next();
            }

            @Override
            public boolean reset() {
                if (this.more) {
                    ctx.vars.size(this.vs);
                    this.more = false;
                }
                return true;
            }
        };
    }

    @Override
    boolean simple(boolean one) {
        return !this.score;
    }

    @Override
    public boolean declares(Var v) {
        return this.var.is(v);
    }

    @Override
    public Var[] vars() {
        return new Var[]{this.var};
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(this.score ? "score" : (Object)QueryText.VAR, this.var), this.expr);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("let").append(' ');
        if (this.score) {
            sb.append("score").append(' ');
        }
        sb.append(this.var).append(' ').append(":=").append(' ').append(this.expr);
        return sb.toString();
    }
}

