/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.flwor;

import java.util.ArrayList;
import java.util.Arrays;
import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.flwor.OrderBy;
import org.basex.query.iter.Iter;
import org.basex.query.util.ValueList;
import org.basex.query.util.Var;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public final class Order
extends ParseExpr {
    final OrderBy[] ob;
    private ArrayList<Item[]> keys;
    private ValueList values;

    public Order(InputInfo ii, OrderBy[] o) {
        super(ii);
        this.ob = o;
    }

    @Override
    public void checkUp() throws QueryException {
        for (OrderBy o : this.ob) {
            o.checkUp();
        }
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        for (OrderBy o : this.ob) {
            o.compile(ctx);
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) {
        return new OrderedIter(this.keys, this.values);
    }

    Order set(ArrayList<Item[]> ks, ValueList vs) {
        this.keys = ks;
        this.values = vs;
        return this;
    }

    void add(QueryContext ctx, Expr e, ArrayList<Item[]> ks, ValueList vs) throws QueryException {
        Item[] k = new Item[this.ob.length];
        int o = k.length;
        while (o-- > 0) {
            k[o] = this.ob[o].key(ctx, ks.size());
        }
        ks.add(k);
        vs.add(ctx.value(e));
    }

    @Override
    public boolean uses(Expr.Use u) {
        for (OrderBy o : this.ob) {
            if (!o.uses(u)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (OrderBy o : this.ob) {
            c += o.count(v);
        }
        return c;
    }

    @Override
    public boolean removable(Var v) {
        for (OrderBy o : this.ob) {
            if (o.removable(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Order remove(Var v) {
        for (int o = 0; o < this.ob.length; ++o) {
            this.ob[o] = this.ob[o].remove(v);
        }
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        for (OrderBy o : this.ob) {
            if (o.databases(db)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        for (int o = 0; o != this.ob.length - 1; ++o) {
            this.ob[o].plan(el);
        }
        this.addPlan(plan, el, new ExprInfo[0]);
    }

    @Override
    public String toString() {
        return new TokenBuilder(" order by ").addSep(Arrays.copyOf(this.ob, this.ob.length - 1), ", ").toString();
    }

    class OrderedIter
    extends Iter {
        final ArrayList<Item[]> kl;
        final ValueList vl;
        int end;
        int pos = -1;
        int[] order;
        Iter ir;

        public OrderedIter(ArrayList<Item[]> ks, ValueList vs) {
            this.kl = ks;
            this.vl = vs;
        }

        @Override
        public Item next() throws QueryException {
            if (this.order == null) {
                this.end = this.vl.size();
                this.order = new int[this.end];
                for (int i = 0; i < this.end; ++i) {
                    this.order[i] = i;
                }
                this.sort(this.order, 0, this.end);
            }
            while (true) {
                if (this.ir != null) {
                    Item i = this.ir.next();
                    if (i != null) {
                        return i;
                    }
                    this.ir = null;
                    continue;
                }
                if (++this.pos == this.end) {
                    return null;
                }
                this.ir = this.vl.get(this.order[this.pos]).iter();
            }
        }

        void sort(int[] o, int s, int e) throws QueryException {
            int c;
            int a;
            if (e < 7) {
                for (int i = s; i < e + s; ++i) {
                    for (int j = i; j > s && this.d(o, j - 1, j) > 0; --j) {
                        Array.swap(o, j, j - 1);
                    }
                }
                return;
            }
            int m = s + (e >> 1);
            if (e > 7) {
                int l = s;
                int n = s + e - 1;
                if (e > 40) {
                    int k = e >>> 3;
                    l = this.m(o, l, l + k, l + (k << 1));
                    m = this.m(o, m - k, m, m + k);
                    n = this.m(o, n - (k << 1), n - k, n);
                }
                m = this.m(o, l, m, n);
            }
            Item[] im = this.kl.get(o[m]);
            int b = a = s;
            int d = c = s + e - 1;
            while (true) {
                int h;
                if (b <= c && (h = this.d(this.kl.get(o[b]), im)) <= 0) {
                    if (h == 0) {
                        Array.swap(o, a++, b);
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (h = this.d(this.kl.get(o[c]), im)) >= 0) {
                    if (h == 0) {
                        Array.swap(o, c, d--);
                    }
                    --c;
                }
                if (b > c) break;
                Array.swap(o, b++, c--);
            }
            int n = s + e;
            int k = Math.min(a - s, b - a);
            Array.swap(o, s, b - k, k);
            k = Math.min(d - c, n - d - 1);
            Array.swap(o, b, n - k, k);
            k = b - a;
            if (k > 1) {
                this.sort(o, s, k);
            }
            if ((k = d - c) > 1) {
                this.sort(o, n - k, k);
            }
        }

        private int d(Item[] sa, Item[] sb) throws QueryException {
            for (int k = 0; k < Order.this.ob.length; ++k) {
                int c;
                OrderBy or = Order.this.ob[k];
                Item m = sa[k];
                Item n = sb[k];
                int n2 = m == null ? (n == null ? 0 : (or.lst ? -1 : 1)) : (n == null ? (or.lst ? 1 : -1) : (c = m.diff(Order.this.info, n)));
                if (c == 0) continue;
                return or.desc ? -c : c;
            }
            return 0;
        }

        private int d(int[] o, int a, int b) throws QueryException {
            return this.d(this.kl.get(o[a]), this.kl.get(o[b]));
        }

        private int m(int[] o, int a, int b, int c) throws QueryException {
            Item[] ka = this.kl.get(o[a]);
            Item[] kb = this.kl.get(o[b]);
            Item[] kc = this.kl.get(o[c]);
            return this.d(ka, kb) < 0 ? (this.d(kb, kc) < 0 ? b : (this.d(ka, kc) < 0 ? c : a)) : (this.d(kb, kc) > 0 ? b : (this.d(ka, kc) > 0 ? c : a));
        }
    }
}

