/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.util.Var;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;
import org.basex.util.list.StringList;

public final class FTDistance
extends FTFilter {
    private final Expr[] dist;

    public FTDistance(InputInfo ii, FTExpr e, Expr[] d, FTUnit u) {
        super(ii, e);
        this.dist = d;
        this.unit = u;
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.dist);
        super.checkUp();
    }

    @Override
    public FTExpr compile(QueryContext ctx) throws QueryException {
        for (int d = 0; d < this.dist.length; ++d) {
            this.dist[d] = this.dist[d].compile(ctx);
        }
        return super.compile(ctx);
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) throws QueryException {
        long min = this.checkItr(this.dist[0], ctx);
        long max = this.checkItr(this.dist[1], ctx);
        mtc.sort();
        FTMatch match = new FTMatch();
        FTStringMatch sm = null;
        FTStringMatch f = null;
        for (FTStringMatch m : mtc) {
            if (m.ex) {
                match.add(m);
                continue;
            }
            if (sm != null) {
                int d = this.pos(m.s, lex) - this.pos(sm.e, lex) - 1;
                if ((long)d < min || (long)d > max) {
                    return false;
                }
            } else {
                f = m;
            }
            sm = m;
        }
        f.e = sm.e;
        mtc.reset();
        mtc.add(f);
        mtc.add(match);
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        for (Expr d : this.dist) {
            if (!d.uses(u)) continue;
            return true;
        }
        return super.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        for (Expr d : this.dist) {
            c += d.count(v);
        }
        return c + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        for (Expr d : this.dist) {
            if (d.removable(v)) continue;
            return false;
        }
        return super.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        for (int d = 0; d != this.dist.length; ++d) {
            this.dist[d] = this.dist[d].remove(v);
        }
        return super.remove(v);
    }

    @Override
    public boolean databases(StringList db) {
        for (Expr d : this.dist) {
            if (d.databases(db)) continue;
            return false;
        }
        return super.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem("distance", this.dist[0] + "-" + this.dist[1] + ' ' + (Object)((Object)this.unit)), this.expr);
    }

    @Override
    public String toString() {
        return super.toString() + "distance" + "(" + this.dist[0] + '-' + this.dist[1] + ' ' + (Object)((Object)this.unit) + ")";
    }
}

