/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.core.Prop;
import org.basex.query.QueryException;
import org.basex.query.ft.FTTokens;
import org.basex.query.ft.FTWildcard;
import org.basex.query.ft.FTWords;
import org.basex.query.util.Err;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.ft.FTBitapSearch;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.TokenList;

final class FTTokenizer {
    final TokenObjMap<FTWildcard> wcCache = new TokenObjMap();
    final Levenshtein ls = new Levenshtein();
    final FTWords words;
    final FTOpt opt;
    final int lserr;
    private final FTBitapSearch.TokenComparator cmp;
    private final TokenObjMap<FTTokens> cache = new TokenObjMap();

    public FTTokenizer(FTWords w, FTOpt o, Prop pr) {
        this.words = w;
        this.opt = o;
        this.lserr = pr.num(Prop.LSERROR);
        this.cmp = new FTBitapSearch.TokenComparator(){

            @Override
            public boolean equal(byte[] in, byte[] qu) throws QueryException {
                FTWildcard ftw = null;
                if (FTTokenizer.this.opt.is(FTFlag.WC) && (ftw = FTTokenizer.this.wcCache.get(qu)) == null) {
                    ftw = new FTWildcard(qu);
                    if (!ftw.parse()) {
                        Err.FTREG.thrw(FTTokenizer.this.words.info, new Object[]{qu});
                    }
                    FTTokenizer.this.wcCache.add(qu, ftw);
                }
                return FTTokenizer.this.opt.sw != null && FTTokenizer.this.opt.sw.id(qu) != 0 || (FTTokenizer.this.opt.is(FTFlag.FZ) ? FTTokenizer.this.ls.similar(in, qu, FTTokenizer.this.lserr) : (ftw != null ? ftw.match(in) : Token.eq(in, qu)));
            }
        };
    }

    FTLexer copy(FTLexer lex) {
        FTOpt to = lex.ftOpt();
        to.set(FTFlag.ST, this.opt.is(FTFlag.ST));
        to.set(FTFlag.DC, this.opt.is(FTFlag.DC));
        to.set(FTFlag.CS, this.opt.is(FTFlag.CS));
        to.ln = this.opt.ln;
        to.th = this.opt.th;
        to.sd = this.opt.sd;
        return new FTLexer(to).init(lex.text());
    }

    FTTokens cache(byte[] query) throws QueryException {
        FTTokens tokens = this.cache.get(query);
        if (tokens == null) {
            tokens = new FTTokens();
            this.cache.add(query, tokens);
            FTLexer quLex = new FTLexer(this.opt).init(query);
            TokenList quList = new TokenList(1);
            while (quLex.hasNext()) {
                quList.add(((FTIterator)quLex).nextToken());
            }
            tokens.add(quList);
            if (this.opt.th != null) {
                for (byte[] ext : this.opt.th.find(this.words.info, query)) {
                    TokenList tl = new TokenList(1);
                    ((FTIterator)quLex).init(ext);
                    while (quLex.hasNext()) {
                        tl.add(((FTIterator)quLex).nextToken());
                    }
                    tokens.add(tl);
                }
            }
        }
        return tokens;
    }

    int contains(FTTokens query, FTLexer input) throws QueryException {
        input.init();
        FTBitapSearch bs = new FTBitapSearch(input, query, this.cmp);
        int c = 0;
        while (bs.hasNext()) {
            int pos = bs.next();
            this.words.add(pos, pos + query.length() - 1);
            ++c;
        }
        ++this.words.matches.sTokenNum;
        this.words.first = false;
        return c;
    }
}

