/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import org.basex.data.Data;
import org.basex.data.FTMatches;
import org.basex.data.MetaData;
import org.basex.index.query.FTIndexIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTMode;
import org.basex.query.ft.FTNot;
import org.basex.query.ft.FTTokenizer;
import org.basex.query.ft.FTTokens;
import org.basex.query.iter.FTIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.IndexContext;
import org.basex.query.util.Var;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FTNode;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Scoring;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class FTWords
extends FTExpr {
    FTTokenizer ftt;
    Data data;
    TokenList txt;
    FTMatches matches = new FTMatches(0);
    boolean first;
    FTMode mode = FTMode.ANY;
    private Expr query;
    private Expr[] occ;
    private int tokNum;
    private boolean fast;

    public FTWords(InputInfo ii, Expr e, FTMode m, Expr[] o) {
        super(ii, new FTExpr[0]);
        this.query = e;
        this.mode = m;
        this.occ = o;
    }

    public FTWords(InputInfo ii, Data d, Value t, FTMode m, QueryContext ctx) throws QueryException {
        super(ii, new FTExpr[0]);
        this.query = t;
        this.mode = m;
        this.data = d;
        this.compile(ctx);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkNoneUp(this.occ);
        this.checkNoUp(this.query);
    }

    @Override
    public FTWords compile(QueryContext ctx) throws QueryException {
        if (this.occ != null) {
            for (int o = 0; o < this.occ.length; ++o) {
                this.occ[o] = this.occ[o].compile(ctx);
            }
        }
        if (this.txt == null) {
            this.query = this.query.compile(ctx);
            if (this.query.isValue()) {
                this.txt = this.tokens(ctx);
            }
            boolean bl = this.fast = this.mode == FTMode.ANY && this.txt != null && this.occ == null;
            if (this.ftt == null) {
                this.ftt = new FTTokenizer(this, ctx.ftOpt(), ctx.context.prop);
            }
        }
        return this;
    }

    @Override
    public FTNode item(QueryContext ctx, InputInfo ii) throws QueryException {
        if (this.tokNum == 0) {
            ctx.ftoknum = (byte)(ctx.ftoknum + 1);
            this.tokNum = ctx.ftoknum;
        }
        this.matches.reset(this.tokNum);
        int c = this.contains(ctx);
        if (c == 0) {
            this.matches.size = 0;
        }
        return new FTNode(this.matches, c == 0 ? 0.0 : Scoring.word(c, ctx.fttoken.count()));
    }

    @Override
    public FTIter iter(final QueryContext ctx) {
        return new FTIter(){
            FTIndexIterator iat;
            int len;

            @Override
            public FTNode next() throws QueryException {
                if (this.iat == null) {
                    FTLexer lex = new FTLexer(FTWords.this.ftt.opt);
                    int t = 0;
                    TokenSet ts = FTWords.this.tokens(FTWords.this.txt != null ? FTWords.this.txt : FTWords.this.tokens(ctx), FTWords.this.ftt.opt);
                    for (byte[] k : ts) {
                        lex.init(k);
                        FTIndexIterator ia = null;
                        int d = 0;
                        if (!lex.hasNext()) {
                            return null;
                        }
                        do {
                            FTIndexIterator ir;
                            byte[] tok = lex.nextToken();
                            t += tok.length;
                            if (FTWords.this.ftt.opt.sw != null && FTWords.this.ftt.opt.sw.id(tok) != 0) {
                                ++d;
                                continue;
                            }
                            FTIndexIterator fTIndexIterator = ir = lex.get().length > FTWords.this.data.meta.maxlen ? FTWords.this.scan(lex) : (FTIndexIterator)FTWords.this.data.iter(lex);
                            if (ia == null) {
                                ia = ir;
                                continue;
                            }
                            ia = FTIndexIterator.intersect(ia, ir, ++d);
                            d = 0;
                        } while (lex.hasNext());
                        if (this.iat == null) {
                            this.len = t;
                            this.iat = ia;
                        } else if (FTWords.this.mode == FTMode.ALL || FTWords.this.mode == FTMode.ALL_WORDS) {
                            if (ia.size() == 0) {
                                return null;
                            }
                            this.len += t;
                            this.iat = FTIndexIterator.intersect(ia, this.iat, 0);
                        } else {
                            if (ia.size() == 0) continue;
                            this.len = Math.max(t, this.len);
                            this.iat = FTIndexIterator.union(ia, this.iat);
                        }
                        ctx.ftoknum = (byte)(ctx.ftoknum + 1);
                        this.iat.tokenNum(ctx.ftoknum);
                    }
                }
                return this.iat == null || !this.iat.more() ? null : new FTNode(this.iat.matches(), FTWords.this.data, this.iat.next(), this.len, this.iat.size(), -1.0);
            }
        };
    }

    FTIndexIterator scan(FTLexer lex) throws QueryException {
        final FTLexer intok = new FTLexer(this.ftt.opt);
        final FTTokens qtok = this.ftt.cache(lex.get());
        return new FTIndexIterator(){
            int pre = -1;

            @Override
            public int next() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < FTWords.this.data.meta.size) {
                    if (FTWords.this.data.kind(this.pre) != 2) continue;
                    intok.init(FTWords.this.data.text(this.pre, true));
                    FTWords.this.matches.reset(0);
                    try {
                        if (FTWords.this.ftt.contains(qtok, intok) == 0) continue;
                        return true;
                    }
                    catch (QueryException queryException) {
                    }
                }
                return false;
            }

            @Override
            public FTMatches matches() {
                return FTWords.this.matches;
            }

            @Override
            public int size() {
                return FTWords.this.data.meta.size >>> 1;
            }
        };
    }

    TokenList tokens(QueryContext ctx) throws QueryException {
        byte[] qu;
        TokenList tl = new TokenList();
        Iter ir = ctx.iter(this.query);
        while ((qu = this.nextToken(ir)) != null) {
            if (qu.length == 0 && this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS) continue;
            tl.add(qu);
        }
        return tl;
    }

    private int contains(QueryContext ctx) throws QueryException {
        long mx;
        this.first = true;
        FTLexer intok = this.ftt.copy(ctx.fttoken);
        int num = 0;
        if (this.fast) {
            for (byte[] t : this.txt) {
                FTTokens qtok = this.ftt.cache(t);
                num = Math.max(num, this.ftt.contains(qtok, intok) * qtok.length());
            }
            return num;
        }
        TokenList tl = this.tokens(ctx);
        TokenSet ts = this.tokens(tl, intok.ftOpt());
        boolean all = this.mode == FTMode.ALL || this.mode == FTMode.ALL_WORDS;
        int oc = 0;
        for (byte[] k : ts) {
            FTTokens qtok = this.ftt.cache(k);
            int o = this.ftt.contains(qtok, intok);
            if (all && o == 0) {
                return 0;
            }
            num = Math.max(num, o * qtok.length());
            oc += o;
        }
        long mn = this.occ != null ? this.checkItr(this.occ[0], ctx) : 1L;
        long l = mx = this.occ != null ? this.checkItr(this.occ[1], ctx) : Long.MAX_VALUE;
        if (mn == 0L && oc == 0) {
            this.matches = FTNot.not(this.matches);
        }
        return (long)oc >= mn && (long)oc <= mx ? Math.max(1, num) : 0;
    }

    TokenSet tokens(TokenList list, FTOpt ftopt) {
        TokenSet ts = new TokenSet();
        switch (this.mode) {
            case ALL: 
            case ANY: {
                for (byte[] t : list) {
                    ts.add(t);
                }
                break;
            }
            case ALL_WORDS: 
            case ANY_WORD: {
                FTLexer l = new FTLexer(ftopt);
                for (byte[] t : list) {
                    l.init(t);
                    while (l.hasNext()) {
                        ts.add(l.nextToken());
                    }
                }
                break;
            }
            case PHRASE: {
                TokenBuilder tb = new TokenBuilder();
                for (byte[] t : list) {
                    tb.add(t).add(32);
                }
                ts.add(tb.trim().finish());
            }
        }
        return ts;
    }

    byte[] nextToken(Iter iter) throws QueryException {
        Item it = iter.next();
        return it == null ? null : this.checkEStr(it);
    }

    void add(int s, int e) {
        if (!(this.first || this.mode != FTMode.ALL && this.mode != FTMode.ALL_WORDS)) {
            this.matches.and(s, e);
        } else {
            this.matches.or(s, e);
        }
    }

    @Override
    public boolean indexAccessible(IndexContext ic) {
        MetaData md = ic.data.meta;
        FTOpt fto = this.ftt.opt;
        if (this.occ != null || fto.isSet(FTFlag.CS) && md.casesens != fto.is(FTFlag.CS) || fto.isSet(FTFlag.DC) && md.diacritics != fto.is(FTFlag.DC) || fto.isSet(FTFlag.ST) && md.stemming != fto.is(FTFlag.ST) || fto.ln != null && !fto.ln.equals(md.language)) {
            return false;
        }
        if (this.txt == null) {
            ic.costs(Math.max(1, ic.data.meta.size >> 10));
            return true;
        }
        fto.copy(md);
        FTLexer ft = new FTLexer(fto);
        ic.costs(0);
        for (byte[] t : this.txt) {
            ft.init(t);
            while (ft.hasNext()) {
                byte[] tok = ft.nextToken();
                if (fto.sw != null && fto.sw.id(tok) != 0) continue;
                if (fto.is(FTFlag.WC)) {
                    t = ft.get();
                    if (t[0] == 46) {
                        return false;
                    }
                    int d = 0;
                    for (byte w : t) {
                        if (w != 123 && w != 92 && (w != 46 || ++d <= 1)) continue;
                        return false;
                    }
                }
                ic.addCosts(Math.max(1, ic.data.count(ft) >> 10));
            }
        }
        return true;
    }

    @Override
    public FTExpr indexEquivalent(IndexContext ic) {
        this.data = ic.data;
        return this;
    }

    @Override
    public boolean usesExclude() {
        return this.occ != null;
    }

    @Override
    public boolean uses(Expr.Use u) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (!o.uses(u)) continue;
                return true;
            }
        }
        return this.query.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        if (this.occ != null) {
            for (Expr o : this.occ) {
                c += o.count(v);
            }
        }
        return c + this.query.count(v);
    }

    @Override
    public boolean removable(Var v) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (o.removable(v)) continue;
                return false;
            }
        }
        return this.query.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        if (this.occ != null) {
            for (int o = 0; o < this.occ.length; ++o) {
                this.occ[o] = this.occ[o].remove(v);
            }
        }
        this.query = this.query.remove(v);
        return this;
    }

    @Override
    public boolean databases(StringList db) {
        if (this.occ != null) {
            for (Expr o : this.occ) {
                if (o.databases(db)) continue;
                return false;
            }
        }
        return this.query.databases(db);
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.occ, this.query});
    }

    @Override
    public String toString() {
        boolean str;
        StringBuilder sb = new StringBuilder();
        boolean bl = str = this.query instanceof Item && ((Item)this.query).type.isString();
        if (!str) {
            sb.append("{ ");
        }
        sb.append(this.query);
        if (!str) {
            sb.append(" }");
        }
        switch (this.mode) {
            case ALL: {
                sb.append(" all");
                break;
            }
            case ALL_WORDS: {
                sb.append(" all words");
                break;
            }
            case ANY_WORD: {
                sb.append(" any word");
                break;
            }
            case PHRASE: {
                sb.append(" phrase");
                break;
            }
        }
        if (this.occ != null) {
            sb.append("occurs " + this.occ[0] + ' ' + "to" + ' ' + this.occ[1] + ' ' + "times");
        }
        return sb.toString();
    }
}

