/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public final class DynamicFunc
extends Arr {
    public DynamicFunc(InputInfo ii, Expr fun, Expr[] arg) {
        super(ii, Array.add(arg, fun));
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        int ar = this.expr.length - 1;
        Expr f = this.expr[ar];
        Type t = f.type().type;
        if (t instanceof FuncType) {
            FuncType ft = (FuncType)t;
            if (ft.args != null && ft.args.length != ar) {
                throw Err.INVARITY.thrw(this.info, f, ar);
            }
            if (ft.ret != null) {
                this.type = ft.ret;
            }
        }
        return this.allAreValues() && f instanceof Map ? this.optPre(this.value(ctx), ctx) : this;
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.getFun(ctx).invItem(ctx, ii, this.argv(ctx));
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.getFun(ctx).invValue(ctx, this.info, this.argv(ctx));
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        return this.getFun(ctx).invIter(ctx, this.info, this.argv(ctx));
    }

    private Value[] argv(QueryContext ctx) throws QueryException {
        Value[] argv = new Value[this.expr.length - 1];
        int i = argv.length;
        while (--i >= 0) {
            argv[i] = ctx.value(this.expr[i]);
        }
        return argv;
    }

    private FItem getFun(QueryContext ctx) throws QueryException {
        int ar = this.expr.length - 1;
        Item it = this.checkItem(this.expr[ar], ctx);
        if (!it.type.isFunction()) {
            throw Err.type(this, FuncType.arity(ar), it);
        }
        FItem fit = (FItem)it;
        if (fit.arity() != ar) {
            throw Err.INVARITY.thrw(this.info, fit, ar);
        }
        return fit;
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(new Object[0]);
        this.addPlan(plan, el, this.expr[this.expr.length - 1]);
        for (int i = 0; i < this.expr.length - 1; ++i) {
            this.expr[i].plan(el);
        }
    }

    @Override
    public String description() {
        return this.expr[this.expr.length - 1].description() + "(...)";
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder(this.expr[this.expr.length - 1].toString()).add(40);
        for (int i = 0; i < this.expr.length - 1; ++i) {
            tb.add(this.expr[i].toString());
            if (i >= this.expr.length - 2) continue;
            tb.add(", ");
        }
        return tb.add(41).toString();
    }
}

