/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNAcc
extends StandardFunc {
    public FNAcc(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx);
        switch (this.sig) {
            case POSITION: {
                return Int.get(ctx.pos);
            }
            case LAST: {
                return Int.get(ctx.size);
            }
            case STRING: {
                return this.string(e, ii, ctx);
            }
            case NUMBER: {
                return this.number(ctx.iter(e), ctx);
            }
            case STRING_LENGTH: {
                return Int.get(Token.len(this.checkEStr(this.expr.length == 0 ? this.string(e, ii, ctx) : e, ctx)));
            }
            case NORMALIZE_SPACE: {
                return Str.get(Token.norm(this.checkEStr(e, ctx)));
            }
            case NAMESPACE_URI_FROM_QNAME: {
                Item it = e.item(ctx, this.info);
                return it == null ? null : Uri.uri(((QNm)this.checkType(it, AtomType.QNM)).uri());
            }
        }
        return super.item(ctx, ii);
    }

    private Item string(Expr e, InputInfo ii, QueryContext ctx) throws QueryException {
        Item it = e.item(ctx, this.info);
        if (it == null) {
            return Str.ZERO;
        }
        Type t = it.type;
        if (t.isFunction()) {
            Err.FISTR.thrw(ii, this);
        }
        return t == AtomType.STR ? it : Str.get(it.string(ii));
    }

    private Item number(Iter ir, QueryContext ctx) throws QueryException {
        Item it = ir.next();
        if (it == null || ir.next() != null) {
            return Dbl.NAN;
        }
        Type t = it.type;
        if (t.isFunction()) {
            Err.FIATOM.thrw(this.info, this);
        }
        try {
            return t == AtomType.DBL ? it : AtomType.DBL.cast(it, ctx, this.info);
        }
        catch (QueryException ex) {
            return Dbl.NAN;
        }
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.POS && FNAcc.oneOf(this.sig, Function.POSITION, Function.LAST) || u == Expr.Use.CTX && this.expr.length == 0 || super.uses(u);
    }
}

