/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FNAggr
extends StandardFunc {
    public FNAggr(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter iter = ctx.iter(this.expr[0]);
        switch (this.sig) {
            case COUNT: {
                long c = iter.size();
                if (c == -1L) {
                    do {
                        ctx.checkStop();
                        ++c;
                    } while (iter.next() != null);
                }
                return Int.get(c);
            }
            case MIN: {
                return this.minmax(iter, CmpV.OpV.GT, ctx);
            }
            case MAX: {
                return this.minmax(iter, CmpV.OpV.LT, ctx);
            }
            case SUM: {
                Item it = iter.next();
                return it != null ? this.sum(iter, it, false) : (this.expr.length == 2 ? this.expr[1].item(ctx, this.info) : Int.get(0L));
            }
            case AVG: {
                Item it = iter.next();
                return it == null ? null : this.sum(iter, it, true);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        long c = e.size();
        if (c < 0L || e.uses(Expr.Use.NDT) || e.uses(Expr.Use.CNS)) {
            return this;
        }
        switch (this.sig) {
            case COUNT: {
                return Int.get(c);
            }
            case SUM: {
                return c == 0L ? (this.expr.length == 2 ? this.expr[1] : Int.get(0L)) : this;
            }
        }
        return this;
    }

    private Item sum(Iter iter, Item it, boolean avg) throws QueryException {
        Item i;
        Item res = it.type.isUntyped() ? Dbl.get(it.string(this.info), this.info) : it;
        Type t = res.type;
        if (!(t.isNumber() || t.isDuration() && t != AtomType.DUR)) {
            Err.SUMTYPE.thrw(this.info, this, t);
        }
        boolean n = t.isNumber();
        int c = 1;
        while ((i = iter.next()) != null) {
            boolean un;
            t = i.type;
            boolean bl = un = t.isUntyped() || t.isNumber();
            if (n && !un) {
                Err.FUNNUM.thrw(this.info, this, t);
            }
            if (!n && un) {
                Err.FUNDUR.thrw(this.info, this, t);
            }
            res = Calc.PLUS.ev(this.info, res, i);
            ++c;
        }
        return avg ? Calc.DIV.ev(this.info, res, Int.get(c)) : res;
    }

    private Item minmax(Iter iter, CmpV.OpV cmp, QueryContext ctx) throws QueryException {
        Item it;
        Type t;
        Item res;
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        if ((res = iter.next()) == null) {
            return null;
        }
        cmp.eval(this.info, res, res);
        if (!res.type.isUntyped() && res.type.isString() || res.type.isDate()) {
            Item it2;
            while ((it2 = iter.next()) != null) {
                if (it2.type != res.type) {
                    Err.FUNCMP.thrw(this.info, this.description(), res.type, it2.type);
                }
                if (!cmp.eval(this.info, res, it2)) continue;
                res = it2;
            }
            return res;
        }
        Type type = t = res.type.isUntyped() ? AtomType.DBL : res.type;
        if (res.type != t) {
            res = t.cast(res, ctx, this.info);
        }
        while ((it = iter.next()) != null) {
            t = this.type(res, it);
            if (!it.type.isDuration() && Double.isNaN(it.dbl(this.info)) || cmp.eval(this.info, res, it)) {
                res = it;
            }
            if (res.type == t) continue;
            res = t.cast(res, ctx, this.info);
        }
        return res;
    }

    private Type type(Item a, Item b) throws QueryException {
        Type ta = a.type;
        Type tb = b.type;
        if (tb.isUntyped()) {
            if (!ta.isNumber()) {
                Err.FUNCMP.thrw(this.info, this, ta, tb);
            }
            return AtomType.DBL;
        }
        if (ta.isNumber() && !tb.isUntyped() && tb.isString()) {
            Err.FUNCMP.thrw(this.info, this, ta, tb);
        }
        if (ta == tb) {
            return ta;
        }
        if (ta == AtomType.DBL || tb == AtomType.DBL) {
            return AtomType.DBL;
        }
        if (ta == AtomType.FLT || tb == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (ta == AtomType.DEC || tb == AtomType.DEC) {
            return AtomType.DEC;
        }
        if (ta == AtomType.BLN || ta.isNumber() && !tb.isNumber() || tb.isNumber() && !ta.isNumber()) {
            Err.FUNCMP.thrw(this.info, this, ta, tb);
        }
        return ta.isNumber() || tb.isNumber() ? AtomType.ITR : ta;
    }
}

