/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.core.BaseXException;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.type.AtomType;
import org.basex.server.ClientQuery;
import org.basex.server.ClientSession;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class FNClient
extends StandardFunc {
    static final Pattern QUERYPAT = Pattern.compile("\\[(.*?)\\] (.*)", 8);

    public FNClient(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _CLIENT_QUERY: {
                return this.query(ctx).iter(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _CLIENT_QUERY: {
                return this.query(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _CLIENT_CONNECT: {
                return this.connect(ctx);
            }
            case _CLIENT_EXECUTE: {
                return this.execute(ctx);
            }
            case _CLIENT_CLOSE: {
                return this.close(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Uri connect(QueryContext ctx) throws QueryException {
        String host = Token.string(this.checkStr(this.expr[0], ctx));
        String user = Token.string(this.checkStr(this.expr[2], ctx));
        String pass = Token.string(this.checkStr(this.expr[3], ctx));
        int port = (int)this.checkItr(this.expr[1], ctx);
        try {
            return ctx.sessions().add(new ClientSession(host, port, user, pass));
        }
        catch (IOException ex) {
            throw Err.BXCL_CONN.thrw(this.info, ex);
        }
    }

    private Str execute(QueryContext ctx) throws QueryException {
        ClientSession cs = this.session(ctx, false);
        String cmd = Token.string(this.checkStr(this.expr[1], ctx));
        try {
            cs.setOutputStream(new ArrayOutput());
            cs.execute(cmd);
            ArrayOutput ao = (ArrayOutput)cs.getOutputStream();
            byte[] result = ao.toArray();
            cs.setOutputStream(null);
            return Str.get(result);
        }
        catch (BaseXException ex) {
            throw Err.BXCL_COMMAND.thrw(this.info, ex);
        }
        catch (IOException ex) {
            throw Err.BXCL_COMM.thrw(this.info, ex);
        }
    }

    private Value query(QueryContext ctx) throws QueryException {
        ClientSession cs = this.session(ctx, false);
        String query = Token.string(this.checkStr(this.expr[1], ctx));
        try {
            ValueBuilder vb = new ValueBuilder();
            ClientQuery cq = cs.query(query);
            for (Map.Entry<String, Value> it : this.bindings(2, ctx).entrySet()) {
                String k = it.getKey();
                Value v = it.getValue();
                ArrayOutput val = v.serialize();
                if (!v.isItem()) {
                    Err.BXCL_ITEM.thrw(this.info, v);
                }
                String t = v.type().toString();
                if (k.isEmpty()) {
                    cq.context(val, t);
                    continue;
                }
                cq.bind(k, val, t);
            }
            while (cq.more()) {
                String result = cq.next();
                vb.add(cq.type().castString(result, this.info));
            }
            return vb.value();
        }
        catch (BaseXException ex) {
            Matcher m = QUERYPAT.matcher(ex.getMessage());
            if (m.find()) {
                throw new QueryException(this.info, new QNm(m.group(1)), m.group(2), new Object[0]);
            }
            throw Err.BXCL_QUERY.thrw(this.info, ex);
        }
        catch (IOException ex) {
            throw Err.BXCL_COMM.thrw(this.info, ex);
        }
    }

    private Item close(QueryContext ctx) throws QueryException {
        try {
            this.session(ctx, true).close();
            return null;
        }
        catch (IOException ex) {
            throw Err.BXCL_COMMAND.thrw(this.info, ex);
        }
    }

    private ClientSession session(QueryContext ctx, boolean del) throws QueryException {
        Uri id = (Uri)this.checkType(this.expr[0].item(ctx, this.info), AtomType.URI);
        ClientSession cs = ctx.sessions().get(id);
        if (cs == null) {
            Err.BXCL_NOTAVL.thrw(this.info, id);
        }
        if (del) {
            ctx.sessions().remove(id);
        }
        return cs;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.NDT || super.uses(u);
    }
}

