/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.DTd;
import org.basex.query.value.item.Dat;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Tim;
import org.basex.query.value.item.Uri;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNContext
extends StandardFunc {
    public FNContext(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case CURRENT_DATE: {
                return this.currDate(ctx);
            }
            case CURRENT_DATETIME: {
                return this.currDTM(ctx);
            }
            case CURRENT_TIME: {
                return this.currTIM(ctx);
            }
            case IMPLICIT_TIMEZONE: {
                return FNContext.implZone();
            }
            case DEFAULT_COLLATION: {
                return ctx.sc.baseURI().resolve(ctx.sc.collation);
            }
            case STATIC_BASE_URI: {
                Uri uri = ctx.sc.baseURI();
                return uri == Uri.EMPTY ? null : uri;
            }
        }
        return super.item(ctx, ii);
    }

    private Item currDate(QueryContext ctx) throws QueryException {
        if (ctx.date == null) {
            this.initDateTime(ctx);
        }
        return ctx.date;
    }

    private Item currDTM(QueryContext ctx) throws QueryException {
        if (ctx.dtm == null) {
            this.initDateTime(ctx);
        }
        return ctx.dtm;
    }

    private Item currTIM(QueryContext ctx) throws QueryException {
        if (ctx.time == null) {
            this.initDateTime(ctx);
        }
        return ctx.time;
    }

    private void initDateTime(QueryContext ctx) throws QueryException {
        Date d = Calendar.getInstance().getTime();
        String zon = new SimpleDateFormat("Z").format(d);
        String ymd = new SimpleDateFormat("yyyy-MM-dd").format(d);
        String hms = new SimpleDateFormat("HH:mm:ss.S").format(d);
        String zone = zon.substring(0, 3) + ':' + zon.substring(3);
        ctx.date = new Dat(Token.token(ymd + zone), this.info);
        ctx.time = new Tim(Token.token(hms + zone), this.info);
        ctx.dtm = new Dtm(Token.token(ymd + 'T' + hms + zone), this.info);
    }

    private static Item implZone() {
        Date d = Calendar.getInstance().getTime();
        String zone = new SimpleDateFormat("Z").format(d);
        byte[] z = Token.token(zone);
        int cshift = Token.toInt(Token.substring(z, 0, 3)) * 60 + Token.toInt(Token.substring(z, 3));
        return new DTd(cshift);
    }
}

