/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.util.Date;
import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.core.cmd.Info;
import org.basex.core.cmd.InfoDB;
import org.basex.core.cmd.Rename;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.data.MetaData;
import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.index.resource.Resources;
import org.basex.io.IOFile;
import org.basex.io.MimeTypes;
import org.basex.io.in.DataInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.IndexAccess;
import org.basex.query.expr.StringRangeAccess;
import org.basex.query.expr.ValueAccess;
import org.basex.query.func.FNFt;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeIter;
import org.basex.query.path.NameTest;
import org.basex.query.path.Test;
import org.basex.query.up.primitives.DBAdd;
import org.basex.query.up.primitives.DBDelete;
import org.basex.query.up.primitives.DBFlush;
import org.basex.query.up.primitives.DBOptimize;
import org.basex.query.up.primitives.DBRename;
import org.basex.query.up.primitives.DBStore;
import org.basex.query.up.primitives.DeleteNode;
import org.basex.query.up.primitives.ReplaceValue;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.B64Stream;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dtm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class FNDb
extends StandardFunc {
    static final QNm Q_SYSTEM = new QNm("system");
    static final QNm Q_DATABASE = new QNm("database");
    static final QNm Q_RESOURCE = new QNm("resource");
    static final QNm Q_RESOURCES = new QNm("resources");
    static final QNm Q_PATH = new QNm("path");
    static final QNm Q_RAW = new QNm("raw");
    static final QNm Q_SIZE = new QNm("size");
    static final QNm Q_CTYPE = new QNm("content-type");
    static final QNm Q_MDATE = new QNm("modified-date");

    public FNDb(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _DB_OPEN: {
                return this.open(ctx).iter();
            }
            case _DB_TEXT: {
                return this.valueAccess(true, ctx).iter(ctx);
            }
            case _DB_TEXT_RANGE: {
                return this.rangeAccess(true, ctx).iter(ctx);
            }
            case _DB_ATTRIBUTE: {
                return this.attribute(this.valueAccess(false, ctx), ctx, 2);
            }
            case _DB_ATTRIBUTE_RANGE: {
                return this.attribute(this.rangeAccess(false, ctx), ctx, 3);
            }
            case _DB_FULLTEXT: {
                return this.fulltext(ctx);
            }
            case _DB_LIST: {
                return this.list(ctx);
            }
            case _DB_LIST_DETAILS: {
                return this.listDetails(ctx);
            }
            case _DB_NODE_ID: {
                return this.node(ctx, true);
            }
            case _DB_NODE_PRE: {
                return this.node(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _DB_OPEN: {
                return this.open(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _DB_EVENT: {
                return this.event(ctx);
            }
            case _DB_OUTPUT: {
                return this.output(ctx);
            }
            case _DB_OPEN_ID: {
                return this.open(ctx, true);
            }
            case _DB_OPEN_PRE: {
                return this.open(ctx, false);
            }
            case _DB_SYSTEM: {
                return FNDb.system(ctx);
            }
            case _DB_INFO: {
                return this.info(ctx);
            }
            case _DB_ADD: {
                return this.add(ctx);
            }
            case _DB_DELETE: {
                return this.delete(ctx);
            }
            case _DB_RENAME: {
                return this.rename(ctx);
            }
            case _DB_REPLACE: {
                return this.replace(ctx);
            }
            case _DB_OPTIMIZE: {
                return this.optimize(ctx);
            }
            case _DB_STORE: {
                return this.store(ctx);
            }
            case _DB_RETRIEVE: {
                return this.retrieve(ctx);
            }
            case _DB_FLUSH: {
                return this.flush(ctx);
            }
            case _DB_IS_RAW: {
                return this.isRaw(ctx);
            }
            case _DB_EXISTS: {
                return this.exists(ctx);
            }
            case _DB_IS_XML: {
                return this.isXML(ctx);
            }
            case _DB_CONTENT_TYPE: {
                return this.contentType(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Value open(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.expr.length < 2 ? "" : this.path(1, ctx);
        return DBNodeSeq.get(data.resources.docs(path), data, true, path.isEmpty());
    }

    private DBNode open(QueryContext ctx, boolean id) throws QueryException {
        int pre;
        Data data = this.data(0, ctx);
        int v = (int)this.checkItr(this.expr[1], ctx);
        int n = pre = id ? data.pre(v) : v;
        if (pre < 0 || pre >= data.meta.size) {
            Err.BXDB_RANGE.thrw(this.info, this, v);
        }
        return new DBNode(data, pre);
    }

    private ValueAccess valueAccess(boolean text, QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        IndexType it = text ? IndexType.TEXT : IndexType.ATTRIBUTE;
        return new ValueAccess(this.info, this.expr[1], it, ic);
    }

    private StringRangeAccess rangeAccess(boolean text, QueryContext ctx) throws QueryException {
        IndexContext ic = new IndexContext(ctx, this.data(0, ctx), null, true);
        byte[] min = this.checkStr(this.expr[1], ctx);
        byte[] max = this.checkStr(this.expr[2], ctx);
        IndexType it = text ? IndexType.TEXT : IndexType.ATTRIBUTE;
        StringRange sr = new StringRange(it, min, true, max, true);
        return new StringRangeAccess(this.info, sr, ic);
    }

    private Iter attribute(final IndexAccess ia, final QueryContext ctx, int a) throws QueryException {
        NameTest nt;
        if (this.expr.length <= a) {
            return ia.iter(ctx);
        }
        Item name = this.checkNoEmpty(this.expr[a].item(ctx, this.info));
        QNm nm = new QNm(this.checkStr(name, ctx), ctx);
        if (!nm.hasPrefix()) {
            nm.uri(ctx.sc.ns.uri(Token.EMPTY));
        }
        if (!(nt = new NameTest(nm, Test.Mode.STD, true)).compile(ctx)) {
            return Empty.ITER;
        }
        return new NodeIter(){
            final NodeIter ir;
            {
                this.ir = ia.iter(ctx);
            }

            @Override
            public ANode next() throws QueryException {
                ANode n;
                while ((n = this.ir.next()) != null && !nt.eq(n)) {
                }
                return n;
            }
        };
    }

    private Iter fulltext(QueryContext ctx) throws QueryException {
        return FNFt.search(this.data(0, ctx), ctx.value(this.expr[1]), null, this, ctx);
    }

    private Iter list(QueryContext ctx) throws QueryException {
        final TokenList tl = new TokenList();
        int el = this.expr.length;
        if (el == 0) {
            for (String s : ctx.context.databases().listDBs()) {
                tl.add(s);
            }
        } else {
            Data data = this.data(0, ctx);
            String path = Token.string(el == 1 ? Token.EMPTY : this.checkStr(this.expr[1], ctx));
            Resources res = data.resources;
            IntList il = res.docs(path);
            int is = il.size();
            for (int i = 0; i < is; ++i) {
                tl.add(data.text(il.get(i), true));
            }
            for (byte[] file : res.binaries(path)) {
                tl.add(file);
            }
        }
        tl.sort(!Prop.WIN);
        return new Iter(){
            int pos;

            @Override
            public Str get(long i) {
                return Str.get(tl.get((int)i));
            }

            @Override
            public Str next() {
                return (long)this.pos < this.size() ? this.get(this.pos++) : null;
            }

            @Override
            public boolean reset() {
                this.pos = 0;
                return true;
            }

            @Override
            public long size() {
                return tl.size();
            }
        };
    }

    private Iter listDetails(QueryContext ctx) throws QueryException {
        if (this.expr.length == 0) {
            return this.listDBs(ctx);
        }
        final Data data = this.data(0, ctx);
        String path = Token.string(this.expr.length == 1 ? Token.EMPTY : this.checkStr(this.expr[1], ctx));
        final IntList il = data.resources.docs(path);
        final TokenList tl = data.resources.binaries(path);
        return new Iter(){
            final int is;
            final int ts;
            int ip;
            int tp;
            {
                this.is = il.size();
                this.ts = tl.size();
            }

            @Override
            public ANode get(long i) throws QueryException {
                if (i < (long)this.is) {
                    byte[] pt = data.text(il.get((int)i), true);
                    return FNDb.resource(pt, false, 0L, Token.token("application/xml"), data.meta.time);
                }
                if (i < (long)(this.is + this.ts)) {
                    byte[] pt = tl.get((int)i - this.is);
                    IOFile io = data.meta.binary(Token.string(pt));
                    return FNDb.resource(pt, true, io.length(), Token.token(MimeTypes.get(io.path())), io.timeStamp());
                }
                return null;
            }

            @Override
            public ANode next() throws QueryException {
                return this.ip < this.is ? this.get(this.ip++) : (this.tp < this.ts ? this.get(this.ip + this.tp++) : null);
            }

            @Override
            public boolean reset() {
                this.ip = 0;
                this.tp = 0;
                return true;
            }

            @Override
            public long size() {
                return this.ip + this.is;
            }
        };
    }

    private Iter listDBs(final QueryContext ctx) {
        final StringList sl = ctx.context.databases().listDBs();
        return new Iter(){
            int pos;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ANode get(long i) throws QueryException {
                FElem res = new FElem(Q_DATABASE);
                String name = sl.get((int)i);
                MetaData meta = new MetaData(name, ctx.context);
                DataInput di = null;
                try {
                    di = new DataInput(meta.dbfile("inf"));
                    meta.read(di);
                    res.add(Q_RESOURCES, Token.token(meta.ndocs));
                    String tstamp = Util.formatDate(new Date(meta.dbtime()), Dtm.FORMAT);
                    res.add(Q_MDATE, Token.token(tstamp));
                    if (ctx.context.perm(Perm.CREATE, meta)) {
                        res.add(Q_PATH, Token.token(meta.original));
                    }
                    res.add(Token.token(name));
                }
                catch (IOException ex) {
                    Err.BXDB_OPEN.thrw(FNDb.this.info, ex);
                }
                finally {
                    if (di != null) {
                        try {
                            di.close();
                        }
                        catch (IOException ex) {}
                    }
                }
                return res;
            }

            @Override
            public ANode next() throws QueryException {
                return (long)this.pos < this.size() ? this.get(this.pos++) : null;
            }

            @Override
            public boolean reset() {
                this.pos = 0;
                return true;
            }

            @Override
            public long size() {
                return sl.size();
            }
        };
    }

    private Bln isRaw(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            return Bln.FALSE;
        }
        IOFile io = data.meta.binary(path);
        return Bln.get(io.exists() && !io.isDir());
    }

    private Bln exists(QueryContext ctx) throws QueryException {
        try {
            Data data = this.data(0, ctx);
            if (this.expr.length == 1) {
                return Bln.TRUE;
            }
            String path = this.path(1, ctx);
            boolean raw = false;
            if (!data.inMemory()) {
                IOFile io = data.meta.binary(path);
                raw = io.exists() && !io.isDir();
            }
            return Bln.get(raw || data.resources.doc(path) != -1);
        }
        catch (QueryException ex) {
            if (ex.err() == Err.BXDB_OPEN) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    private Bln isXML(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        return Bln.get(data.resources.doc(path) != -1);
    }

    private Str contentType(QueryContext ctx) throws QueryException {
        IOFile io;
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        if (data.resources.doc(path) != -1) {
            return Str.get("application/xml");
        }
        if (!data.inMemory() && (io = data.meta.binary(path)).exists() && !io.isDir()) {
            return Str.get(MimeTypes.get(path));
        }
        throw Err.WHICHRES.thrw(this.info, path);
    }

    static FNode resource(byte[] path, boolean raw, long size, byte[] ctype, long mdate) {
        String tstamp = Util.formatDate(new Date(mdate), Dtm.FORMAT);
        FElem res = new FElem(Q_RESOURCE).add(path).add(Q_RAW, Token.token(raw)).add(Q_CTYPE, ctype).add(Q_MDATE, Token.token(tstamp));
        return raw ? res.add(Q_SIZE, Token.token(size)) : res;
    }

    private static ANode system(QueryContext ctx) {
        return FNDb.toNode(Info.info(ctx.context), Q_SYSTEM);
    }

    private ANode info(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        boolean create = ctx.context.user.has(Perm.CREATE);
        return FNDb.toNode(InfoDB.db(data.meta, false, true, create), Q_DATABASE);
    }

    private static ANode toNode(String str, QNm root) {
        FElem top = new FElem(root);
        FElem node = null;
        for (String l : str.split("\r\n?|\n")) {
            String[] cols = l.split(": ", 2);
            if (cols[0].isEmpty()) continue;
            String name = cols[0].replaceAll(" |-", "");
            FElem n = new FElem(new QNm(Token.lc(Token.token(name))));
            if (cols[0].startsWith(" ")) {
                if (node != null) {
                    node.add(n);
                }
                if (cols[1].isEmpty()) continue;
                n.add(Token.token(cols[1]));
                continue;
            }
            node = n;
            top.add(n);
        }
        return top;
    }

    private Item add(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        Item it = this.checkItem(this.expr[1], ctx);
        String path = this.expr.length < 3 ? "" : this.path(2, ctx);
        ctx.updates.add(new DBAdd(data, this.info, it, path, ctx.context), ctx);
        return null;
    }

    private Item replace(QueryContext ctx) throws QueryException {
        IOFile bin;
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        Item doc = this.checkItem(this.expr[2], ctx);
        Resources res = data.resources;
        int pre = res.doc(path);
        if (pre != -1) {
            if (res.docs(path).size() != 1) {
                Err.BXDB_SINGLE.thrw(this.info, new Object[0]);
            }
            ctx.updates.add(new DeleteNode(pre, data, this.info), ctx);
        }
        IOFile iOFile = bin = data.inMemory() ? null : data.meta.binary(path);
        if (bin != null) {
            if (bin.exists()) {
                if (bin.isDir()) {
                    Err.BXDB_SINGLE.thrw(this.info, new Object[0]);
                }
                ctx.updates.add(new DBStore(data, path, doc, this.info), ctx);
            } else {
                ctx.updates.add(new DBAdd(data, this.info, doc, path, ctx.context), ctx);
            }
        }
        return null;
    }

    private Item delete(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        IntList docs = data.resources.docs(path);
        int is = docs.size();
        for (int i = 0; i < is; ++i) {
            ctx.updates.add(new DeleteNode(docs.get(i), data, this.info), ctx);
        }
        if (!data.inMemory()) {
            IOFile bin = data.meta.binary(path);
            if (bin == null) {
                Err.UPDBDELERR.thrw(this.info, path);
            }
            ctx.updates.add(new DBDelete(data, path, this.info), ctx);
        }
        return null;
    }

    private Item rename(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String source = this.path(1, ctx);
        String target = this.path(2, ctx);
        IntList il = data.resources.docs(source);
        int is = il.size();
        for (int i = 0; i < is; ++i) {
            int pre = il.get(i);
            String trg = Rename.target(data, pre, source, target);
            if (trg.isEmpty()) {
                Err.BXDB_EMPTY.thrw(this.info, this);
            }
            ctx.updates.add(new ReplaceValue(pre, data, this.info, Token.token(trg)), ctx);
        }
        if (!data.inMemory()) {
            IOFile src = data.meta.binary(source);
            IOFile trg = data.meta.binary(target);
            if (src == null || trg == null) {
                Err.UPDBRENAMEERR.thrw(this.info, src);
            }
            ctx.updates.add(new DBRename(data, src.path(), trg.path(), this.info), ctx);
        }
        return null;
    }

    private Item optimize(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        boolean all = this.expr.length == 2 && this.checkBln(this.expr[1], ctx);
        ctx.updates.add(new DBOptimize(data, ctx.context, all, this.info), ctx);
        return null;
    }

    private Item store(QueryContext ctx) throws QueryException {
        IOFile file;
        this.checkWrite(ctx);
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            Err.BXDB_MEM.thrw(this.info, data.meta.name);
        }
        if ((file = data.meta.binary(path)) == null || file.isDir()) {
            Err.RESINV.thrw(this.info, path);
        }
        Item it = this.checkItem(this.expr[2], ctx);
        ctx.updates.add(new DBStore(data, path, it, this.info), ctx);
        return null;
    }

    private Item flush(QueryContext ctx) throws QueryException {
        this.checkWrite(ctx);
        ctx.updates.add(new DBFlush(this.data(0, ctx), this.info), ctx);
        return null;
    }

    private B64Stream retrieve(QueryContext ctx) throws QueryException {
        IOFile file;
        Data data = this.data(0, ctx);
        String path = this.path(1, ctx);
        if (data.inMemory()) {
            Err.BXDB_MEM.thrw(this.info, data.meta.name);
        }
        if ((file = data.meta.binary(path)) == null || !file.exists() || file.isDir()) {
            Err.WHICHRES.thrw(this.info, path);
        }
        return new B64Stream(file, Err.IOERR);
    }

    private Iter node(final QueryContext ctx, final boolean id) throws QueryException {
        return new Iter(){
            final Iter ir;
            {
                this.ir = ctx.iter(FNDb.this.expr[0]);
            }

            @Override
            public Int next() throws QueryException {
                Item it = this.ir.next();
                if (it == null) {
                    return null;
                }
                DBNode node = FNDb.this.checkDBNode(it);
                return Int.get(id ? (long)node.data.id(node.pre) : (long)node.pre);
            }
        };
    }

    private Item event(QueryContext ctx) throws QueryException {
        ArrayOutput ao;
        byte[] name = this.checkStr(this.expr[0], ctx);
        try {
            ao = ctx.value(this.expr[1]).serialize();
        }
        catch (SerializerException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            throw Err.SERANY.thrw(this.info, ex);
        }
        if (!ctx.context.events.notify(ctx.context, name, ao.toArray())) {
            Err.BXDB_EVENT.thrw(this.info, new Object[]{name});
        }
        return null;
    }

    private Item output(QueryContext ctx) throws QueryException {
        Item it;
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            if (it.type.isNode()) {
                MemData md = new MemData(ctx.context.prop);
                new DataBuilder(md).build((ANode)it);
                it = new DBNode(md);
            } else if (it.type.isFunction()) {
                Err.FIVALUE.thrw(this.info, it);
            }
            ctx.output.add(it);
        }
        return null;
    }

    @Override
    public boolean uses(Expr.Use u) {
        boolean up = FNDb.oneOf(this.sig, Function._DB_ADD, Function._DB_DELETE, Function._DB_RENAME, Function._DB_REPLACE, Function._DB_OPTIMIZE, Function._DB_STORE, Function._DB_OUTPUT, Function._DB_FLUSH);
        return u == Expr.Use.NDT && (up || FNDb.oneOf(this.sig, Function._DB_TEXT, Function._DB_ATTRIBUTE, Function._DB_TEXT_RANGE, Function._DB_ATTRIBUTE_RANGE, Function._DB_FULLTEXT, Function._DB_EVENT)) || u == Expr.Use.UPD && up || super.uses(u);
    }

    @Override
    public boolean databases(StringList db) {
        if (!FNDb.oneOf(Function._DB_SYSTEM, Function._DB_NODE_ID, Function._DB_NODE_PRE, Function._DB_EVENT, Function._DB_OUTPUT)) {
            if (this.expr.length == 0 || !(this.expr[0] instanceof Str)) {
                return false;
            }
            db.add(Token.string(((Str)this.expr[0]).string()));
            return true;
        }
        return super.databases(db);
    }

    @Override
    public boolean iterable() {
        return FNDb.oneOf(this.sig, Function._DB_OPEN, Function._DB_TEXT, Function._DB_ATTRIBUTE, Function._DB_FULLTEXT) || super.iterable();
    }

    private String path(int i, QueryContext ctx) throws QueryException {
        String path = Token.string(this.checkStr(this.expr[i], ctx));
        String norm = MetaData.normPath(path);
        if (norm == null) {
            Err.RESINV.thrw(this.info, path);
        }
        return norm;
    }
}

