/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.util.format.DecFormatter;
import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNFormat
extends StandardFunc {
    public FNFormat(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case FORMAT_INTEGER: {
                return this.formatInteger(ctx);
            }
            case FORMAT_NUMBER: {
                return this.formatNumber(ctx);
            }
            case FORMAT_DATETIME: {
                return this.formatDate(AtomType.DTM, ctx);
            }
            case FORMAT_DATE: {
                return this.formatDate(AtomType.DAT, ctx);
            }
            case FORMAT_TIME: {
                return this.formatDate(AtomType.TIM, ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || super.uses(u);
    }

    private Str formatInteger(QueryContext ctx) throws QueryException {
        byte[] lng;
        byte[] pic = this.checkStr(this.expr[1], ctx);
        byte[] byArray = lng = this.expr.length == 2 ? Token.EMPTY : this.checkStr(this.expr[2], ctx);
        if (this.expr[0].isEmpty()) {
            return Str.ZERO;
        }
        long num = this.checkItr(this.expr[0], ctx);
        if (pic.length == 0) {
            Err.WRONGINT.thrw(this.info, new Object[]{pic});
        }
        FormatParser fp = new FormatParser(pic, null, this.info);
        return Str.get(Formatter.get(Token.string(lng)).formatInt(num, fp));
    }

    private Str formatNumber(QueryContext ctx) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            it = Dbl.NAN;
        } else if (!it.type.isUntyped() && !it.type.isNumber()) {
            Err.number(this, it);
        }
        String pic = Token.string(this.checkStr(this.expr[1], ctx));
        QNm frm = new QNm(this.expr.length == 3 ? this.checkStr(this.expr[2], ctx) : Token.EMPTY, ctx);
        DecFormatter df = ctx.sc.decFormats.get(frm.eqname());
        if (df == null) {
            throw Err.FORMNUM.thrw(this.info, frm);
        }
        return Str.get(df.format(this.info, it, pic));
    }

    private Item formatDate(Type tp, QueryContext ctx) throws QueryException {
        byte[] plc;
        Item it = this.expr[0].item(ctx, this.info);
        byte[] pic = this.checkEStr(this.expr[1], ctx);
        byte[] lng = this.expr.length == 5 ? this.checkEStr(this.expr[2], ctx) : Token.EMPTY;
        byte[] cal = this.expr.length == 5 ? this.checkEStr(this.expr[3], ctx) : Token.EMPTY;
        byte[] byArray = plc = this.expr.length == 5 ? this.checkEStr(this.expr[4], ctx) : Token.EMPTY;
        if (it == null) {
            return null;
        }
        ADate date = (ADate)this.checkType(it, tp);
        Formatter form = Formatter.get(Token.string(lng));
        return Str.get(form.formatDate(date, pic, cal, plc, this.info));
    }
}

