/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Locale;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.MemData;
import org.basex.index.IndexType;
import org.basex.index.query.IndexEntries;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTIndexAccess;
import org.basex.query.ft.FTMode;
import org.basex.query.ft.FTWords;
import org.basex.query.func.FNIndex;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.Err;
import org.basex.query.util.IndexContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class FNFt
extends StandardFunc {
    private static final QNm Q_FTOPTIONS = new QNm("options");
    private static final byte[] MARK = Token.token("mark");
    private static final byte[] FUZZY = Token.token("fuzzy");
    private static final byte[] WILDCARDS = Token.token("wildcards");
    private static final byte[] MODE = Token.token("mode");

    public FNFt(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _FT_COUNT: {
                return this.count(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _FT_SEARCH: {
                return this.search(ctx);
            }
            case _FT_SCORE: {
                return this.score(ctx);
            }
            case _FT_MARK: {
                return this.mark(ctx, false);
            }
            case _FT_EXTRACT: {
                return this.mark(ctx, true);
            }
            case _FT_TOKENS: {
                return this.tokens(ctx);
            }
            case _FT_TOKENIZE: {
                return this.tokenize(ctx);
            }
        }
        return super.iter(ctx);
    }

    private Item count(QueryContext ctx) throws QueryException {
        Item it;
        FTPosData tmp = ctx.ftpos;
        ctx.ftpos = new FTPosData();
        Iter ir = ctx.iter(this.expr[0]);
        while ((it = ir.next()) != null) {
            this.checkDBNode(it);
        }
        int s = ctx.ftpos.size();
        ctx.ftpos = tmp;
        return Int.get(s);
    }

    private Iter mark(final QueryContext ctx, boolean ex) throws QueryException {
        int l;
        byte[] m = MARK;
        int n = l = ex ? 150 : Integer.MAX_VALUE;
        if (this.expr.length > 1 && !XMLToken.isQName(m = this.checkStr(this.expr[1], ctx))) {
            Err.value(this.info, AtomType.QNM, m);
        }
        if (this.expr.length > 2) {
            l = (int)this.checkItr(this.expr[2], ctx);
        }
        final byte[] mark = m;
        final int len = l;
        return new Iter(){
            final FTPosData ftd = new FTPosData();
            ValueIter vi;
            Iter ir;

            @Override
            public Item next() throws QueryException {
                Item it;
                do {
                    if (this.vi != null) {
                        Item it2 = this.vi.next();
                        if (it2 != null) {
                            return it2;
                        }
                        this.vi = null;
                    }
                    FTPosData tmp = ctx.ftpos;
                    ctx.ftpos = this.ftd;
                    if (this.ir == null) {
                        this.ir = ctx.iter(FNFt.this.expr[0]);
                    }
                    if ((it = this.ir.next()) != null) {
                        MemData md = new MemData(ctx.context.prop);
                        DataBuilder db = new DataBuilder(md);
                        db.ftpos(mark, ctx.ftpos, len).build(FNFt.this.checkDBNode(it));
                        IntList il = new IntList();
                        for (int p = 0; p < md.meta.size; p += md.size(p, md.kind(p))) {
                            il.add(p);
                        }
                        this.vi = DBNodeSeq.get(il, md, false, false).iter();
                    }
                    ctx.ftpos = tmp;
                } while (it != null);
                return null;
            }
        };
    }

    private Iter score(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final Iter iter;
            {
                this.iter = FNFt.this.expr[0].iter(ctx);
            }

            @Override
            public Dbl next() throws QueryException {
                Item item = this.iter.next();
                return item == null ? null : Dbl.get(item.score());
            }
        };
    }

    private Iter search(QueryContext ctx) throws QueryException {
        Data data = this.data(0, ctx);
        Value terms = ctx.value(this.expr[1]);
        Item opt = this.expr.length > 2 ? this.expr[2].item(ctx, this.info) : null;
        TokenMap tm = new FuncParams(Q_FTOPTIONS, this.info).parse(opt);
        return FNFt.search(data, terms, tm, this, ctx);
    }

    static Iter search(Data data, Value terms, TokenMap map, StandardFunc fun, QueryContext ctx) throws QueryException {
        InputInfo info = fun.info;
        IndexContext ic = new IndexContext(ctx, data, null, true);
        if (!data.meta.ftxtindex) {
            Err.BXDB_INDEX.thrw(info, data.meta.name, IndexType.FULLTEXT.toString().toLowerCase(Locale.ENGLISH));
        }
        FTOpt tmp = ctx.ftOpt();
        FTOpt opt = new FTOpt().copy(data.meta);
        FTMode m = FTMode.ANY;
        if (map != null) {
            for (byte[] k : map) {
                boolean t;
                byte[] v = map.get(k);
                if (Token.eq(k, FUZZY)) {
                    t = v.length == 0 || Util.yes(Token.string(v));
                    opt.set(FTFlag.FZ, t);
                    continue;
                }
                if (Token.eq(k, WILDCARDS)) {
                    t = v.length == 0 || Util.yes(Token.string(v));
                    opt.set(FTFlag.WC, t);
                    continue;
                }
                if (Token.eq(k, MODE)) {
                    m = FTMode.get(v);
                    if (m != null) continue;
                    Err.ELMOPTION.thrw(info, new Object[]{v});
                    continue;
                }
                Err.ELMOPTION.thrw(info, new Object[]{k});
            }
        }
        ctx.ftOpt(opt);
        FTWords words = new FTWords(info, ic.data, terms, m, ctx).compile(ctx);
        ctx.ftOpt(tmp);
        return new FTIndexAccess(info, words, ic).iter(ctx);
    }

    private Iter tokens(QueryContext ctx) throws QueryException {
        byte[] entry;
        Data data = this.data(0, ctx);
        byte[] byArray = entry = this.expr.length < 2 ? Token.EMPTY : this.checkStr(this.expr[1], ctx);
        if (entry.length != 0) {
            FTLexer ftl = new FTLexer(new FTOpt().copy(data.meta));
            ftl.init(entry);
            entry = ftl.nextToken();
        }
        return FNIndex.entries(data, new IndexEntries(entry, IndexType.FULLTEXT), this);
    }

    private Iter tokenize(QueryContext ctx) throws QueryException {
        FTOpt opt = new FTOpt().copy(ctx.ftOpt());
        final FTLexer ftl = new FTLexer(opt).init(this.checkStr(this.expr[0], ctx));
        return new Iter(){

            @Override
            public Str next() {
                return ftl.hasNext() ? Str.get(ftl.nextToken()) : null;
            }
        };
    }

    @Override
    public boolean iterable() {
        return this.sig == Function._FT_SEARCH || super.iterable();
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && FNFt.oneOf(this.sig, Function._FT_SEARCH, Function._FT_TOKENS) || super.uses(u);
    }

    @Override
    public boolean databases(StringList db) {
        if (this.sig == Function._FT_SEARCH) {
            if (!(this.expr[0] instanceof Str)) {
                return false;
            }
            db.add(Token.string(((Str)this.expr[0]).string()));
            return true;
        }
        return super.databases(db);
    }
}

