/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.QueryInput;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.EncodingException;
import org.basex.io.serial.InputException;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerException;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncParams;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.up.primitives.Put;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class FNGen
extends StandardFunc {
    public FNGen(InputInfo ii, Function f, Expr[] e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case DATA: {
                return this.data(ctx);
            }
            case COLLECTION: {
                return this.collection(ctx).iter();
            }
            case URI_COLLECTION: {
                return this.uriCollection(ctx);
            }
            case UNPARSED_TEXT_LINES: {
                return this.unparsedTextLines(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case DOC: {
                return this.doc(ctx);
            }
            case DOC_AVAILABLE: {
                return this.docAvailable(ctx);
            }
            case UNPARSED_TEXT: {
                return this.unparsedText(ctx, false);
            }
            case UNPARSED_TEXT_AVAILABLE: {
                return this.unparsedText(ctx, true);
            }
            case PUT: {
                return this.put(ctx);
            }
            case PARSE_XML: {
                return this.parseXml(ctx);
            }
            case SERIALIZE: {
                return this.serialize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case COLLECTION: {
                return this.collection(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        if (this.sig == Function.DATA && this.expr.length == 1) {
            SeqType t = this.expr[0].type();
            this.type = t.type.isNode() ? SeqType.get((Type)AtomType.ATM, t.occ) : t;
        }
        return this;
    }

    private Iter data(QueryContext ctx) throws QueryException {
        final Iter ir = ctx.iter(this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx));
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = ir.next();
                if (it == null) {
                    return null;
                }
                if (it.type.isFunction()) {
                    Err.FIATOM.thrw(FNGen.this.info, FNGen.this);
                }
                return StandardFunc.atom(it, FNGen.this.info);
            }
        };
    }

    private Value collection(QueryContext ctx) throws QueryException {
        if (this.expr.length == 0) {
            return ctx.resource.collection(this.info);
        }
        byte[] in = this.checkEStr(this.expr[0].item(ctx, this.info));
        if (!Uri.uri(in).isValid()) {
            Err.INVCOLL.thrw(this.info, new Object[]{in});
        }
        return ctx.resource.collection(Token.string(in), this.info);
    }

    private Iter uriCollection(QueryContext ctx) throws QueryException {
        final ValueIter coll = this.collection(ctx).iter();
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = coll.next();
                return it == null ? null : Uri.uri(((ANode)it).baseURI(), false);
            }
        };
    }

    private Item put(QueryContext ctx) throws QueryException {
        Uri u;
        this.checkCreate(ctx);
        byte[] file = this.checkEStr(this.expr[1], ctx);
        ANode nd = this.checkNode(this.checkNoEmpty(this.expr[0].item(ctx, this.info)));
        if (nd == null || nd.type != NodeType.DOC && nd.type != NodeType.ELM) {
            Err.UPFOTYPE.thrw(this.info, this.expr[0]);
        }
        if ((u = Uri.uri(file)) == Uri.EMPTY || !u.isValid()) {
            Err.UPFOURI.thrw(this.info, new Object[]{file});
        }
        DBNode target = ctx.updates.determineDataRef(nd, ctx);
        String uri = new IOFile(u.toJava()).path();
        if (ctx.updates.putPaths.add(Token.token(uri)) < 0) {
            Err.UPURIDUP.thrw(this.info, uri);
        }
        ctx.updates.add(new Put(this.info, target.pre, target.data, uri), ctx);
        return null;
    }

    private ANode doc(QueryContext ctx) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        if (it == null) {
            return null;
        }
        byte[] in = this.checkEStr(it);
        if (!Uri.uri(in).isValid()) {
            Err.INVDOC.thrw(this.info, new Object[]{in});
        }
        return ctx.resource.doc(new QueryInput(Token.string(in)), this.info);
    }

    private Bln docAvailable(QueryContext ctx) throws QueryException {
        try {
            return Bln.get(this.doc(ctx) != null);
        }
        catch (QueryException ex) {
            Err err = ex.err();
            if (err != null && err.type == Err.ErrType.FODC && (err.num == 2 || err.num == 4)) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Item unparsedText(QueryContext ctx, boolean check) throws QueryException {
        this.checkCreate(ctx);
        byte[] path = this.checkStr(this.expr[0], ctx);
        String enc = this.encoding(1, Err.WHICHENC, ctx);
        IO base = ctx.sc.baseIO();
        if (base == null) {
            throw Err.STBASEURI.thrw(this.info, new Object[0]);
        }
        try {
            IO io;
            String rp;
            String p = Token.string(path);
            if (p.indexOf(35) != -1) {
                Err.FRAGID.thrw(this.info, p);
            }
            if (!Uri.uri(Token.token(p)).isValid()) {
                Err.INVURL.thrw(this.info, p);
            }
            if ((rp = ctx.resource.resources.get((io = base.merge(p)).path())) != null) {
                io = IO.get(rp);
            }
            if (!io.exists()) {
                throw Err.RESNF.thrw(this.info, p);
            }
            InputStream is = io.inputStream();
            try {
                TextInput ti = new TextInput(io).valid(true);
                if (enc != null) {
                    ti.encoding(enc);
                }
                if (!check) {
                    Str str = Str.get(ti.content());
                    return str;
                }
                while (ti.read() != -1) {
                }
                Bln bln = Bln.TRUE;
                return bln;
            }
            finally {
                is.close();
            }
        }
        catch (QueryException ex) {
            if (!check) throw ex;
            return Bln.FALSE;
        }
        catch (IOException ex) {
            if (check) {
                return Bln.FALSE;
            }
            if (ex instanceof EncodingException) {
                Err.INVCHARS.thrw(this.info, ex);
            }
            if (ex instanceof InputException && enc == null) {
                Err.WHICHCHARS.thrw(this.info, new Object[0]);
            }
            throw Err.SERANY.thrw(this.info, ex);
        }
    }

    Iter unparsedTextLines(QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.unparsedText(ctx, false).string(this.info));
    }

    static Iter textIter(byte[] str) {
        try {
            final NewlineInput nli = new NewlineInput(new ArrayInput(str));
            final TokenBuilder tb = new TokenBuilder();
            return new Iter(){

                @Override
                public Item next() {
                    try {
                        return nli.readLine(tb) == null ? null : Str.get(tb.finish());
                    }
                    catch (IOException ex) {
                        throw Util.notexpected(ex);
                    }
                }
            };
        }
        catch (IOException ex) {
            throw Util.notexpected(ex);
        }
    }

    private ANode parseXml(QueryContext ctx) throws QueryException {
        byte[] cont = this.checkEStr(this.expr[0], ctx);
        Uri base = ctx.sc.baseURI();
        if (this.expr.length == 2 && !(base = Uri.uri(this.checkEStr(this.expr[1], ctx))).isValid()) {
            Err.BASEINV.thrw(this.info, base);
        }
        IOContent io = new IOContent(cont, Token.string(base.string()));
        try {
            return new DBNode(io, ctx.context.prop);
        }
        catch (IOException ex) {
            throw Err.SAXERR.thrw(this.info, ex);
        }
    }

    private Str serialize(QueryContext ctx) throws QueryException {
        ArrayOutput ao = new ArrayOutput();
        try {
            Item it = this.expr.length > 1 ? this.expr[1].item(ctx, this.info) : null;
            Serializer ser = Serializer.get(ao, FuncParams.serializerProp(it));
            Iter ir = this.expr[0].iter(ctx);
            while ((it = ir.next()) != null) {
                ser.serialize(it);
            }
            ser.close();
        }
        catch (SerializerException ex) {
            throw ex.getCause(this.info);
        }
        catch (IOException ex) {
            Err.SERANY.thrw(this.info, ex);
        }
        return Str.get(Token.delete(ao.toArray(), 13));
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CNS && this.sig == Function.PARSE_XML || u == Expr.Use.UPD && this.sig == Function.PUT || u == Expr.Use.X30 && (this.sig == Function.DATA && this.expr.length == 0 || FNGen.oneOf(this.sig, Function.UNPARSED_TEXT, Function.UNPARSED_TEXT_LINES, Function.UNPARSED_TEXT_AVAILABLE, Function.PARSE_XML, Function.URI_COLLECTION, Function.SERIALIZE)) || u == Expr.Use.CTX && (this.sig == Function.DATA && this.expr.length == 0 || this.sig == Function.PUT) || super.uses(u);
    }

    @Override
    public boolean databases(StringList db) {
        if (FNGen.oneOf(this.sig, Function.DOC, Function.COLLECTION)) {
            if (this.expr.length == 0 || !(this.expr[0] instanceof Str)) {
                return false;
            }
            QueryInput qi = new QueryInput(Token.string(((Str)this.expr[0]).string()));
            if (qi.db == null) {
                return false;
            }
            db.add(qi.db);
            return true;
        }
        return super.databases(db);
    }

    @Override
    public boolean iterable() {
        return this.sig == Function.COLLECTION || super.iterable();
    }
}

