/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import java.util.Comparator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.util.InputInfo;
import org.basex.util.MinHeap;

public final class FNHof
extends StandardFunc {
    public FNHof(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _HOF_SORT_WITH: {
                return this.sortWith(ctx).iter();
            }
            case _HOF_ID: 
            case _HOF_CONST: {
                return ctx.iter(this.expr[0]);
            }
            case _HOF_FOLD_LEFT1: {
                return this.foldLeft1(ctx).iter();
            }
            case _HOF_UNTIL: {
                return this.until(ctx).iter();
            }
            case _HOF_TOP_K_BY: {
                return this.topKBy(ctx).iter();
            }
            case _HOF_TOP_K_WITH: {
                return this.topKWith(ctx).iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _HOF_SORT_WITH: {
                return this.sortWith(ctx);
            }
            case _HOF_FOLD_LEFT1: {
                return this.foldLeft1(ctx);
            }
            case _HOF_UNTIL: {
                return this.until(ctx);
            }
            case _HOF_ID: 
            case _HOF_CONST: {
                return ctx.value(this.expr[0]);
            }
            case _HOF_TOP_K_BY: {
                return this.topKBy(ctx);
            }
            case _HOF_TOP_K_WITH: {
                return this.topKWith(ctx);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _HOF_ID: 
            case _HOF_CONST: {
                return this.expr[0].item(ctx, ii);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    Expr comp(QueryContext ctx) throws QueryException {
        return FNHof.oneOf(this.sig, Function._HOF_ID, Function._HOF_CONST) ? this.expr[0] : super.comp(ctx);
    }

    private Value foldLeft1(QueryContext ctx) throws QueryException {
        Item x;
        FItem f = this.withArity(0, 2, ctx);
        Iter xs = this.expr[1].iter(ctx);
        Value sum = this.checkNoEmpty(xs.next());
        while ((x = xs.next()) != null) {
            sum = f.invValue(ctx, this.info, sum, x);
        }
        return sum;
    }

    private Value sortWith(QueryContext ctx) throws QueryException {
        Value v = this.expr[1].value(ctx);
        Comparator<Item> cmp = this.getComp(0, ctx);
        if (v.size() < 2L) {
            return v;
        }
        ValueBuilder vb = v.cache();
        try {
            Arrays.sort(vb.item, 0, (int)vb.size(), cmp);
        }
        catch (QueryError err) {
            throw err.wrapped();
        }
        return vb.value();
    }

    private Value until(QueryContext ctx) throws QueryException {
        FItem pred = this.withArity(0, 1, ctx);
        FItem fun = this.withArity(1, 1, ctx);
        Value v = ctx.value(this.expr[2]);
        while (!this.checkBln(this.checkNoEmpty(pred.invItem(ctx, this.info, v)), ctx)) {
            v = fun.invValue(ctx, this.info, v);
        }
        return v;
    }

    private Value topKBy(QueryContext ctx) throws QueryException {
        FItem getKey = this.withArity(1, 1, ctx);
        long k = this.checkItr(this.expr[2], ctx);
        if (k < 1L || k > 0x3FFFFFFFL) {
            return Empty.SEQ;
        }
        Iter iter = this.expr[0].iter(ctx);
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((int)k, new Comparator<Item>(){

            @Override
            public int compare(Item it1, Item it2) {
                try {
                    return CmpV.OpV.LT.eval(FNHof.this.info, it1, it2) ? -1 : 1;
                }
                catch (QueryException qe) {
                    throw new QueryError(qe);
                }
            }
        });
        try {
            Item it;
            while ((it = iter.next()) != null) {
                heap.insert(this.checkNoEmpty(getKey.invItem(ctx, this.info, it)), it);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryError e) {
            throw e.wrapped();
        }
        Item[] arr = new Item[heap.size()];
        int i = arr.length;
        while (--i >= 0) {
            arr[i] = (Item)heap.removeMin();
        }
        return Seq.get(arr, arr.length);
    }

    private Value topKWith(QueryContext ctx) throws QueryException {
        Comparator<Item> cmp = this.getComp(1, ctx);
        long k = this.checkItr(this.expr[2], ctx);
        if (k < 1L || k > 0x3FFFFFFFL) {
            return Empty.SEQ;
        }
        Iter iter = this.expr[0].iter(ctx);
        MinHeap<Item, Item> heap = new MinHeap<Item, Item>((int)k, cmp);
        try {
            Item it;
            while ((it = iter.next()) != null) {
                heap.insert(it, it);
                if ((long)heap.size() <= k) continue;
                heap.removeMin();
            }
        }
        catch (QueryError e) {
            throw e.wrapped();
        }
        Item[] arr = new Item[heap.size()];
        int i = arr.length;
        while (--i >= 0) {
            arr[i] = (Item)heap.removeMin();
        }
        return Seq.get(arr, arr.length);
    }

    private Comparator<Item> getComp(int pos, final QueryContext ctx) throws QueryException {
        final FItem lt = this.withArity(pos, 2, ctx);
        return new Comparator<Item>(){

            @Override
            public int compare(Item a, Item b) {
                try {
                    return FNHof.this.checkType(lt.invItem(ctx, FNHof.this.info, a == null ? Empty.SEQ : a, b == null ? Empty.SEQ : b), AtomType.BLN).bool(FNHof.this.info) ? -1 : 1;
                }
                catch (QueryException qe) {
                    throw new QueryError(qe);
                }
            }
        };
    }

    private FItem withArity(int p, int a, QueryContext ctx) throws QueryException {
        Item f = this.checkItem(this.expr[p], ctx);
        if (!f.type.isFunction() || ((FItem)f).arity() != a) {
            Err.type(this, FuncType.arity(a), f);
        }
        return (FItem)f;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return this.sig == Function.PARTIAL_APPLY && u == Expr.Use.CTX || u == Expr.Use.X30 || super.uses(u);
    }
}

