/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.core.Perm;
import org.basex.core.Prop;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class FNInfo
extends StandardFunc {
    public FNInfo(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(final QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case ERROR: {
                int al = this.expr.length;
                if (al == 0) {
                    Err.FUNERR1.thrw(this.info, new Object[0]);
                }
                QNm name = Err.FUNERR1.qname();
                String msg = Err.FUNERR1.desc;
                Item it = this.expr[0].item(ctx, this.info);
                if (it == null) {
                    if (al == 1) {
                        Err.XPEMPTY.thrw(this.info, this.description());
                    }
                } else {
                    name = (QNm)this.checkType(it, AtomType.QNM);
                }
                if (al > 1) {
                    msg = Token.string(this.checkEStr(this.expr[1], ctx));
                }
                Value val = al > 2 ? ctx.value(this.expr[2]) : null;
                throw new QueryException(this.info, name, msg, new Object[0]).value(val);
            }
            case TRACE: {
                return new Iter(){
                    final Iter ir;
                    final byte[] s;
                    {
                        this.ir = FNInfo.this.expr[0].iter(ctx);
                        this.s = FNInfo.this.checkStr(FNInfo.this.expr[1], ctx);
                    }

                    @Override
                    public Item next() throws QueryException {
                        Item i = this.ir.next();
                        if (i != null) {
                            FNInfo.dump(Token.token(i.toString()), this.s, ctx);
                        }
                        return i;
                    }
                };
            }
            case AVAILABLE_ENVIRONMENT_VARIABLES: {
                ValueBuilder vb = new ValueBuilder();
                for (Object k : System.getenv().keySet().toArray()) {
                    vb.add(Str.get(k));
                }
                return vb;
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case ENVIRONMENT_VARIABLE: {
                String e = System.getenv(Token.string(this.checkEStr(this.expr[0], ctx)));
                return e != null ? Str.get(e) : null;
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Expr comp(QueryContext ctx) {
        if (this.sig == Function.TRACE) {
            this.type = this.expr[0].type();
        }
        return this;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && FNInfo.oneOf(this.sig, Function.ENVIRONMENT_VARIABLE, Function.AVAILABLE_ENVIRONMENT_VARIABLES) || u == Expr.Use.NDT && FNInfo.oneOf(this.sig, Function.ERROR, Function.TRACE) || super.uses(u);
    }

    static void dump(byte[] value, byte[] label, QueryContext ctx) {
        TokenBuilder tb = new TokenBuilder();
        if (label != null) {
            tb.add(label);
        }
        tb.add(value);
        if (Prop.gui || !ctx.context.user.has(Perm.ADMIN)) {
            ctx.evalInfo(tb.finish());
        } else {
            Util.errln(tb.toString(), new Object[0]);
        }
    }
}

