/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.util.InputInfo;

public final class FNMap
extends StandardFunc {
    public FNMap(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _MAP_GET: {
                return this.get(ctx).iter();
            }
            case _MAP_KEYS: {
                return this.map(ctx).keys().iter();
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case _MAP_GET: {
                return this.get(ctx);
            }
            case _MAP_KEYS: {
                return this.map(ctx).keys();
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case _MAP_NEW: {
                return this.newMap(ctx, ii);
            }
            case _MAP_ENTRY: {
                return this.entry(ctx, ii);
            }
            case _MAP_CONTAINS: {
                return this.contains(ctx, ii);
            }
            case _MAP_SIZE: {
                return this.map(ctx).mapSize();
            }
            case _MAP_REMOVE: {
                return this.remove(ctx, ii);
            }
            case _MAP_COLLATION: {
                return this.map(ctx).collation();
            }
        }
        return super.item(ctx, ii);
    }

    private Map remove(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.map(ctx).delete(this.expr[1].item(ctx, ii), ii);
    }

    private Map entry(QueryContext ctx, InputInfo ii) throws QueryException {
        return Map.EMPTY.insert(this.expr[0].item(ctx, ii), ctx.value(this.expr[1]), ii);
    }

    private Map newMap(QueryContext ctx, InputInfo ii) throws QueryException {
        Item m;
        if (this.expr.length == 0) {
            return Map.EMPTY;
        }
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        Map map = Map.EMPTY;
        Iter maps = this.expr[0].iter(ctx);
        while ((m = maps.next()) != null) {
            map = map.addAll(this.checkMap(m), ii);
        }
        return map;
    }

    private Value get(QueryContext ctx) throws QueryException {
        return this.map(ctx).get(this.expr[1].item(ctx, this.info), this.info);
    }

    private Bln contains(QueryContext ctx, InputInfo ii) throws QueryException {
        return this.map(ctx).contains(this.expr[1].item(ctx, ii), ii);
    }

    private Map map(QueryContext ctx) throws QueryException {
        return this.checkMap(this.checkItem(this.expr[0], ctx));
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || super.uses(u);
    }
}

