/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.UUID;
import java.util.zip.CRC32;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.InputInfo;

public final class FNMath
extends StandardFunc {
    public FNMath(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        double d = 0.0;
        if (this.expr.length > 0 && this.sig != Function._MATH_CRC32) {
            if (this.expr[0].isEmpty()) {
                return null;
            }
            d = this.checkDbl(this.expr[0], ctx);
        }
        double e = this.expr.length == 2 ? this.checkDbl(this.expr[1], ctx) : 0.0;
        switch (this.sig) {
            case _MATH_PI: {
                return Dbl.get(Math.PI);
            }
            case _MATH_E: {
                return Dbl.get(Math.E);
            }
            case _MATH_SQRT: {
                return Dbl.get(StrictMath.sqrt(d));
            }
            case _MATH_SIN: {
                return Dbl.get(StrictMath.sin(d));
            }
            case _MATH_COS: {
                return Dbl.get(StrictMath.cos(d));
            }
            case _MATH_TAN: {
                return Dbl.get(StrictMath.tan(d));
            }
            case _MATH_ASIN: {
                return Dbl.get(StrictMath.asin(d));
            }
            case _MATH_ACOS: {
                return Dbl.get(StrictMath.acos(d));
            }
            case _MATH_ATAN: {
                return Dbl.get(StrictMath.atan(d));
            }
            case _MATH_EXP: {
                return Dbl.get(StrictMath.exp(d));
            }
            case _MATH_EXP10: {
                return Dbl.get(StrictMath.pow(10.0, d));
            }
            case _MATH_LOG: {
                return Dbl.get(StrictMath.log(d));
            }
            case _MATH_LOG10: {
                return Dbl.get(StrictMath.log10(d));
            }
            case _MATH_ATAN2: {
                return Dbl.get(StrictMath.atan2(d, e));
            }
            case _MATH_POW: {
                return Dbl.get(FNMath.power(d, e));
            }
            case _MATH_SINH: {
                return Dbl.get(StrictMath.sinh(d));
            }
            case _MATH_COSH: {
                return Dbl.get(StrictMath.cosh(d));
            }
            case _MATH_TANH: {
                return Dbl.get(StrictMath.tanh(d));
            }
            case _MATH_RANDOM: {
                return Dbl.get(StrictMath.random());
            }
            case _MATH_UUID: {
                return Str.get(UUID.randomUUID());
            }
            case _MATH_CRC32: {
                return this.crc32(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private static double power(double b, double e) {
        if (b == 1.0) {
            return 1.0;
        }
        if (b == -1.0) {
            if (Double.isNaN(e)) {
                return b;
            }
            if (Double.isInfinite(e)) {
                return 1.0;
            }
        }
        return StrictMath.pow(b, e);
    }

    private Hex crc32(QueryContext ctx) throws QueryException {
        CRC32 crc = new CRC32();
        crc.update(this.checkStr(this.expr[0], ctx));
        byte[] r = new byte[4];
        int i = r.length;
        int c = (int)crc.getValue();
        while (i-- > 0) {
            r[i] = (byte)c;
            c >>>= 8;
        }
        return new Hex(r);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || u == Expr.Use.NDT && FNMath.oneOf(this.sig, Function._MATH_RANDOM, Function._MATH_UUID) || super.uses(u);
    }
}

