/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.XMLToken;

public final class FNQName
extends StandardFunc {
    public FNQName(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case IN_SCOPE_PREFIXES: {
                return this.inscope(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Item it = this.expr[0].item(ctx, this.info);
        Item it2 = this.expr.length == 2 ? this.expr[1].item(ctx, this.info) : null;
        switch (this.sig) {
            case RESOLVE_QNAME: {
                return this.resolveQName(ctx, it, it2);
            }
            case QNAME: {
                return this.qName(it, it2);
            }
            case LOCAL_NAME_FROM_QNAME: {
                return this.lnFromQName(ctx, it);
            }
            case PREFIX_FROM_QNAME: {
                return this.prefixFromQName(ctx, it);
            }
            case NAMESPACE_URI_FOR_PREFIX: {
                return this.nsUriForPrefix(it, it2);
            }
            case RESOLVE_URI: {
                return this.resolveURI(ctx, it, it2);
            }
        }
        return super.item(ctx, ii);
    }

    private Iter inscope(QueryContext ctx) throws QueryException {
        ANode node = (ANode)this.checkType(this.expr[0].item(ctx, this.info), NodeType.ELM);
        Atts ns = node.nsScope().add(Token.XML, QueryText.XMLURI);
        int as = ns.size();
        ValueBuilder vb = new ValueBuilder(as);
        for (int a = 0; a < as; ++a) {
            byte[] key = ns.name(a);
            if (key.length + ns.string(a).length == 0) continue;
            vb.add(Str.get(key));
        }
        return vb;
    }

    private Item qName(Item it, Item it2) throws QueryException {
        QNm nm;
        byte[] str;
        byte[] uri = this.checkEStr(it);
        byte[] name = this.checkEStr(it2);
        byte[] byArray = str = !Token.contains(name, 58) && Token.eq(uri, QueryText.XMLURI) ? Token.concat(Token.XMLC, name) : name;
        if (!XMLToken.isQName(str)) {
            Err.value(this.info, AtomType.QNM, Str.get(name));
        }
        if ((nm = new QNm(str, uri)).hasPrefix() && uri.length == 0) {
            Err.value(this.info, AtomType.URI, Str.get(nm.uri()));
        }
        return nm;
    }

    private Item lnFromQName(QueryContext ctx, Item it) throws QueryException {
        if (it == null) {
            return null;
        }
        QNm nm = (QNm)this.checkType(it, AtomType.QNM);
        return AtomType.NCN.cast(Str.get(nm.local()), ctx, this.info);
    }

    private Item prefixFromQName(QueryContext ctx, Item it) throws QueryException {
        if (it == null) {
            return null;
        }
        QNm nm = (QNm)this.checkType(it, AtomType.QNM);
        return nm.hasPrefix() ? AtomType.NCN.cast(Str.get(nm.prefix()), ctx, this.info) : null;
    }

    private Item resolveQName(QueryContext ctx, Item it, Item it2) throws QueryException {
        QNm nm;
        byte[] pref;
        byte[] uri;
        ANode base = (ANode)this.checkType(it2, NodeType.ELM);
        if (it == null) {
            return null;
        }
        byte[] name = this.checkEStr(it);
        if (!XMLToken.isQName(name)) {
            Err.value(this.info, AtomType.QNM, it);
        }
        if ((uri = base.uri(pref = (nm = new QNm(name)).prefix(), ctx)) == null) {
            Err.NSDECL.thrw(this.info, new Object[]{pref});
        }
        nm.uri(uri);
        return nm;
    }

    private Item nsUriForPrefix(Item it, Item it2) throws QueryException {
        byte[] pref = this.checkEStr(it);
        ANode an = (ANode)this.checkType(it2, NodeType.ELM);
        if (Token.eq(pref, Token.XML)) {
            return Uri.uri(QueryText.XMLURI, false);
        }
        Atts at = an.nsScope();
        int i = at.get(pref);
        return i == -1 || at.string(i).length == 0 ? null : Uri.uri(at.string(i), false);
    }

    private Item resolveURI(QueryContext ctx, Item it, Item it2) throws QueryException {
        Uri base;
        if (it == null) {
            return null;
        }
        Uri rel = Uri.uri(this.checkEStr(it));
        if (!rel.isValid()) {
            Err.URIINV.thrw(this.info, rel);
        }
        if (rel.isAbsolute()) {
            return rel;
        }
        Uri uri = base = it2 == null ? ctx.sc.baseURI() : Uri.uri(this.checkEStr(it2));
        if (!base.isValid()) {
            Err.URIINV.thrw(this.info, base);
        }
        if (!base.isAbsolute()) {
            Err.URIABS.thrw(this.info, base);
        }
        return base.resolve(rel);
    }
}

