/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.path.PathNode;
import org.basex.index.stats.StatsType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.AxisPath;
import org.basex.query.util.ItemSet;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public final class FNSeq
extends StandardFunc {
    public FNSeq(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.sig) {
            case HEAD: {
                return this.head(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case INDEX_OF: {
                return this.indexOf(ctx);
            }
            case DISTINCT_VALUES: {
                return this.distinctValues(ctx);
            }
            case INSERT_BEFORE: {
                return this.insertBefore(ctx);
            }
            case REVERSE: {
                return this.reverse(ctx);
            }
            case REMOVE: {
                return this.remove(ctx);
            }
            case SUBSEQUENCE: {
                return this.subsequence(ctx);
            }
            case TAIL: {
                return this.tail(ctx);
            }
            case OUTERMOST: {
                return this.most(ctx, true);
            }
            case INNERMOST: {
                return this.most(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    private Iter most(QueryContext ctx, boolean outer) throws QueryException {
        Item it;
        Iter iter = this.expr[0].iter(ctx);
        NodeSeqBuilder nc = new NodeSeqBuilder().check();
        while ((it = iter.next()) != null) {
            nc.add(this.checkNode(it));
        }
        int len = (int)nc.size();
        if (len < 2) {
            return nc;
        }
        if (nc.dbnodes()) {
            DBNode fst = (DBNode)nc.get(outer ? 0 : len - 1);
            Data data = fst.data;
            ANode[] nodes = (ANode[])nc.item.clone();
            if (outer) {
                nc.size(0);
                DBNode dummy = new DBNode(fst.data);
                NodeSeqBuilder src = new NodeSeqBuilder(nodes, len);
                int next = 0;
                while (next < len) {
                    DBNode nd = (DBNode)nodes[next];
                    dummy.pre = nd.pre + data.size(nd.pre, data.kind(nd.pre));
                    int p = src.binarySearch(dummy, next + 1, len - next - 1);
                    nc.add(nd);
                    next = p < 0 ? -p - 1 : p;
                }
            } else {
                nc.item[0] = fst;
                nc.size(1);
                int before = fst.pre;
                int i = len - 1;
                while (i-- != 0) {
                    DBNode nd = (DBNode)nodes[i];
                    if (nd.pre + data.size(nd.pre, data.kind(nd.pre)) > before) continue;
                    nc.add(nd);
                    before = nd.pre;
                }
                Array.reverse(nc.item, 0, (int)nc.size());
            }
            return nc;
        }
        NodeSeqBuilder out = new NodeSeqBuilder(new ANode[len], 0);
        block3: for (int i = 0; i < len; ++i) {
            ANode a;
            AxisIter ax;
            ANode nd = nc.item[i];
            AxisIter axisIter = ax = outer ? nd.ancestor() : nd.descendant();
            while ((a = ax.next()) != null) {
                if (nc.indexOf(a, false) == -1) continue;
                continue block3;
            }
            out.add(nc.item[i]);
        }
        return out;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        if (this.sig == Function.INDEX_OF || this.sig == Function.INSERT_BEFORE) {
            return this;
        }
        Type t = this.expr[0].type().type;
        SeqType.Occ o = SeqType.Occ.ZERO_MORE;
        if (this.sig == Function.SUBSEQUENCE && this.expr[0].type().one()) {
            o = SeqType.Occ.ZERO_ONE;
        } else if (this.sig == Function.HEAD) {
            o = SeqType.Occ.ZERO_ONE;
        }
        this.type = SeqType.get(t, o);
        if (this.sig == Function.DISTINCT_VALUES) {
            return this.cmpDist(ctx);
        }
        return this;
    }

    private Expr cmpDist(QueryContext ctx) throws QueryException {
        if (!(this.expr[0] instanceof AxisPath)) {
            return this;
        }
        ArrayList<PathNode> nodes = ((AxisPath)this.expr[0]).nodes(ctx);
        if (nodes == null) {
            return this;
        }
        ItemSet is = new ItemSet();
        for (PathNode pn : nodes) {
            if (pn.kind == 1) {
                if (!pn.stats.isLeaf()) {
                    return this;
                }
                for (PathNode n : pn.ch) {
                    if (n.kind != 2) continue;
                    pn = n;
                }
            }
            if (pn.kind != 2 && pn.kind != 3) {
                return this;
            }
            if (pn.stats.type != StatsType.CATEGORY) {
                return this;
            }
            for (byte[] c : pn.stats.cats) {
                is.index(this.info, new Atm(c));
            }
        }
        ValueBuilder vb = new ValueBuilder(is.size());
        for (Item i : is) {
            vb.add(i);
        }
        return vb.value();
    }

    private Item head(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        return e.type().zeroOrOne() ? e.item(ctx, this.info) : e.iter(ctx).next();
    }

    private Iter tail(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        if (e.type().zeroOrOne()) {
            return Empty.ITER;
        }
        final Iter ir = e.iter(ctx);
        if (ir.next() == null) {
            return Empty.ITER;
        }
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                return ir.next();
            }
        };
    }

    private Iter indexOf(final QueryContext ctx) throws QueryException {
        final Item it = this.checkItem(this.expr[1], ctx);
        if (this.expr.length == 3) {
            this.checkColl(this.expr[2], ctx);
        }
        return new Iter(){
            final Iter ir;
            int c;
            {
                this.ir = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ++this.c;
                } while (!i.comparable(it) || !CmpV.OpV.EQ.eval(FNSeq.this.info, i, it));
                return Int.get(this.c);
            }
        };
    }

    private Iter distinctValues(final QueryContext ctx) throws QueryException {
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        return new Iter(){
            final ItemSet map = new ItemSet();
            final Iter ir;
            {
                this.ir = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ctx.checkStop();
                } while (!this.map.index(FNSeq.this.info, i = StandardFunc.atom(i, FNSeq.this.info)));
                return i;
            }
        };
    }

    private Iter insertBefore(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final long pos;
            final Iter iter;
            final Iter ins;
            long p;
            boolean last;
            {
                this.pos = Math.max(1L, FNSeq.this.checkItr(FNSeq.this.expr[1], ctx));
                this.iter = FNSeq.this.expr[0].iter(ctx);
                this.ins = FNSeq.this.expr[2].iter(ctx);
                this.p = this.pos;
            }

            @Override
            public Item next() throws QueryException {
                if (this.last) {
                    return this.p > 0L ? this.ins.next() : null;
                }
                boolean sub = this.p == 0L || --this.p == 0L;
                Item i = (sub ? this.ins : this.iter).next();
                if (i != null) {
                    return i;
                }
                if (sub) {
                    --this.p;
                } else {
                    this.last = true;
                }
                return this.next();
            }
        };
    }

    private Iter remove(final QueryContext ctx) throws QueryException {
        return new Iter(){
            final long pos;
            final Iter iter;
            long c;
            {
                this.pos = FNSeq.this.checkItr(FNSeq.this.expr[1], ctx);
                this.iter = FNSeq.this.expr[0].iter(ctx);
            }

            @Override
            public Item next() throws QueryException {
                return ++this.c != this.pos || this.iter.next() != null ? this.iter.next() : null;
            }
        };
    }

    private Iter subsequence(QueryContext ctx) throws QueryException {
        double ds = this.checkDbl(this.expr[1], ctx);
        if (Double.isNaN(ds)) {
            return Empty.ITER;
        }
        final long s = StrictMath.round(ds);
        long l = Long.MAX_VALUE;
        if (this.expr.length > 2) {
            double dl = this.checkDbl(this.expr[2], ctx);
            if (Double.isNaN(dl)) {
                return Empty.ITER;
            }
            l = s + StrictMath.round(dl);
        }
        final long e = l;
        final Iter iter = ctx.iter(this.expr[0]);
        final long max = iter.size();
        return max != -1L ? new Iter(){
            final long m;
            long c;
            {
                this.m = Math.min(e, max + 1L);
                this.c = Math.max(1L, s);
            }

            @Override
            public Item next() throws QueryException {
                return this.c < this.m ? iter.get(this.c++ - 1L) : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(this.c + i - 1L);
            }

            @Override
            public long size() {
                return Math.max(0L, this.m - this.c);
            }

            @Override
            public boolean reset() {
                this.c = Math.max(1L, s);
                return true;
            }
        } : new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = iter.next()) != null && ++this.c < e) continue;
                    return null;
                } while (this.c < s);
                return i;
            }
        };
    }

    private ValueIter reverse(QueryContext ctx) throws QueryException {
        final Value val = ctx.value(this.expr[0]);
        final ValueIter iter = val.iter();
        return val.size() == 1L ? iter : new ValueIter(){
            final long s;
            long c;
            {
                this.c = this.s = iter.size();
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? iter.get(this.c) : null;
            }

            @Override
            public Item get(long i) {
                return iter.get(this.s - i - 1L);
            }

            @Override
            public long size() {
                return this.s;
            }

            @Override
            public boolean reset() {
                this.c = this.s;
                return true;
            }

            @Override
            public Value value() {
                Object[] arr = new Item[(int)val.size()];
                int written = val.writeTo((Item[])arr, 0);
                Array.reverse(arr, 0, written);
                return Seq.get((Item[])arr, written);
            }
        };
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && FNSeq.oneOf(this.sig, Function.HEAD, Function.TAIL) || super.uses(u);
    }
}

