/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.text.Normalizer;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class FNStr
extends StandardFunc {
    public FNStr(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        switch (this.sig) {
            case STRING_TO_CODEPOINTS: {
                return this.str2cp(e.item(ctx, this.info));
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        switch (this.sig) {
            case STRING_TO_CODEPOINTS: {
                int[] tmp = Token.cps(this.checkEStr(this.expr[0], ctx));
                long[] vals = new long[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    vals[i] = tmp[i];
                }
                return IntSeq.get(vals, AtomType.ITR);
            }
        }
        return super.value(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Expr e = this.expr[0];
        switch (this.sig) {
            case CODEPOINTS_TO_STRING: {
                return this.cp2str(ctx.iter(e));
            }
            case COMPARE: {
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                Item it1 = e.item(ctx, this.info);
                Item it2 = this.expr[1].item(ctx, this.info);
                if (it1 == null || it2 == null) {
                    return null;
                }
                int d = Token.diff(this.checkEStr(it1), this.checkEStr(it2));
                return Int.get(Math.max(-1, Math.min(1, d)));
            }
            case CODEPOINT_EQUAL: {
                Item it1 = e.item(ctx, this.info);
                Item it2 = this.expr[1].item(ctx, this.info);
                if (it1 == null || it2 == null) {
                    return null;
                }
                return Bln.get(Token.eq(this.checkEStr(it1), this.checkEStr(it2)));
            }
            case STRING_JOIN: {
                return this.strjoin(ctx);
            }
            case SUBSTRING: {
                return this.substr(ctx);
            }
            case NORMALIZE_UNICODE: {
                return this.normuni(ctx);
            }
            case UPPER_CASE: {
                return Str.get(Token.uc(this.checkEStr(e, ctx)));
            }
            case LOWER_CASE: {
                return Str.get(Token.lc(this.checkEStr(e, ctx)));
            }
            case TRANSLATE: {
                return this.trans(ctx);
            }
            case ENCODE_FOR_URI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), false));
            }
            case IRI_TO_URI: {
                return Str.get(Token.uri(this.checkEStr(e, ctx), true));
            }
            case ESCAPE_HTML_URI: {
                return Str.get(Token.escape(this.checkEStr(e, ctx)));
            }
            case CONCAT: {
                return this.concat(ctx);
            }
            case CONTAINS: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.info)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.contains(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case STARTS_WITH: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.info)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.startsWith(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case ENDS_WITH: {
                Item it;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                if ((it = this.expr[1].item(ctx, this.info)) == null) {
                    return Bln.TRUE;
                }
                return Bln.get(Token.endsWith(this.checkEStr(e, ctx), this.checkEStr(it)));
            }
            case SUBSTRING_AFTER: {
                byte[] sa;
                byte[] str;
                int pa;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                return (pa = Token.indexOf(str = this.checkEStr(e, ctx), sa = this.checkEStr(this.expr[1], ctx))) != -1 ? Str.get(Token.substring(str, pa + sa.length)) : Str.ZERO;
            }
            case SUBSTRING_BEFORE: {
                byte[] sb;
                int pb;
                if (this.expr.length == 3) {
                    this.checkColl(this.expr[2], ctx);
                }
                return (pb = Token.indexOf(sb = this.checkEStr(e, ctx), this.checkEStr(this.expr[1], ctx))) > 0 ? Str.get(Token.substring(sb, 0, pb)) : Str.ZERO;
            }
        }
        return super.item(ctx, ii);
    }

    private Item cp2str(Iter iter) throws QueryException {
        Item i;
        TokenBuilder tb = new TokenBuilder();
        while ((i = iter.next()) != null) {
            long n = this.checkItr(i);
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE || !XMLToken.valid((int)n)) {
                Err.INVCODE.thrw(this.info, i);
            }
            tb.add((int)n);
        }
        return Str.get(tb.finish());
    }

    private Iter str2cp(Item it) throws QueryException {
        if (it == null) {
            return Empty.ITER;
        }
        final byte[] s = this.checkEStr(it);
        return new Iter(){
            int l;

            @Override
            public Item next() {
                if (this.l == s.length) {
                    return null;
                }
                int i = Token.cp(s, this.l);
                this.l += Token.cl(s, this.l);
                return Int.get(i);
            }
        };
    }

    private Item substr(QueryContext ctx) throws QueryException {
        int l;
        int s;
        byte[] str = this.checkEStr(this.expr[0], ctx);
        Item is = this.checkItem(this.expr[1], ctx);
        if (is instanceof Int) {
            s = (int)is.itr(this.info) - 1;
        } else {
            double ds = is.dbl(this.info);
            if (Double.isNaN(ds)) {
                return Str.ZERO;
            }
            s = FNStr.subPos(ds);
        }
        boolean end = this.expr.length == 3;
        boolean ascii = Token.ascii(str);
        int e = l = ascii ? str.length : Token.len(str);
        if (end) {
            Item ie = this.checkItem(this.expr[2], ctx);
            int n = e = ie instanceof Int ? (int)ie.itr(this.info) : FNStr.subPos(ie.dbl(this.info) + 1.0);
        }
        if (s < 0) {
            e += s;
            s = 0;
        }
        if (s >= (e = Math.min(l, end ? s + e : Integer.MAX_VALUE))) {
            return Str.ZERO;
        }
        if (ascii) {
            return Str.get(Token.substring(str, s, e));
        }
        int ss = s;
        int ee = e;
        int p = 0;
        l = 0;
        while (l < str.length) {
            if (p == s) {
                ss = l;
            }
            if (p == e) {
                ee = l;
            }
            l += Token.cl(str, l);
            ++p;
        }
        if (p == e) {
            ee = l;
        }
        return Str.get(Arrays.copyOfRange(str, ss, ee));
    }

    private static int subPos(double d) {
        int i = (int)d;
        return d == (double)i ? i - 1 : (int)StrictMath.floor(d - 0.5);
    }

    private Item trans(QueryContext ctx) throws QueryException {
        int[] tok = Token.cps(this.checkEStr(this.expr[0], ctx));
        int[] srch = Token.cps(this.checkStr(this.expr[1], ctx));
        int[] rep = Token.cps(this.checkStr(this.expr[2], ctx));
        TokenBuilder tmp = new TokenBuilder(tok.length);
        for (int t : tok) {
            int j = -1;
            while (++j < srch.length && t != srch[j]) {
            }
            if (j < srch.length) {
                if (j >= rep.length) continue;
                tmp.add(rep[j]);
                continue;
            }
            tmp.add(t);
        }
        return Str.get(tmp.finish());
    }

    private Item strjoin(QueryContext ctx) throws QueryException {
        Item i;
        byte[] sep = this.expr.length == 2 ? this.checkStr(this.expr[1], ctx) : Token.EMPTY;
        TokenBuilder tb = new TokenBuilder();
        Iter iter = ctx.iter(this.expr[0]);
        int c = 0;
        while ((i = iter.next()) != null) {
            tb.add(this.checkEStr(i));
            tb.add(sep);
            ++c;
        }
        byte[] v = tb.finish();
        return Str.get(c == 0 ? v : Token.substring(v, 0, v.length - sep.length));
    }

    private Item normuni(QueryContext ctx) throws QueryException {
        byte[] str = this.checkEStr(this.expr[0], ctx);
        Normalizer.Form form = Normalizer.Form.NFC;
        if (this.expr.length == 2) {
            byte[] n = Token.uc(Token.trim(this.checkStr(this.expr[1], ctx)));
            if (n.length == 0) {
                return Str.get(str);
            }
            try {
                form = Normalizer.Form.valueOf(Token.string(n));
            }
            catch (IllegalArgumentException ex) {
                Err.NORMUNI.thrw(this.info, new Object[]{n});
            }
        }
        return Token.ascii(str) ? Str.get(str) : Str.get(Normalizer.normalize(Token.string(str), form));
    }

    private Item concat(QueryContext ctx) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Expr a : this.expr) {
            Item it = a.item(ctx, this.info);
            if (it == null) continue;
            tb.add(it.string(this.info));
        }
        return Str.get(tb.finish());
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && this.sig == Function.STRING_JOIN && this.expr.length == 1 || super.uses(u);
    }
}

