/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerProp;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.Err;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class FNValidate
extends StandardFunc {
    public FNValidate(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        this.checkCreate(ctx);
        switch (this.sig) {
            case _VALIDATE_XSD: {
                return this.xsd(ctx);
            }
            case _VALIDATE_DTD: {
                return this.dtd(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private Item xsd(QueryContext ctx) throws QueryException {
        IOFile tmp = null;
        try {
            Schema schema;
            IO in = this.read(0, ctx, null);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (this.expr.length < 2) {
                schema = sf.newSchema();
            } else {
                IO sc = this.read(1, ctx, null);
                if (!sc.exists()) {
                    Err.WHICHRES.thrw(this.info, sc);
                }
                if ((tmp = FNValidate.createTmp(sc)) != null) {
                    sc = tmp;
                }
                schema = sf.newSchema(new URL(sc.url()));
            }
            Validator v = schema.newValidator();
            v.setErrorHandler(new SchemaHandler());
            v.validate(new StreamSource(in.inputStream()));
            Item item = null;
            return item;
        }
        catch (Exception ex) {
            if (ex instanceof QueryException) {
                throw (QueryException)ex;
            }
            Util.debug(ex);
            Throwable e = ex;
            while (e.getCause() != null) {
                e = e.getCause();
            }
            throw Err.BXVA_FAIL.thrw(this.info, e);
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    private Item dtd(QueryContext ctx) throws QueryException {
        IOFile tmp = null;
        try {
            IO in;
            if (this.expr.length < 2) {
                in = this.read(0, ctx, null);
            } else {
                SerializerProp sp = new SerializerProp();
                String dtd = Token.string(this.checkStr(this.expr[1], ctx));
                IO sc = IO.get(dtd);
                if (!sc.exists()) {
                    Err.WHICHRES.thrw(this.info, dtd);
                }
                if ((tmp = FNValidate.createTmp(sc)) != null) {
                    sc = tmp;
                }
                sp.set(SerializerProp.S_DOCTYPE_SYSTEM, sc.url());
                in = this.read(0, ctx, sp);
            }
            SAXParserFactory sf = SAXParserFactory.newInstance();
            sf.setValidating(true);
            InputSource is = in.inputSource();
            sf.newSAXParser().parse(is, (DefaultHandler)new SchemaHandler());
            Item item = null;
            return item;
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw Err.BXVA_FAIL.thrw(this.info, ex);
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    private static IOFile createTmp(IO in) throws IOException {
        if (!(in instanceof IOContent) && !(in instanceof IOStream)) {
            return null;
        }
        IOFile tmp = new IOFile(File.createTempFile("validate", ".basex"));
        tmp.write(in.read());
        return tmp;
    }

    private IO read(int i, QueryContext ctx, SerializerProp sp) throws QueryException, IOException {
        Item it = this.checkItem(this.expr[i], ctx);
        if (it.isEmpty()) {
            Err.STRNODTYPE.thrw(this.info, this, it);
        }
        Type ip = it.type;
        ArrayOutput ao = new ArrayOutput();
        if (ip.isNode()) {
            Serializer.get(ao, sp).serialize((ANode)it);
            return new IOContent(ao.toArray());
        }
        if (ip.isString()) {
            String path = Token.string(it.string(this.info));
            IO io = IO.get(path);
            if (!io.exists()) {
                Err.WHICHRES.thrw(this.info, path);
            }
            if (sp != null) {
                Serializer.get(ao, sp).serialize(new DBNode(io, ctx.context.prop));
                io = new IOContent(ao.toArray());
                io.name(path);
            }
            return io;
        }
        throw Err.STRNODTYPE.thrw(this.info, this, ip);
    }

    public static class SchemaHandler
    extends DefaultHandler {
        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.error(ex);
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            String msg = ex.getMessage();
            if (msg.contains("Exception:")) {
                Throwable e = ex;
                while (((Throwable)e).getCause() != null) {
                    e = ((Throwable)e).getCause();
                }
                throw e instanceof SAXException ? (SAXException)e : new SAXException(msg);
            }
            TokenBuilder report = new TokenBuilder();
            String id = ex.getSystemId();
            if (id != null) {
                report.add(IO.get(id).name()).add(", ");
            }
            report.addExt(ex.getLineNumber(), new Object[0]).add(58).addExt(ex.getColumnNumber(), new Object[0]);
            report.add(": ").add(msg);
            throw new SAXException(report.toString());
        }
    }
}

