/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FNAcc;
import org.basex.query.func.FNAggr;
import org.basex.query.func.FNArchive;
import org.basex.query.func.FNClient;
import org.basex.query.func.FNContext;
import org.basex.query.func.FNConvert;
import org.basex.query.func.FNCrypto;
import org.basex.query.func.FNDate;
import org.basex.query.func.FNDb;
import org.basex.query.func.FNFile;
import org.basex.query.func.FNFormat;
import org.basex.query.func.FNFt;
import org.basex.query.func.FNFunc;
import org.basex.query.func.FNGen;
import org.basex.query.func.FNHash;
import org.basex.query.func.FNHof;
import org.basex.query.func.FNHttp;
import org.basex.query.func.FNId;
import org.basex.query.func.FNIndex;
import org.basex.query.func.FNInfo;
import org.basex.query.func.FNJson;
import org.basex.query.func.FNMap;
import org.basex.query.func.FNMath;
import org.basex.query.func.FNNode;
import org.basex.query.func.FNNum;
import org.basex.query.func.FNOut;
import org.basex.query.func.FNPat;
import org.basex.query.func.FNProc;
import org.basex.query.func.FNProf;
import org.basex.query.func.FNQName;
import org.basex.query.func.FNRepo;
import org.basex.query.func.FNSeq;
import org.basex.query.func.FNSimple;
import org.basex.query.func.FNSql;
import org.basex.query.func.FNStr;
import org.basex.query.func.FNValidate;
import org.basex.query.func.FNXQuery;
import org.basex.query.func.FNXslt;
import org.basex.query.func.FNZip;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Reflect;
import org.basex.util.TokenBuilder;

public enum Function {
    POSITION(FNAcc.class, "position()", SeqType.ITR, new SeqType[0]),
    LAST(FNAcc.class, "last()", SeqType.ITR, new SeqType[0]),
    STRING(FNAcc.class, "string([item])", SeqType.STR, 0, SeqType.ITEM_ZO),
    NUMBER(FNAcc.class, "number([item])", SeqType.DBL, 0, SeqType.AAT_ZO),
    STRING_LENGTH(FNAcc.class, "string-length([item])", SeqType.ITR, 0, SeqType.STR_ZO),
    NORMALIZE_SPACE(FNAcc.class, "normalize-space([string])", SeqType.STR, 0, SeqType.STR_ZO),
    NAMESPACE_URI_FROM_QNAME(FNAcc.class, "namespace-uri-from-QName(qname)", SeqType.URI_ZO, SeqType.QNM_ZO),
    AVG(FNAggr.class, "avg(item)", SeqType.AAT_ZO, SeqType.AAT_ZM),
    COUNT(FNAggr.class, "count(item)", SeqType.ITR, SeqType.ITEM_ZM),
    MAX(FNAggr.class, "max(item[,coll])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.STR),
    MIN(FNAggr.class, "min(item[,coll])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.STR),
    SUM(FNAggr.class, "sum(item[,zero])", SeqType.AAT_ZO, 1, SeqType.AAT_ZM, SeqType.AAT_ZO),
    CURRENT_DATE(FNContext.class, "current-date()", SeqType.DAT, new SeqType[0]),
    CURRENT_DATETIME(FNContext.class, "current-dateTime()", SeqType.DTM, new SeqType[0]),
    CURRENT_TIME(FNContext.class, "current-time()", SeqType.TIM, new SeqType[0]),
    IMPLICIT_TIMEZONE(FNContext.class, "implicit-timezone()", SeqType.DTD, new SeqType[0]),
    DEFAULT_COLLATION(FNContext.class, "default-collation()", SeqType.STR, new SeqType[0]),
    STATIC_BASE_URI(FNContext.class, "static-base-uri()", SeqType.URI_ZO, new SeqType[0]),
    DAY_FROM_DATE(FNDate.class, "day-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    DAY_FROM_DATETIME(FNDate.class, "day-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    DAYS_FROM_DURATION(FNDate.class, "days-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    HOURS_FROM_DATETIME(FNDate.class, "hours-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    HOURS_FROM_DURATION(FNDate.class, "hours-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    HOURS_FROM_TIME(FNDate.class, "hours-from-time(item)", SeqType.ITR_ZO, SeqType.TIM_ZO),
    MINUTES_FROM_DATETIME(FNDate.class, "minutes-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    MINUTES_FROM_DURATION(FNDate.class, "minutes-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    MINUTES_FROM_TIME(FNDate.class, "minutes-from-time(item)", SeqType.ITR_ZO, SeqType.TIM_ZO),
    MONTH_FROM_DATE(FNDate.class, "month-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    MONTH_FROM_DATETIME(FNDate.class, "month-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    MONTHS_FROM_DURATION(FNDate.class, "months-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    SECONDS_FROM_DATETIME(FNDate.class, "seconds-from-dateTime(datetime)", SeqType.DEC_ZO, SeqType.DTM_ZO),
    SECONDS_FROM_DURATION(FNDate.class, "seconds-from-duration(dur)", SeqType.DEC_ZO, SeqType.DUR_ZO),
    SECONDS_FROM_TIME(FNDate.class, "seconds-from-time(item)", SeqType.DEC_ZO, SeqType.TIM_ZO),
    TIMEZONE_FROM_DATE(FNDate.class, "timezone-from-date(item)", SeqType.DTD_ZO, SeqType.DAT_ZO),
    TIMEZONE_FROM_DATETIME(FNDate.class, "timezone-from-dateTime(item)", SeqType.DTD_ZO, SeqType.DTM_ZO),
    TIMEZONE_FROM_TIME(FNDate.class, "timezone-from-time(item)", SeqType.DTD_ZO, SeqType.TIM_ZO),
    YEAR_FROM_DATE(FNDate.class, "year-from-date(item)", SeqType.ITR_ZO, SeqType.DAT_ZO),
    YEAR_FROM_DATETIME(FNDate.class, "year-from-dateTime(datetime)", SeqType.ITR_ZO, SeqType.DTM_ZO),
    YEARS_FROM_DURATION(FNDate.class, "years-from-duration(dur)", SeqType.ITR_ZO, SeqType.DUR_ZO),
    ADJUST_DATE_TO_TIMEZONE(FNDate.class, "adjust-date-to-timezone(date[,zone])", SeqType.DAT_ZO, 1, SeqType.DAT_ZO, SeqType.DTD_ZO),
    ADJUST_DATETIME_TO_TIMEZONE(FNDate.class, "adjust-dateTime-to-timezone(date[,zone])", SeqType.DTM, 1, SeqType.DTM_ZO, SeqType.DTD_ZO),
    ADJUST_TIME_TO_TIMEZONE(FNDate.class, "adjust-time-to-timezone(date[,zone])", SeqType.TIM_ZO, 1, SeqType.TIM_ZO, SeqType.DTD_ZO),
    DATETIME(FNDate.class, "dateTime(date,time)", SeqType.DTM_ZO, SeqType.DAT_ZO, SeqType.TIM_ZO),
    FORMAT_INTEGER(FNFormat.class, "format-integer(number,picture[,lang])", SeqType.STR, 2, SeqType.ITR_ZO, SeqType.STR, SeqType.STR),
    FORMAT_NUMBER(FNFormat.class, "format-number(number,picture[,format])", SeqType.STR, 2, SeqType.ITR_ZO, SeqType.STR, SeqType.STR),
    FORMAT_DATETIME(FNFormat.class, "format-dateTime(number,picture,[lang,cal,place])", SeqType.STR_ZO, 2, SeqType.DTM_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FORMAT_DATE(FNFormat.class, "format-date(date,picture,[lang,cal,place])", SeqType.STR_ZO, 2, SeqType.DAT_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FORMAT_TIME(FNFormat.class, "format-time(number,picture,[lang,cal,place])", SeqType.STR_ZO, 2, SeqType.TIM_ZO, SeqType.STR, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    FILTER(FNFunc.class, "filter(function,seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.BLN, SeqType.ITEM).seqType(), SeqType.ITEM_ZM),
    FUNCTION_NAME(FNFunc.class, "function-name(function)", SeqType.QNM_ZO, SeqType.FUN_O),
    FUNCTION_ARITY(FNFunc.class, "function-arity(function)", SeqType.ITR, SeqType.FUN_O),
    FUNCTION_LOOKUP(FNFunc.class, "function-lookup(name,arity)", SeqType.FUN_O, SeqType.QNM, SeqType.ITR),
    MAP(FNFunc.class, "map(function,seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM).seqType(), SeqType.ITEM_ZM),
    MAP_PAIRS(FNFunc.class, "map-pairs(function,seq1,seq2)", SeqType.ITEM_ZM, FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM, SeqType.ITEM).seqType(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    FOLD_LEFT(FNFunc.class, "fold-left(function,zero,seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITEM).seqType(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    FOLD_RIGHT(FNFunc.class, "fold-right(function,zero,seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM, SeqType.ITEM_ZM).seqType(), SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    PARTIAL_APPLY(FNFunc.class, "partial-apply(function,arg[,pos])", SeqType.FUN_O, 2, SeqType.FUN_O, SeqType.ITEM_ZM, SeqType.ITR),
    DATA(FNGen.class, "data([item])", SeqType.AAT_ZM, 0, SeqType.ITEM_ZM),
    COLLECTION(FNGen.class, "collection([uri])", SeqType.NOD_ZM, 0, SeqType.STR_ZO),
    DOC(FNGen.class, "doc(uri)", SeqType.DOC_ZO, SeqType.STR_ZO),
    DOC_AVAILABLE(FNGen.class, "doc-available(uri)", SeqType.BLN, SeqType.STR_ZO),
    PUT(FNGen.class, "put(node,uri)", SeqType.EMP, SeqType.NOD, SeqType.STR_ZO),
    UNPARSED_TEXT(FNGen.class, "unparsed-text(uri[,encoding])", SeqType.STR_ZO, 1, SeqType.STR_ZO, SeqType.STR),
    UNPARSED_TEXT_LINES(FNGen.class, "unparsed-text-lines(uri[,encoding])", SeqType.STR_ZM, 1, SeqType.STR_ZO, SeqType.STR),
    UNPARSED_TEXT_AVAILABLE(FNGen.class, "unparsed-text-available(uri[,encoding])", SeqType.BLN, 1, SeqType.STR_ZO, SeqType.STR),
    PARSE_XML(FNGen.class, "parse-xml(string[,base])", SeqType.DOC_O, 1, SeqType.STR_ZO, SeqType.STR),
    URI_COLLECTION(FNGen.class, "uri-collection([uri])", SeqType.URI_ZM, 0, SeqType.STR_ZO),
    SERIALIZE(FNGen.class, "serialize(items[,params])", SeqType.STR, 1, SeqType.ITEM_ZM, SeqType.ITEM),
    ID(FNId.class, "id(string[,item])", SeqType.ELM_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    IDREF(FNId.class, "idref(string[,item])", SeqType.NOD_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    LANG(FNId.class, "lang(string[,item])", SeqType.BLN, 1, SeqType.STR_ZO, SeqType.NOD),
    ELEMENT_WITH_ID(FNId.class, "element-with-id(string[,item])", SeqType.ELM_ZM, 1, SeqType.STR_ZM, SeqType.NOD),
    ERROR(FNInfo.class, "error([code[,desc[,object]]])", SeqType.EMP, 0, SeqType.QNM_ZO, SeqType.STR, SeqType.ITEM_ZM),
    TRACE(FNInfo.class, "trace(value,label)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.STR),
    ENVIRONMENT_VARIABLE(FNInfo.class, "environment-variable(string)", SeqType.STR_ZO, SeqType.STR),
    AVAILABLE_ENVIRONMENT_VARIABLES(FNInfo.class, "available-environment-variables()", SeqType.STR_ZM, new SeqType[0]),
    DOCUMENT_URI(FNNode.class, "document-uri([node])", SeqType.URI_ZO, 0, SeqType.NOD_ZO),
    NILLED(FNNode.class, "nilled(node)", SeqType.BLN_ZO, SeqType.NOD_ZO),
    NODE_NAME(FNNode.class, "node-name([node])", SeqType.QNM_ZO, 0, SeqType.NOD_ZO),
    LOCAL_NAME(FNNode.class, "local-name([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    NAME(FNNode.class, "name([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    NAMESPACE_URI(FNNode.class, "namespace-uri([node])", SeqType.URI, 0, SeqType.NOD_ZO),
    ROOT(FNNode.class, "root([node])", SeqType.NOD_ZO, 0, SeqType.NOD_ZO),
    BASE_URI(FNNode.class, "base-uri([node])", SeqType.URI_ZO, 0, SeqType.NOD_ZO),
    GENERATE_ID(FNNode.class, "generate-id([node])", SeqType.STR, 0, SeqType.NOD_ZO),
    HAS_CHILDREN(FNNode.class, "has-children([node])", SeqType.BLN, 0, SeqType.NOD_ZM),
    PATH(FNNode.class, "path([node])", SeqType.STR_ZO, 0, SeqType.NOD_ZO),
    ABS(FNNum.class, "abs(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    CEILING(FNNum.class, "ceiling(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    FLOOR(FNNum.class, "floor(num)", SeqType.AAT_ZO, SeqType.AAT_ZO),
    ROUND(FNNum.class, "round(num[,prec])", SeqType.AAT_ZO, 1, SeqType.AAT_ZO, SeqType.ITR),
    ROUND_HALF_TO_EVEN(FNNum.class, "round-half-to-even(num[,prec])", SeqType.AAT_ZO, 1, SeqType.AAT_ZO, SeqType.ITR),
    MATCHES(FNPat.class, "matches(item,pattern[,mod])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    REPLACE(FNPat.class, "replace(item,pattern,replace[,mod])", SeqType.STR, 3, SeqType.STR_ZO, SeqType.STR, SeqType.STR, SeqType.STR),
    TOKENIZE(FNPat.class, "tokenize(item,pattern[,mod])", SeqType.STR_ZM, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    ANALYZE_STRING(FNPat.class, "analyze-string(input,pattern[,mod])", SeqType.ELM, 2, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    IN_SCOPE_PREFIXES(FNQName.class, "in-scope-prefixes(elem)", SeqType.STR_ZM, SeqType.ELM),
    LOCAL_NAME_FROM_QNAME(FNQName.class, "local-name-from-QName(qname)", SeqType.NCN_ZO, SeqType.QNM_ZO),
    NAMESPACE_URI_FOR_PREFIX(FNQName.class, "namespace-uri-for-prefix(pref,elem)", SeqType.URI_ZO, SeqType.STR_ZO, SeqType.ELM),
    QNAME(FNQName.class, "QName(uri,name)", SeqType.QNM, SeqType.STR_ZO, SeqType.STR),
    PREFIX_FROM_QNAME(FNQName.class, "prefix-from-QName(qname)", SeqType.NCN_ZO, SeqType.QNM_ZO),
    RESOLVE_QNAME(FNQName.class, "resolve-QName(item,base)", SeqType.QNM_ZO, SeqType.STR_ZO, SeqType.ELM),
    RESOLVE_URI(FNQName.class, "resolve-uri(name[,elem])", SeqType.URI_ZO, 1, SeqType.STR_ZO, SeqType.STR),
    DISTINCT_VALUES(FNSeq.class, "distinct-values(items[,coll])", SeqType.AAT_ZM, 1, SeqType.AAT_ZM, SeqType.STR),
    INDEX_OF(FNSeq.class, "index-of(items,item[,coll])", SeqType.ITR_ZM, 2, SeqType.AAT_ZM, SeqType.AAT, SeqType.STR),
    INSERT_BEFORE(FNSeq.class, "insert-before(items,pos,insert)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITR, SeqType.ITEM_ZM),
    REMOVE(FNSeq.class, "remove(items,pos)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITR),
    REVERSE(FNSeq.class, "reverse(items)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    SUBSEQUENCE(FNSeq.class, "subsequence(items,start[,len])", SeqType.ITEM_ZM, 2, SeqType.ITEM_ZM, SeqType.DBL, SeqType.DBL),
    HEAD(FNSeq.class, "head(items)", SeqType.ITEM_ZO, SeqType.ITEM_ZM),
    TAIL(FNSeq.class, "tail(items)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    OUTERMOST(FNSeq.class, "outermost(nodes)", SeqType.NOD_ZM, SeqType.NOD_ZM),
    INNERMOST(FNSeq.class, "innermost(nodes)", SeqType.NOD_ZM, SeqType.NOD_ZM),
    FALSE(FNSimple.class, "false()", SeqType.BLN, new SeqType[0]),
    TRUE(FNSimple.class, "true()", SeqType.BLN, new SeqType[0]),
    BOOLEAN(FNSimple.class, "boolean(item)", SeqType.BLN, SeqType.ITEM_ZM),
    NOT(FNSimple.class, "not(item)", SeqType.BLN, SeqType.ITEM_ZM),
    EMPTY(FNSimple.class, "empty(item)", SeqType.BLN, SeqType.ITEM_ZM),
    EXISTS(FNSimple.class, "exists(item)", SeqType.BLN, SeqType.ITEM_ZM),
    UNORDERED(FNSimple.class, "unordered(item)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    ZERO_OR_ONE(FNSimple.class, "zero-or-one(item)", SeqType.ITEM_ZO, SeqType.ITEM_ZM),
    EXACTLY_ONE(FNSimple.class, "exactly-one(item)", SeqType.ITEM, SeqType.ITEM_ZM),
    ONE_OR_MORE(FNSimple.class, "one-or-more(item)", SeqType.ITEM_OM, SeqType.ITEM_ZM),
    DEEP_EQUAL(FNSimple.class, "deep-equal(item,item[,coll])", SeqType.BLN, 2, SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.STR),
    DEEP_EQUAL_OPT(FNSimple.class, "deep-equal-opt(item,item[,options])", SeqType.BLN, 2, SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITEM),
    CODEPOINT_EQUAL(FNStr.class, "codepoint-equal(string,string)", SeqType.BLN_ZO, SeqType.STR_ZO, SeqType.STR_ZO),
    CODEPOINTS_TO_STRING(FNStr.class, "codepoints-to-string(nums)", SeqType.STR, SeqType.ITR_ZM),
    COMPARE(FNStr.class, "compare(first,second[,coll])", SeqType.ITR_ZO, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    CONCAT(FNStr.class, "concat(atom,atom[,...])", SeqType.STR, -2, SeqType.AAT_ZO, SeqType.AAT_ZO),
    CONTAINS(FNStr.class, "contains(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    ENCODE_FOR_URI(FNStr.class, "encode-for-uri(string)", SeqType.STR, SeqType.STR_ZO),
    ENDS_WITH(FNStr.class, "ends-with(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    ESCAPE_HTML_URI(FNStr.class, "escape-html-uri(string)", SeqType.STR, SeqType.STR_ZO),
    IRI_TO_URI(FNStr.class, "iri-to-uri(string)", SeqType.STR, SeqType.STR_ZO),
    LOWER_CASE(FNStr.class, "lower-case(string)", SeqType.STR, SeqType.STR_ZO),
    NORMALIZE_UNICODE(FNStr.class, "normalize-unicode(string[,form])", SeqType.STR, 1, SeqType.STR_ZO, SeqType.STR),
    STARTS_WITH(FNStr.class, "starts-with(string,sub[,coll])", SeqType.BLN, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    STRING_JOIN(FNStr.class, "string-join(strings[,sep])", SeqType.STR, 1, SeqType.STR_ZM, SeqType.STR),
    STRING_TO_CODEPOINTS(FNStr.class, "string-to-codepoints(string)", SeqType.ITR_ZM, SeqType.STR_ZO),
    SUBSTRING(FNStr.class, "substring(string,start[,len])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.DBL, SeqType.DBL),
    SUBSTRING_AFTER(FNStr.class, "substring-after(string,sub[,coll])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    SUBSTRING_BEFORE(FNStr.class, "substring-before(string,sub[,coll])", SeqType.STR, 2, SeqType.STR_ZO, SeqType.STR_ZO, SeqType.STR),
    TRANSLATE(FNStr.class, "translate(string,map,trans)", SeqType.STR, SeqType.STR_ZO, SeqType.STR, SeqType.STR),
    UPPER_CASE(FNStr.class, "upper-case(string)", SeqType.STR, SeqType.STR_ZO),
    _MAP_NEW(FNMap.class, "new([maps[,coll]])", SeqType.MAP_O, 0, SeqType.MAP_ZM, SeqType.STR),
    _MAP_ENTRY(FNMap.class, "entry(key,value)", SeqType.MAP_O, SeqType.AAT, SeqType.ITEM_ZM),
    _MAP_GET(FNMap.class, "get(map,key)", SeqType.ITEM_ZM, SeqType.MAP_O, SeqType.AAT),
    _MAP_CONTAINS(FNMap.class, "contains(map,key)", SeqType.BLN, SeqType.MAP_O, SeqType.AAT),
    _MAP_REMOVE(FNMap.class, "remove(map,key)", SeqType.MAP_O, SeqType.MAP_O, SeqType.AAT),
    _MAP_SIZE(FNMap.class, "size(map)", SeqType.ITR, SeqType.MAP_O),
    _MAP_KEYS(FNMap.class, "keys(map)", SeqType.AAT_ZM, SeqType.MAP_O),
    _MAP_COLLATION(FNMap.class, "collation(map)", SeqType.STR, SeqType.MAP_O),
    _MATH_PI(FNMath.class, "pi()", SeqType.DBL, new SeqType[0]),
    _MATH_SQRT(FNMath.class, "sqrt(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_SIN(FNMath.class, "sin(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_COS(FNMath.class, "cos(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_TAN(FNMath.class, "tan(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_ASIN(FNMath.class, "asin(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_ACOS(FNMath.class, "acos(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_ATAN(FNMath.class, "atan(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_ATAN2(FNMath.class, "atan2(number,number)", SeqType.DBL, SeqType.DBL, SeqType.DBL),
    _MATH_POW(FNMath.class, "pow(number,number)", SeqType.DBL_ZO, SeqType.DBL_ZO, SeqType.ITR),
    _MATH_EXP(FNMath.class, "exp(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_EXP10(FNMath.class, "exp10(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_LOG(FNMath.class, "log(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_LOG10(FNMath.class, "log10(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_E(FNMath.class, "e()", SeqType.DBL, new SeqType[0]),
    _MATH_SINH(FNMath.class, "sinh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_COSH(FNMath.class, "cosh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_TANH(FNMath.class, "tanh(number)", SeqType.DBL_ZO, SeqType.DBL_ZO),
    _MATH_RANDOM(FNMath.class, "random()", SeqType.DBL, new SeqType[0]),
    _MATH_CRC32(FNMath.class, "crc32(string)", SeqType.HEX, SeqType.STR),
    _MATH_UUID(FNMath.class, "uuid()", SeqType.STR, new SeqType[0]),
    _ARCHIVE_CREATE(FNArchive.class, "create(entries,contents[,options])", SeqType.B64, 2, SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.NOD),
    _ARCHIVE_ENTRIES(FNArchive.class, "entries(archive)", SeqType.ELM_ZM, SeqType.B64),
    _ARCHIVE_EXTRACT_TEXT(FNArchive.class, "extract-text(archiveip[,entries[,encoding]])", SeqType.STR_ZM, 1, SeqType.B64, SeqType.ITEM_ZM, SeqType.STR),
    _ARCHIVE_EXTRACT_BINARY(FNArchive.class, "extract-binary(archive[,entries])", SeqType.B64_ZM, 1, SeqType.B64, SeqType.ITEM_ZM),
    _ARCHIVE_UPDATE(FNArchive.class, "update(archive,entries,contents)", SeqType.B64, SeqType.B64, SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    _ARCHIVE_DELETE(FNArchive.class, "delete(archive,entries)", SeqType.B64, SeqType.B64, SeqType.ITEM_ZM),
    _ARCHIVE_OPTIONS(FNArchive.class, "options(archive)", SeqType.ELM, SeqType.B64),
    _CONVERT_INTEGER_TO_BASE(FNConvert.class, "integer-to-base(num,base)", SeqType.STR, SeqType.ITR, SeqType.ITR),
    _CONVERT_INTEGER_FROM_BASE(FNConvert.class, "integer-from-base(str,base)", SeqType.ITR, SeqType.STR, SeqType.ITR),
    _CONVERT_BINARY_TO_BYTES(FNConvert.class, "binary-to-bytes(binary)", SeqType.BYT_ZM, SeqType.ITEM),
    _CONVERT_BINARY_TO_STRING(FNConvert.class, "binary-to-string(binary[,encoding])", SeqType.STR, 1, SeqType.ITEM, SeqType.STR),
    _CONVERT_BYTES_TO_HEX(FNConvert.class, "bytes-to-hex(bytes)", SeqType.HEX, SeqType.BYT_ZM),
    _CONVERT_BYTES_TO_BASE64(FNConvert.class, "bytes-to-base64(bytes)", SeqType.B64, 1, SeqType.BYT_ZM),
    _CONVERT_STRING_TO_BASE64(FNConvert.class, "string-to-base64(string[,encoding])", SeqType.B64, 1, SeqType.STR, SeqType.STR),
    _CONVERT_STRING_TO_HEX(FNConvert.class, "string-to-hex(string[,encoding])", SeqType.HEX, 1, SeqType.STR, SeqType.STR),
    _DB_OPEN(FNDb.class, "open(database[,path])", SeqType.NOD_ZM, 1, SeqType.STR, SeqType.STR),
    _DB_OPEN_PRE(FNDb.class, "open-pre(database,pre)", SeqType.NOD_ZM, SeqType.STR, SeqType.ITR),
    _DB_OPEN_ID(FNDb.class, "open-id(database,id)", SeqType.NOD_ZM, SeqType.STR, SeqType.ITR),
    _DB_TEXT(FNDb.class, "text(database,string)", SeqType.NOD_ZM, SeqType.STR, SeqType.ITEM),
    _DB_TEXT_RANGE(FNDb.class, "text-range(database,from,to)", SeqType.NOD_ZM, SeqType.STR, SeqType.ITEM, SeqType.ITEM),
    _DB_ATTRIBUTE(FNDb.class, "attribute(database,string[,name])", SeqType.NOD_ZM, 2, SeqType.STR, SeqType.ITEM, SeqType.STR),
    _DB_ATTRIBUTE_RANGE(FNDb.class, "attribute-range(database,from,to[,name])", SeqType.NOD_ZM, 3, SeqType.STR, SeqType.ITEM, SeqType.ITEM, SeqType.STR),
    _DB_FULLTEXT(FNDb.class, "fulltext(database,string)", SeqType.NOD_ZM, SeqType.STR, SeqType.STR),
    _DB_LIST(FNDb.class, "list([database[,path]])", SeqType.STR_ZM, 0, SeqType.STR, SeqType.STR),
    _DB_LIST_DETAILS(FNDb.class, "list-details([database[,path]])", SeqType.NOD_ZM, 0, SeqType.STR, SeqType.STR),
    _DB_SYSTEM(FNDb.class, "system()", SeqType.STR, new SeqType[0]),
    _DB_INFO(FNDb.class, "info(database)", SeqType.STR, SeqType.STR),
    _DB_NODE_ID(FNDb.class, "node-id(nodes)", SeqType.ITR_ZM, SeqType.NOD_ZM),
    _DB_NODE_PRE(FNDb.class, "node-pre(nodes)", SeqType.ITR_ZM, SeqType.NOD_ZM),
    _DB_EVENT(FNDb.class, "event(name,query)", SeqType.EMP, SeqType.STR, SeqType.ITEM_ZM),
    _DB_OUTPUT(FNDb.class, "output(expression)", SeqType.EMP, SeqType.ITEM_ZM),
    _DB_ADD(FNDb.class, "add(database,nodes[,name[,path]])", SeqType.EMP, 2, SeqType.STR, SeqType.DOC_ZM, SeqType.STR, SeqType.STR),
    _DB_DELETE(FNDb.class, "delete(database,path)", SeqType.EMP, SeqType.STR, SeqType.STR),
    _DB_RENAME(FNDb.class, "rename(database,path,newpath)", SeqType.EMP, SeqType.STR, SeqType.STR, SeqType.STR),
    _DB_REPLACE(FNDb.class, "replace(database,path,item)", SeqType.EMP, SeqType.STR, SeqType.STR, SeqType.ITEM),
    _DB_OPTIMIZE(FNDb.class, "optimize(database[,all])", SeqType.EMP, 1, SeqType.STR, SeqType.BLN),
    _DB_RETRIEVE(FNDb.class, "retrieve(database,path)", SeqType.B64, SeqType.STR, SeqType.STR),
    _DB_STORE(FNDb.class, "store(database,path,value)", SeqType.EMP, SeqType.STR, SeqType.STR, SeqType.ITEM),
    _DB_IS_XML(FNDb.class, "is-xml(database,path)", SeqType.BLN, SeqType.STR, SeqType.STR),
    _DB_IS_RAW(FNDb.class, "is-raw(database,path)", SeqType.BLN, SeqType.STR, SeqType.STR),
    _DB_EXISTS(FNDb.class, "exists(database[,path])", SeqType.BLN, 1, SeqType.STR, SeqType.STR),
    _DB_CONTENT_TYPE(FNDb.class, "content-type(database,path)", SeqType.ITEM, SeqType.STR, SeqType.STR),
    _DB_FLUSH(FNDb.class, "flush(database)", SeqType.EMP, SeqType.STR),
    _INDEX_FACETS(FNIndex.class, "facets(database,format)", SeqType.DOC_O, 1, SeqType.STR, SeqType.STR),
    _INDEX_TEXTS(FNIndex.class, "texts(database,entry[,order])", SeqType.NOD_ZM, 1, SeqType.STR, SeqType.STR, SeqType.BLN),
    _INDEX_ATTRIBUTES(FNIndex.class, "attributes(database,prefix[,order])", SeqType.NOD_ZM, 1, SeqType.STR, SeqType.STR, SeqType.BLN),
    _INDEX_ELEMENT_NAMES(FNIndex.class, "element-names(database)", SeqType.NOD_ZM, SeqType.STR),
    _INDEX_ATTRIBUTE_NAMES(FNIndex.class, "attribute-names(database)", SeqType.NOD_ZM, SeqType.STR),
    _FILE_PATH_SEPARATOR(FNFile.class, "path-separator()", SeqType.STR, new SeqType[0]),
    _FILE_DIR_SEPARATOR(FNFile.class, "dir-separator()", SeqType.STR, new SeqType[0]),
    _FILE_LINE_SEPARATOR(FNFile.class, "line-separator()", SeqType.STR, new SeqType[0]),
    _FILE_EXISTS(FNFile.class, "exists(path)", SeqType.BLN, SeqType.STR),
    _FILE_IS_DIR(FNFile.class, "is-dir(path)", SeqType.BLN, SeqType.STR),
    _FILE_IS_FILE(FNFile.class, "is-file(path)", SeqType.BLN, SeqType.STR),
    _FILE_LAST_MODIFIED(FNFile.class, "last-modified(path)", SeqType.DTM, SeqType.STR),
    _FILE_SIZE(FNFile.class, "size(path)", SeqType.ITR, SeqType.STR),
    _FILE_BASE_NAME(FNFile.class, "base-name(path[,suffix])", SeqType.STR, 1, SeqType.STR, SeqType.STR),
    _FILE_DIR_NAME(FNFile.class, "dir-name(path)", SeqType.STR, SeqType.STR),
    _FILE_PATH_TO_NATIVE(FNFile.class, "path-to-native(path)", SeqType.STR, SeqType.STR),
    _FILE_PATH_TO_URI(FNFile.class, "path-to-uri(path)", SeqType.URI, SeqType.STR),
    _FILE_RESOLVE_PATH(FNFile.class, "resolve-path(path)", SeqType.STR, SeqType.STR),
    _FILE_LIST(FNFile.class, "list(path[,recursive[,pattern]])", SeqType.STR_ZM, 1, SeqType.STR, SeqType.BLN, SeqType.STR),
    _FILE_CREATE_DIR(FNFile.class, "create-dir(path)", SeqType.EMP, SeqType.STR),
    _FILE_DELETE(FNFile.class, "delete(path)", SeqType.EMP, 1, SeqType.STR, SeqType.BLN),
    _FILE_READ_TEXT(FNFile.class, "read-text(path[,encoding])", SeqType.STR, 1, SeqType.STR, SeqType.STR),
    _FILE_READ_TEXT_LINES(FNFile.class, "read-text-lines(path[,encoding])", SeqType.STR_ZM, 1, SeqType.STR, SeqType.STR),
    _FILE_READ_BINARY(FNFile.class, "read-binary(path)", SeqType.B64, SeqType.STR),
    _FILE_WRITE(FNFile.class, "write(path,data[,params])", SeqType.EMP, 2, SeqType.STR, SeqType.ITEM_ZM, SeqType.NOD),
    _FILE_WRITE_BINARY(FNFile.class, "write-binary(path,item)", SeqType.EMP, SeqType.STR, SeqType.BIN),
    _FILE_WRITE_TEXT(FNFile.class, "write-text(path,text[,encoding])", SeqType.EMP, 2, SeqType.STR, SeqType.STR, SeqType.STR),
    _FILE_WRITE_TEXT_LINES(FNFile.class, "write-text-lines(path,texts[,encoding])", SeqType.EMP, 2, SeqType.STR, SeqType.STR_ZM, SeqType.STR),
    _FILE_APPEND(FNFile.class, "append(path,data[,params])", SeqType.EMP, 2, SeqType.STR, SeqType.ITEM_ZM, SeqType.NOD),
    _FILE_APPEND_BINARY(FNFile.class, "append-binary(path,item)", SeqType.EMP, SeqType.STR, SeqType.BIN),
    _FILE_APPEND_TEXT(FNFile.class, "append-text(path,text[,encoding])", SeqType.EMP, 2, SeqType.STR, SeqType.STR, SeqType.STR),
    _FILE_APPEND_TEXT_LINES(FNFile.class, "append-text-lines(path,texts[,encoding])", SeqType.EMP, 2, SeqType.STR, SeqType.STR_ZM, SeqType.STR),
    _FILE_COPY(FNFile.class, "copy(source,target)", SeqType.EMP, SeqType.STR, SeqType.STR),
    _FILE_MOVE(FNFile.class, "move(source,target)", SeqType.EMP, SeqType.STR, SeqType.STR),
    _PROC_SYSTEM(FNProc.class, "system(command[,args[,encoding]])", SeqType.STR, 1, SeqType.STR, SeqType.STR_ZM, SeqType.STR),
    _PROC_EXECUTE(FNProc.class, "execute(command[,args[,encoding]]])", SeqType.ELM, 1, SeqType.STR, SeqType.STR_ZM, SeqType.STR),
    _CLIENT_CONNECT(FNClient.class, "connect(url,port,user,pass)", SeqType.URI, SeqType.STR, SeqType.ITR, SeqType.STR, SeqType.STR),
    _CLIENT_EXECUTE(FNClient.class, "execute(id,command)", SeqType.STR, SeqType.URI, SeqType.STR),
    _CLIENT_QUERY(FNClient.class, "query(id,query[,bindings])", SeqType.ITEM_ZO, 2, SeqType.URI, SeqType.STR, SeqType.ITEM),
    _CLIENT_CLOSE(FNClient.class, "close(id)", SeqType.EMP, SeqType.URI),
    _SQL_INIT(FNSql.class, "init(class)", SeqType.EMP, 1, SeqType.STR),
    _SQL_CONNECT(FNSql.class, "connect(url[,user[,pass[,options]]]]])", SeqType.ITR, 1, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.NOD_ZO),
    _SQL_PREPARE(FNSql.class, "prepare(id,statement)", SeqType.ITR, SeqType.ITR, SeqType.STR),
    _SQL_EXECUTE(FNSql.class, "execute(id,query)", SeqType.ELM_ZM, 1, SeqType.ITR, SeqType.STR),
    _SQL_EXECUTE_PREPARED(FNSql.class, "execute-prepared(id[,params])", SeqType.ELM_ZM, 1, SeqType.ITR, SeqType.ELM),
    _SQL_CLOSE(FNSql.class, "close(id)", SeqType.EMP, SeqType.ITR),
    _SQL_COMMIT(FNSql.class, "commit(id)", SeqType.EMP, SeqType.ITR),
    _SQL_ROLLBACK(FNSql.class, "rollback(id)", SeqType.EMP, SeqType.ITR),
    _REPO_INSTALL(FNRepo.class, "install(uri)", SeqType.EMP, SeqType.STR),
    _REPO_DELETE(FNRepo.class, "delete(uri)", SeqType.EMP, SeqType.STR),
    _REPO_LIST(FNRepo.class, "list()", SeqType.STR_ZM, new SeqType[0]),
    _FT_SEARCH(FNFt.class, "search(node,terms[,options])", SeqType.NOD_ZM, 2, SeqType.NOD, SeqType.ITEM_ZM, SeqType.ITEM),
    _FT_COUNT(FNFt.class, "count(nodes)", SeqType.ITR, SeqType.NOD_ZM),
    _FT_MARK(FNFt.class, "mark(nodes[,tag])", SeqType.NOD_ZM, 1, SeqType.NOD_ZM, SeqType.STR),
    _FT_EXTRACT(FNFt.class, "extract(nodes[,tag[,length]])", SeqType.NOD_ZM, 1, SeqType.ITEM_ZM, SeqType.STR, SeqType.ITR),
    _FT_SCORE(FNFt.class, "score(items)", SeqType.DBL_ZM, SeqType.ITEM_ZM),
    _FT_TOKENS(FNFt.class, "tokens(database,entry[,order])", SeqType.ITEM_ZM, 1, SeqType.STR, SeqType.STR, SeqType.BLN),
    _FT_TOKENIZE(FNFt.class, "tokenize(string)", SeqType.STR_ZM, SeqType.STR),
    _HOF_SORT_WITH(FNHof.class, "sort-with(lt-fun,seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.BLN, SeqType.ITEM, SeqType.ITEM).seqType(), SeqType.ITEM_ZM),
    _HOF_ID(FNHof.class, "id(expr)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    _HOF_CONST(FNHof.class, "const(return,ignore)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    _HOF_UNTIL(FNHof.class, "until(pred,func,start)", SeqType.ITEM_ZM, FuncType.get(SeqType.BLN, SeqType.ITEM_ZM).seqType(), FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM_ZM).seqType(), SeqType.ITEM_ZM),
    _HOF_FOLD_LEFT1(FNHof.class, "fold-left1(function,non-empty-seq)", SeqType.ITEM_ZM, FuncType.get(SeqType.ITEM_ZM, SeqType.ITEM_ZM, SeqType.ITEM).seqType(), SeqType.ITEM_OM),
    _HOF_TOP_K_BY(FNHof.class, "top-k-by(seq,key-fun,k)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, FuncType.arity(1).seqType(), SeqType.ITR),
    _HOF_TOP_K_WITH(FNHof.class, "top-k-with(seq,less-than,k)", SeqType.ITEM_ZM, SeqType.ITEM_ZM, FuncType.get(SeqType.BLN, SeqType.ITEM_ZO, SeqType.ITEM_ZO).seqType(), SeqType.ITR),
    _CRYPTO_HMAC(FNCrypto.class, "hmac(string,string,string[,string])", SeqType.STR, 3, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR_ZO),
    _CRYPTO_ENCRYPT(FNCrypto.class, "encrypt(string,string,string,string)", SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR),
    _CRYPTO_DECRYPT(FNCrypto.class, "decrypt(string,string,string,string)", SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR),
    _CRYPTO_GENERATE_SIGNATURE(FNCrypto.class, "generate-signature(node,string,string,string,string,string[,item][,item])", SeqType.NOD, 6, SeqType.NOD, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.STR, SeqType.ITEM_ZO, SeqType.ITEM_ZO),
    _CRYPTO_VALIDATE_SIGNATURE(FNCrypto.class, "validate-signature(node)", SeqType.BLN, SeqType.NOD),
    _HTTP_SEND_REQUEST(FNHttp.class, "send-request(request[,href,[bodies]])", SeqType.ITEM_ZM, 1, SeqType.NOD, SeqType.STR_ZO, SeqType.ITEM_ZM),
    _JSON_PARSE(FNJson.class, "parse(string)", SeqType.NOD, SeqType.STR),
    _JSON_PARSE_ML(FNJson.class, "parse-ml(string)", SeqType.NOD, SeqType.STR),
    _JSON_SERIALIZE(FNJson.class, "serialize(node)", SeqType.STR, SeqType.NOD),
    _JSON_SERIALIZE_ML(FNJson.class, "serialize-ml(node)", SeqType.STR, SeqType.NOD),
    _OUT_NL(FNOut.class, "nl()", SeqType.STR, new SeqType[0]),
    _OUT_TAB(FNOut.class, "tab()", SeqType.STR, new SeqType[0]),
    _OUT_FORMAT(FNOut.class, "format(format,item1[,...])", SeqType.STR, -2, SeqType.STR, SeqType.ITEM),
    _XQUERY_EVAL(FNXQuery.class, "eval(string[,bindings])", SeqType.ITEM_ZM, 1, SeqType.STR, SeqType.ITEM),
    _XQUERY_INVOKE(FNXQuery.class, "invoke(string[,bindings])", SeqType.ITEM_ZM, 1, SeqType.STR, SeqType.ITEM),
    _XQUERY_TYPE(FNXQuery.class, "type(expr)", SeqType.ITEM_ZM, SeqType.ITEM_ZM),
    _PROF_MEM(FNProf.class, "mem(expr[,cache[,label]])", SeqType.ITEM_ZM, 1, SeqType.ITEM_ZM, SeqType.BLN, SeqType.STR),
    _PROF_TIME(FNProf.class, "time(expr[,cache[,label]])", SeqType.ITEM_ZM, 1, SeqType.ITEM_ZM, SeqType.BLN, SeqType.STR),
    _PROF_SLEEP(FNProf.class, "sleep(ms)", SeqType.EMP, SeqType.ITR),
    _HASH_MD5(FNHash.class, "md5(value)", SeqType.B64, SeqType.AAT),
    _HASH_SHA1(FNHash.class, "sha1(value)", SeqType.B64, SeqType.AAT),
    _HASH_SHA256(FNHash.class, "sha256(value)", SeqType.B64, SeqType.AAT),
    _HASH_HASH(FNHash.class, "hash(value,algorithm)", SeqType.B64, SeqType.AAT, SeqType.STR),
    _VALIDATE_XSD(FNValidate.class, "xsd(input[,schema])", SeqType.EMP, 1, SeqType.ITEM, SeqType.ITEM),
    _VALIDATE_DTD(FNValidate.class, "dtd(input[,schema])", SeqType.EMP, 1, SeqType.ITEM, SeqType.ITEM),
    _XSLT_PROCESSOR(FNXslt.class, "processor()", SeqType.STR, new SeqType[0]),
    _XSLT_VERSION(FNXslt.class, "version()", SeqType.STR, new SeqType[0]),
    _XSLT_TRANSFORM(FNXslt.class, "transform(input,stylesheet[,params])", SeqType.NOD, 2, SeqType.ITEM, SeqType.ITEM, SeqType.NOD),
    _ZIP_BINARY_ENTRY(FNZip.class, "binary-entry(path,entry)", SeqType.B64, SeqType.STR, SeqType.STR),
    _ZIP_TEXT_ENTRY(FNZip.class, "text-entry(path,entry[,encoding])", SeqType.STR, 2, SeqType.STR, SeqType.STR, SeqType.STR),
    _ZIP_HTML_ENTRY(FNZip.class, "html-entry(path,entry)", SeqType.NOD, SeqType.STR, SeqType.STR),
    _ZIP_XML_ENTRY(FNZip.class, "xml-entry(path,entry)", SeqType.NOD, SeqType.STR, SeqType.STR),
    _ZIP_ENTRIES(FNZip.class, "entries(path)", SeqType.ELM, SeqType.STR),
    _ZIP_ZIP_FILE(FNZip.class, "zip-file(zip)", SeqType.EMP, SeqType.ELM),
    _ZIP_UPDATE_ENTRIES(FNZip.class, "update-entries(zip,output)", SeqType.EMP, SeqType.ELM, SeqType.STR);

    static final Function[] UPDATING;
    public static final HashMap<Class<? extends StandardFunc>, byte[]> URIS;
    public final int min;
    public final int max;
    public final SeqType[] args;
    final String desc;
    final SeqType ret;
    private final Class<? extends StandardFunc> func;
    private static final Pattern ARG;

    private Function(Class<? extends StandardFunc> fun, String dsc, SeqType r, SeqType ... typ) {
        this(fun, dsc, r, typ.length, typ);
    }

    private Function(Class<? extends StandardFunc> fun, String dsc, SeqType r, int m, SeqType ... typ) {
        this.func = fun;
        this.desc = dsc;
        this.ret = r;
        this.min = m < 0 ? -m : m;
        this.max = m < 0 ? Integer.MAX_VALUE : typ.length;
        this.args = typ;
    }

    public StandardFunc get(Expr ... arg) {
        return this.get((InputInfo)null, arg);
    }

    public StandardFunc get(InputInfo ii, Expr ... arg) {
        return (StandardFunc)Reflect.get(Reflect.find(this.func, InputInfo.class, Function.class, Expr[].class), new Object[]{ii, this, arg});
    }

    final byte[] uri() {
        byte[] u = URIS.get(this.func);
        return u == null ? QueryText.FNURI : u;
    }

    final FuncType type(int arity) {
        SeqType[] arg = new SeqType[arity];
        if (arity != 0 && this.max == Integer.MAX_VALUE) {
            System.arraycopy(this.args, 0, arg, 0, this.args.length);
            SeqType var = this.args[this.args.length - 1];
            for (int i = this.args.length; i < arg.length; ++i) {
                arg[i] = var;
            }
        } else {
            System.arraycopy(this.args, 0, arg, 0, arity);
        }
        return FuncType.get(this.ret, arg);
    }

    public final String args(Object ... arg) {
        TokenBuilder tb = new TokenBuilder();
        for (Object a : arg) {
            String s;
            if (!tb.isEmpty()) {
                tb.add(44);
            }
            if (ARG.matcher(s = a.toString()).matches() || a instanceof Integer) {
                tb.add(s);
                continue;
            }
            if (a instanceof Boolean) {
                tb.add(s + "()");
                continue;
            }
            tb.add('\"' + s.replaceAll("\"", "\"\"") + '\"');
        }
        return this.toString().replaceAll("\\(.*", "(") + tb + ')';
    }

    public final String toString() {
        byte[] pref = NSGlobal.prefix(this.uri());
        return new TokenBuilder(pref).add(58).add(this.desc).toString();
    }

    static {
        UPDATING = new Function[]{PUT, _DB_ADD, _DB_DELETE, _DB_RENAME, _DB_REPLACE, _DB_OPTIMIZE, _DB_STORE, _DB_OUTPUT, _DB_FLUSH};
        URIS = new HashMap();
        URIS.put(FNMap.class, QueryText.MAPURI);
        URIS.put(FNMath.class, QueryText.MATHURI);
        URIS.put(FNCrypto.class, QueryText.CRYPTOURI);
        URIS.put(FNFile.class, QueryText.FILEURI);
        URIS.put(FNHttp.class, QueryText.HTTPURI);
        URIS.put(FNZip.class, QueryText.ZIPURI);
        URIS.put(FNRepo.class, QueryText.REPOURI);
        URIS.put(FNArchive.class, QueryText.ARCHIVEURI);
        URIS.put(FNClient.class, QueryText.CLIENTURI);
        URIS.put(FNConvert.class, QueryText.CONVERTURI);
        URIS.put(FNDb.class, QueryText.DBURI);
        URIS.put(FNFt.class, QueryText.FTURI);
        URIS.put(FNHof.class, QueryText.HOFURI);
        URIS.put(FNHash.class, QueryText.HASHURI);
        URIS.put(FNIndex.class, QueryText.INDEXURI);
        URIS.put(FNJson.class, QueryText.JSONURI);
        URIS.put(FNOut.class, QueryText.OUTURI);
        URIS.put(FNProc.class, QueryText.PROCURI);
        URIS.put(FNProf.class, QueryText.PROFURI);
        URIS.put(FNSql.class, QueryText.SQLURI);
        URIS.put(FNValidate.class, QueryText.VALIDATEURI);
        URIS.put(FNXslt.class, QueryText.XSLTURI);
        URIS.put(FNXQuery.class, QueryText.XQUERYURI);
        ARG = Pattern.compile("^([-\\w_:\\.]*\\(|<|\"|\\$| ).*", 32);
    }
}

