/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Cast;
import org.basex.query.expr.Expr;
import org.basex.query.expr.VarRef;
import org.basex.query.func.Function;
import org.basex.query.func.JavaMapping;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.UserFunc;
import org.basex.query.func.UserFuncCall;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.TypedFunc;
import org.basex.query.util.Var;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Levenshtein;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class Functions
extends TokenSet {
    private static final Functions INSTANCE = new Functions();
    private Function[] funcs = new Function[8];

    public static Functions get() {
        return INSTANCE;
    }

    private Functions() {
        for (Function def : Function.values()) {
            String dsc = def.desc;
            byte[] ln = Token.token(dsc.substring(0, dsc.indexOf("(")));
            int i = this.add(new QNm(ln, def.uri()).eqname());
            if (i < 0) {
                Util.notexpected("Function defined twice:" + (Object)((Object)def));
            }
            this.funcs[i] = def;
        }
    }

    public StandardFunc get(QNm name, Expr[] args, QueryContext ctx, InputInfo ii) throws QueryException {
        int id = this.id(name.eqname());
        if (id == 0) {
            return null;
        }
        Function fl = this.funcs[id];
        if (!Token.eq(fl.uri(), name.uri())) {
            return null;
        }
        StandardFunc f = fl.get(ii, args);
        if (!ctx.sc.xquery3 && f.uses(Expr.Use.X30)) {
            Err.FEATURE30.thrw(ii, new Object[0]);
        }
        if (args.length < fl.min || args.length > fl.max) {
            Err.XPARGS.thrw(ii, new Object[]{fl});
        }
        return f;
    }

    public static FItem get(QNm name, long arity, boolean dyn, QueryContext ctx, InputInfo ii) throws QueryException {
        UserFunc usf;
        Expr[] args = new Expr[(int)arity];
        Var[] vars = new Var[args.length];
        for (int i = 0; i < args.length; ++i) {
            vars[i] = ctx.uniqueVar(ii, null);
            args[i] = new VarRef(ii, vars[i]);
        }
        TypedFunc f = Functions.get(name, args, dyn, ctx, ii);
        if (f == null) {
            if (!dyn) {
                Err.FUNCUNKNOWN.thrw(ii, name + "#" + arity);
            }
            return null;
        }
        if (dyn && f.fun instanceof UserFuncCall && (usf = ((UserFuncCall)f.fun).func()) != null && usf.declared) {
            usf.compile(ctx);
        }
        FuncType ft = f.type;
        return new FuncItem(name, vars, f.fun, ft, false);
    }

    public static TypedFunc get(QNm name, Expr[] args, boolean dyn, QueryContext ctx, InputInfo ii) throws QueryException {
        if (Token.eq(name.uri(), QueryText.XSURI)) {
            byte[] ln = name.local();
            AtomType type = AtomType.find(name, false);
            if (type == null) {
                Levenshtein ls = new Levenshtein();
                for (AtomType t : AtomType.values()) {
                    if (t.par == null || t == AtomType.NOT || t == AtomType.AAT || !ls.similar(Token.lc(ln), Token.lc(t.string()), 0)) continue;
                    Err.FUNSIMILAR.thrw(ii, name.string(), t.string());
                }
            }
            if (type == null || type == AtomType.NOT || type == AtomType.AAT) {
                Err.FUNCUNKNOWN.thrw(ii, new Object[]{name.string()});
            }
            if (args.length != 1) {
                Err.FUNCTYPE.thrw(ii, new Object[]{name.string()});
            }
            SeqType to = SeqType.get((Type)type, SeqType.Occ.ZERO_ONE);
            return TypedFunc.constr(new Cast(ii, args[0], to), to);
        }
        StandardFunc fun = Functions.get().get(name, args, ctx, ii);
        if (fun != null) {
            for (Function f : Function.UPDATING) {
                if (fun.sig != f) continue;
                ctx.updating(true);
                break;
            }
            return new TypedFunc(fun, fun.sig.type(args.length));
        }
        TypedFunc tf = ctx.funcs.get(name, args, ii);
        if (tf != null) {
            return tf;
        }
        JavaMapping jf = JavaMapping.get(name, args, ctx, ii);
        if (jf != null) {
            return TypedFunc.java(jf);
        }
        if (!dyn && FuncType.find(name) == null) {
            return ctx.funcs.add(name, args, ii);
        }
        return null;
    }

    public void error(QNm name, InputInfo ii) throws QueryException {
        byte[] ln = name.local();
        Levenshtein ls = new Levenshtein();
        for (int k = 1; k < this.size; ++k) {
            int i = Token.indexOf(this.keys[k], 125);
            byte[] u = Token.substring(this.keys[k], 1, i);
            byte[] l = Token.substring(this.keys[k], i + 1);
            if (Token.eq(ln, l)) {
                byte[] ur = name.uri();
                Err.FUNSIMILAR.thrw(ii, new TokenBuilder(NSGlobal.prefix(ur)).add(58).add(l), new TokenBuilder(NSGlobal.prefix(u)).add(58).add(l));
                continue;
            }
            if (!ls.similar(ln, l, 0)) continue;
            Err.FUNSIMILAR.thrw(ii, name.string(), l);
        }
    }

    @Override
    protected void rehash() {
        super.rehash();
        this.funcs = Arrays.copyOf(this.funcs, this.size << 1);
    }
}

