/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.JavaMapping;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class JavaFunc
extends JavaMapping {
    private final Class<?> cls;
    private final String mth;

    JavaFunc(InputInfo ii, Class<?> c, String m, Expr[] a) {
        super(ii, a);
        this.cls = c;
        this.mth = m;
    }

    @Override
    protected Object eval(Value[] args, QueryContext ctx) throws QueryException {
        try {
            return this.mth.equals("new") ? this.constructor(args) : this.method(args, ctx);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            throw cause instanceof QueryException ? ((QueryException)cause).info(this.info) : Err.JAVAERR.thrw(this.info, cause);
        }
        catch (Throwable ex) {
            throw Err.JAVAFUN.thrw(this.info, this.name(), JavaFunc.foundArgs(args));
        }
    }

    private Object constructor(Value[] ar) throws Exception {
        for (Constructor<?> con : this.cls.getConstructors()) {
            Object[] arg = JavaFunc.args(con.getParameterTypes(), ar, true);
            if (arg == null) continue;
            return con.newInstance(arg);
        }
        throw new Exception();
    }

    private Object method(Value[] ar, QueryContext ctx) throws Exception {
        try {
            Field f = this.cls.getField(this.mth);
            boolean st = Modifier.isStatic(f.getModifiers());
            if (ar.length == (st ? 0 : 1)) {
                return f.get(st ? null : this.instObj(ar[0]));
            }
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
        for (Method meth : this.cls.getMethods()) {
            if (!meth.getName().equals(this.mth)) continue;
            boolean st = Modifier.isStatic(meth.getModifiers());
            Object[] arg = JavaFunc.args(meth.getParameterTypes(), ar, st);
            if (arg == null) continue;
            Object inst = null;
            if (!st && (inst = this.instObj(ar[0])) instanceof QueryModule) {
                ((QueryModule)inst).context = ctx;
            }
            return meth.invoke(inst, arg);
        }
        throw new Exception();
    }

    private Object instObj(Value v) throws QueryException {
        return this.cls.isInstance(v) ? v : v.toJava();
    }

    private static Object[] args(Class<?>[] params, Value[] args, boolean stat) throws QueryException {
        int s = stat ? 0 : 1;
        int l = args.length - s;
        if (l != params.length) {
            return null;
        }
        Object[] val = new Object[l];
        int a = 0;
        for (Class<?> par : params) {
            Object next;
            Value arg = args[s + a];
            if (par.isInstance(arg)) {
                next = arg;
            } else {
                Type jtype = JavaFunc.type(par);
                if (jtype == null || !arg.type.instanceOf(jtype) && !jtype.instanceOf(arg.type)) {
                    return null;
                }
                next = arg.toJava();
            }
            val[a++] = next;
        }
        return val;
    }

    @Override
    public void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.cls + "." + this.mth), this.expr);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        if (this.mth.equals("new")) {
            sb.append("new").append(' ').append(this.cls.getSimpleName());
        } else {
            sb.append(this.name());
        }
        return sb.append("(...)").toString();
    }

    private String name() {
        return this.cls.getSimpleName() + '.' + this.mth;
    }

    @Override
    public String toString() {
        return this.cls + "." + this.mth + "(" + this.toString(", ") + ")";
    }
}

