/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.nio.charset.Charset;
import java.util.HashMap;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public abstract class StandardFunc
extends Arr {
    Function sig;

    StandardFunc(InputInfo ii, Function s, Expr ... args) {
        super(ii, args);
        this.sig = s;
        this.type = this.sig.ret;
    }

    @Override
    public final Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        return this.optPre(this.uses(Expr.Use.CTX) || this.uses(Expr.Use.NDT) || !this.allAreValues() ? this.comp(ctx) : (this.sig.ret.zeroOrOne() ? this.item(ctx, this.info) : this.value(ctx)), ctx);
    }

    Expr comp(QueryContext ctx) throws QueryException {
        return this;
    }

    public static final Item atom(Item it, InputInfo ii) throws QueryException {
        Type ip = it.type;
        return ip.isNode() ? (ip == NodeType.PI || ip == NodeType.COM ? Str.get(it.string(ii)) : new Atm(it.string(ii))) : it;
    }

    @Override
    public final boolean isFunction(Function f) {
        return this.sig == f;
    }

    @Override
    public final boolean isVacuous() {
        return !this.uses(Expr.Use.UPD) && this.type == SeqType.EMP;
    }

    @Override
    public final String description() {
        return this.sig.toString();
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this.sig.desc), this.expr);
    }

    @Override
    public final String toString() {
        String desc = this.sig.toString();
        return new TokenBuilder(desc.substring(0, desc.indexOf(40) + 1)).addSep(this.expr, ", ").add(")").toString();
    }

    Data data(int i, QueryContext ctx) throws QueryException {
        Item it = this.checkNoEmpty(this.expr[i].item(ctx, this.info));
        Type ip = it.type;
        if (ip.isNode()) {
            return this.checkDBNode((Item)it).data;
        }
        if (ip.isString()) {
            String name = Token.string(it.string(this.info));
            if (!MetaData.validName(name, false)) {
                Err.INVDB.thrw(this.info, name);
            }
            return ctx.resource.data(name, this.info);
        }
        throw Err.STRNODTYPE.thrw(this.info, this, ip);
    }

    public String encoding(int i, Err err, QueryContext ctx) throws QueryException {
        if (i >= this.expr.length) {
            return null;
        }
        String enc = Token.string(this.checkStr(this.expr[i], ctx));
        if (!Charset.isSupported(enc)) {
            err.thrw(this.info, enc);
        }
        return Token.normEncoding(enc);
    }

    HashMap<String, Value> bindings(int i, QueryContext ctx) throws QueryException {
        HashMap<String, Value> hm = new HashMap<String, Value>();
        if (i < this.expr.length) {
            Map map = this.checkMap(this.expr[i].item(ctx, this.info));
            for (Item it : map.keys()) {
                byte[] key;
                if (it.type.isString()) {
                    key = it.string(null);
                } else {
                    QNm qnm = (QNm)this.checkType(it, AtomType.QNM);
                    TokenBuilder tb = new TokenBuilder();
                    if (qnm.uri() != null) {
                        tb.add(123).add(qnm.uri()).add(125);
                    }
                    key = tb.add(qnm.local()).finish();
                }
                hm.put(Token.string(key), map.get(it, this.info));
            }
        }
        return hm;
    }

    protected static boolean oneOf(Function sig, Function ... sigs) {
        for (Function s : sigs) {
            if (sig != s) continue;
            return true;
        }
        return false;
    }
}

