/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.Ann;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.query.util.VarStack;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public class UserFunc
extends Single {
    public final QNm name;
    public final Var[] args;
    public final boolean declared;
    public final SeqType ret;
    public final Ann ann;
    public final boolean updating;
    private boolean cast;
    private boolean compiled;

    public UserFunc(InputInfo ii, QNm n, Var[] v, SeqType r, Ann a) {
        this(ii, n, v, r, a, true);
    }

    public UserFunc(InputInfo ii, QNm n, Var[] v, SeqType r, Ann a, boolean d) {
        super(ii, null);
        this.name = n;
        this.args = v;
        this.ret = r;
        this.cast = r != null;
        this.ann = a == null ? new Ann() : a;
        this.declared = d;
        this.updating = this.ann.contains(Ann.Q_UPDATING);
    }

    @Override
    public final void checkUp() throws QueryException {
        boolean u = this.expr.uses(Expr.Use.UPD);
        if (u) {
            this.expr.checkUp();
        }
        if (this.updating) {
            if (this.ret != null) {
                Err.UPFUNCTYPE.thrw(this.info, new Object[0]);
            }
            if (!u && !this.expr.isVacuous()) {
                Err.UPEXPECTF.thrw(this.info, new Object[0]);
            }
        } else if (u) {
            Err.UPNOT.thrw(this.info, this.description());
        }
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        this.compile(ctx, true);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compile(QueryContext ctx, boolean cache) throws QueryException {
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        int vs = ctx.vars.size();
        VarStack vl = cache ? ctx.vars.cache(this.args.length) : null;
        try {
            for (Var v : this.args) {
                ctx.vars.add(v);
            }
            this.expr = this.expr.compile(ctx);
        }
        finally {
            if (cache) {
                ctx.vars.reset(vl);
            } else {
                ctx.vars.size(vs);
            }
        }
        if (this.tco()) {
            this.expr = this.expr.markTailCalls();
        }
        if (this.ret == null) {
            return;
        }
        this.type = this.ret;
        if ((this.ret.type == AtomType.BLN || this.ret.type == AtomType.FLT || this.ret.type == AtomType.DBL || this.ret.type == AtomType.QNM || this.ret.type == AtomType.URI) && this.ret.eq(this.expr.type())) {
            ctx.compInfo("removing redundant % cast.", this.ret);
            this.cast = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Value cv = ctx.value;
        Atts ns = ctx.sc.ns.reset();
        ctx.value = null;
        try {
            Item it = this.expr.item(ctx, ii);
            Item item = this.cast ? this.ret.cast(it, false, ctx, this.info, this) : it;
            return item;
        }
        finally {
            ctx.value = cv;
            ctx.sc.ns.stack(ns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext ctx) throws QueryException {
        Value cv = ctx.value;
        Atts ns = ctx.sc.ns.reset();
        ctx.value = null;
        try {
            Value v = ctx.value(this.expr);
            Value value = this.cast ? this.ret.promote(v, ctx, this.info) : v;
            return value;
        }
        finally {
            ctx.value = cv;
            ctx.sc.ns.stack(ns);
        }
    }

    @Override
    public ValueIter iter(QueryContext ctx) throws QueryException {
        return this.value(ctx).iter();
    }

    @Override
    public void plan(FElem plan) {
        FElem el = this.planElem(QueryText.NAM, this.name.string());
        this.addPlan(plan, el, this.expr);
        for (int i = 0; i < this.args.length; ++i) {
            el.add(this.planAttr("arg" + i, this.args[i].name.string()));
        }
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("declare").add(32).addExt(this.ann, new Object[0]);
        if (this.updating) {
            tb.add("updating").add(32);
        }
        tb.add("function").add(32).add(this.name.string());
        tb.add("(").addSep(this.args, ", ").add(")");
        if (this.ret != null) {
            tb.add(" as " + this.ret);
        }
        if (this.expr != null) {
            tb.add(" { " + this.expr + " }; ");
        }
        return tb.toString();
    }

    boolean tco() {
        return true;
    }
}

