/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.func.UserFunc;
import org.basex.query.util.Var;
import org.basex.query.util.VarStack;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public abstract class UserFuncCall
extends Arr {
    final QNm name;
    UserFunc func;

    UserFuncCall(InputInfo ii, QNm nm, Expr ... arg) {
        super(ii, arg);
        this.name = nm;
    }

    @Override
    public Expr compile(QueryContext ctx) throws QueryException {
        super.compile(ctx);
        this.func.compile(ctx);
        if (this.func.expr.isValue() && this.allAreValues() && !this.func.uses(Expr.Use.NDT)) {
            for (int a = 0; a < this.expr.length; ++a) {
                this.func.args[a].bind(this.expr[a], ctx);
            }
            ctx.compInfo("inlining function %(...)", new Object[]{this.func.name.string()});
            return this.func.value(ctx);
        }
        this.type = this.func.type();
        return this;
    }

    static VarStack addArgs(QueryContext ctx, Var[] vs) {
        VarStack vl = ctx.vars.cache(vs.length);
        for (Var v : vs) {
            ctx.vars.add(v);
        }
        return vl;
    }

    Var[] args(QueryContext ctx) throws QueryException {
        int al = this.expr.length;
        Var[] args = new Var[al];
        for (int a = 0; a < al; ++a) {
            args[a] = this.func.args[a].bind(this.expr[a].value(ctx), ctx).copy();
        }
        return args;
    }

    public void init(UserFunc f) {
        this.func = f;
    }

    final UserFunc func() {
        return this.func;
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.UPD ? this.func.updating : super.uses(u);
    }

    @Override
    public final void plan(FElem plan) {
        this.addPlan(plan, this.planElem(QueryText.NAM, this), this.expr);
    }

    @Override
    public String description() {
        return "Function";
    }

    @Override
    public String toString() {
        return new TokenBuilder(this.name.string()).add("(").add(this.toString(", ")).add(")").toString();
    }

    final class Continuation
    extends RuntimeException {
        private final Var[] args;

        Continuation(Var[] arg) {
            this.args = arg;
        }

        Expr getFunc() {
            return UserFuncCall.this.func;
        }

        Var[] getArgs() {
            return this.args;
        }

        @Override
        public synchronized Continuation fillInStackTrace() {
            return this;
        }
    }
}

